/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitterRegexImpl;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class GsubWorkerForLatin
implements GsubWorker {
    private static final Log LOG = LogFactory.getLog(GsubWorkerForLatin.class);
    private static final List<String> FEATURES_IN_ORDER = Arrays.asList("ccmp", "liga", "clig");
    private final CmapLookup cmapLookup;
    private final GsubData gsubData;

    GsubWorkerForLatin(CmapLookup cmapLookup, GsubData gsubData) {
        this.cmapLookup = cmapLookup;
        this.gsubData = gsubData;
    }

    @Override
    public List<Integer> applyTransforms(List<Integer> list) {
        for (String string : FEATURES_IN_ORDER) {
            if (!this.gsubData.isFeatureSupported(string)) {
                LOG.debug((Object)("the feature " + string + " was not found"));
                continue;
            }
            LOG.debug((Object)("applying the feature " + string));
            ScriptFeature scriptFeature = this.gsubData.getFeature(string);
            list = this.applyGsubFeature(scriptFeature, list);
        }
        return Collections.unmodifiableList(list);
    }

    private List<Integer> applyGsubFeature(ScriptFeature scriptFeature, List<Integer> list) {
        if (scriptFeature.getAllGlyphIdsForSubstitution().isEmpty()) {
            LOG.debug((Object)("getAllGlyphIdsForSubstitution() for " + scriptFeature.getName() + " is empty"));
            return list;
        }
        Iterator iterator = new GlyphArraySplitterRegexImpl(scriptFeature.getAllGlyphIdsForSubstitution());
        iterator = iterator.split(list);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            if (scriptFeature.canReplaceGlyphs(list2)) {
                int n = scriptFeature.getReplacementForGlyphs(list2);
                arrayList.add(n);
                continue;
            }
            arrayList.addAll(list2);
        }
        LOG.debug((Object)("originalGlyphs: " + list + ", gsubProcessedGlyphs: " + arrayList));
        return arrayList;
    }
}

