/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.ScreenFloatValueRegEx;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringBuilderKt;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000X\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0005H\u0082\b\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\r\u0010\b\u001a\u00020\t*\u00020\u0003H\u0087\b\u001a\u0015\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0087\b\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\t*\u00020\u0003H\u0007\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\r\u0010\r\u001a\u00020\u000e*\u00020\u0003H\u0087\b\u001a\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u0003H\u0007\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u000f\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u0003H\u0087\b\u001a\r\u0010\u0014\u001a\u00020\u0015*\u00020\u0003H\u0087\b\u001a\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\r\u0010\u0016\u001a\u00020\u0017*\u00020\u0003H\u0087\b\u001a\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0017*\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0019\u001a\r\u0010\u001a\u001a\u00020\u001b*\u00020\u0003H\u0087\b\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001b*\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u001d\u001a\r\u0010\u001e\u001a\u00020\u0010*\u00020\u0003H\u0087\b\u001a\u0015\u0010\u001e\u001a\u00020\u0010*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\r\u0010\u001f\u001a\u00020 *\u00020\u0003H\u0087\b\u001a\u0015\u0010\u001f\u001a\u00020 *\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\r\u0010!\u001a\u00020\"*\u00020\u0003H\u0087\b\u001a\u0015\u0010!\u001a\u00020\"*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\u0015\u0010#\u001a\u00020\u0003*\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\u0015\u0010#\u001a\u00020\u0003*\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\u0015\u0010#\u001a\u00020\u0003*\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u001a\u0015\u0010#\u001a\u00020\u0003*\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087\b\u00a8\u0006$"}, d2={"screenFloatValue", "T", "str", "", "parse", "Lkotlin/Function1;", "screenFloatValue$StringsKt__StringNumberConversionsJVMKt", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toBigDecimal", "Ljava/math/BigDecimal;", "mathContext", "Ljava/math/MathContext;", "toBigDecimalOrNull", "toBigInteger", "Ljava/math/BigInteger;", "radix", "", "toBigIntegerOrNull", "toBoolean", "", "toByte", "", "toDouble", "", "toDoubleOrNull", "(Ljava/lang/String;)Ljava/lang/Double;", "toFloat", "", "toFloatOrNull", "(Ljava/lang/String;)Ljava/lang/Float;", "toInt", "toLong", "", "toShort", "", "toString", "kotlin-stdlib"}, xs="kotlin/text/StringsKt")
class StringsKt__StringNumberConversionsJVMKt
extends StringsKt__StringBuilderKt {
    private static final String toString(byte by, int n) {
        String string = Integer.toString(by, CharsKt.checkRadix(n));
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    private static final String toString(short s, int n) {
        String string = Integer.toString(s, CharsKt.checkRadix(n));
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    private static final String toString(int n, int n2) {
        String string = Integer.toString(n, CharsKt.checkRadix(n2));
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    private static final String toString(long l, int n) {
        String string = Long.toString(l, CharsKt.checkRadix(n));
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    private static final boolean toBoolean(String string) {
        return Boolean.parseBoolean(string);
    }

    private static final byte toByte(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return Byte.parseByte(string);
    }

    private static final byte toByte(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        return Byte.parseByte(string, CharsKt.checkRadix(n));
    }

    private static final short toShort(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return Short.parseShort(string);
    }

    private static final short toShort(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        return Short.parseShort(string, CharsKt.checkRadix(n));
    }

    private static final int toInt(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return Integer.parseInt(string);
    }

    private static final int toInt(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        return Integer.parseInt(string, CharsKt.checkRadix(n));
    }

    private static final long toLong(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return Long.parseLong(string);
    }

    private static final long toLong(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        return Long.parseLong(string, CharsKt.checkRadix(n));
    }

    private static final float toFloat(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return Float.parseFloat(string);
    }

    private static final double toDouble(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return Double.parseDouble(string);
    }

    public static final Float toFloatOrNull(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        try {
            string = ScreenFloatValueRegEx.value.matches(string) ? Float.valueOf(Float.parseFloat(string)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        return string;
    }

    public static final Double toDoubleOrNull(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        try {
            string = ScreenFloatValueRegEx.value.matches(string) ? Double.valueOf(Double.parseDouble(string)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        return string;
    }

    private static final BigInteger toBigInteger(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return new BigInteger(string);
    }

    private static final BigInteger toBigInteger(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        return new BigInteger(string, CharsKt.checkRadix(n));
    }

    public static final BigInteger toBigIntegerOrNull(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return StringsKt.toBigIntegerOrNull(string, 10);
    }

    public static final BigInteger toBigIntegerOrNull(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        CharsKt.checkRadix(n);
        int n2 = string.length();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                if (CharsKt.digitOf(string.charAt(0), n) >= 0) break;
                return null;
            }
            default: {
                int n3 = string.charAt(0) == '-' ? 1 : 0;
                for (n3 = n3; n3 < n2; ++n3) {
                    if (CharsKt.digitOf(string.charAt(n3), n) >= 0) continue;
                    return null;
                }
            }
        }
        return new BigInteger(string, CharsKt.checkRadix(n));
    }

    private static final BigDecimal toBigDecimal(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return new BigDecimal(string);
    }

    private static final BigDecimal toBigDecimal(String string, MathContext mathContext) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(mathContext, "");
        return new BigDecimal(string, mathContext);
    }

    public static final BigDecimal toBigDecimalOrNull(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        try {
            string = ScreenFloatValueRegEx.value.matches(string) ? new BigDecimal(string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        return string;
    }

    public static final BigDecimal toBigDecimalOrNull(String string, MathContext mathContext) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(mathContext, "");
        try {
            string = ScreenFloatValueRegEx.value.matches(string) ? new BigDecimal(string, mathContext) : null;
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        return string;
    }

    private static final <T> T screenFloatValue$StringsKt__StringNumberConversionsJVMKt(String string, Function1<? super String, ? extends T> function1) {
        try {
            string = ScreenFloatValueRegEx.value.matches(string) ? function1.invoke(string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            string = null;
        }
        return (T)string;
    }
}

