/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConfig$DateClass;
import org.sqlite.SQLiteConfig$DatePrecision;
import org.sqlite.SQLiteConfig$Encoding;
import org.sqlite.SQLiteConfig$HexKeyMode;
import org.sqlite.SQLiteConfig$JournalMode;
import org.sqlite.SQLiteConfig$LockingMode;
import org.sqlite.SQLiteConfig$Pragma;
import org.sqlite.SQLiteConfig$PragmaValue;
import org.sqlite.SQLiteConfig$SynchronousMode;
import org.sqlite.SQLiteConfig$TempStore;
import org.sqlite.SQLiteConfig$TransactionMode;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.SQLiteLimits;
import org.sqlite.SQLiteOpenMode;

public class SQLiteConfig {
    public static final String DEFAULT_DATE_STRING_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final int DEFAULT_MAX_LENGTH = 1000000000;
    private static final int DEFAULT_MAX_COLUMN = 2000;
    private static final int DEFAULT_MAX_SQL_LENGTH = 1000000;
    private static final int DEFAULT_MAX_FUNCTION_ARG = 100;
    private static final int DEFAULT_MAX_ATTACHED = 10;
    private static final int DEFAULT_MAX_PAGE_COUNT = 0x3FFFFFFF;
    private final Properties pragmaTable;
    private int openModeFlag = 0;
    private int busyTimeout;
    private boolean explicitReadOnly;
    private final SQLiteConnectionConfig defaultConnectionConfig;
    private static final String[] OnOff = new String[]{"true", "false"};
    static final Set<String> pragmaSet = new TreeSet<String>();

    public SQLiteConfig() {
        this(new Properties());
    }

    public SQLiteConfig(Properties object) {
        this.pragmaTable = object;
        object = this.pragmaTable.getProperty(SQLiteConfig$Pragma.OPEN_MODE.pragmaName);
        if (object != null) {
            this.openModeFlag = Integer.parseInt((String)object);
        } else {
            this.setOpenMode(SQLiteOpenMode.READWRITE);
            this.setOpenMode(SQLiteOpenMode.CREATE);
        }
        SQLiteConfig sQLiteConfig = this;
        sQLiteConfig.setSharedCache(Boolean.parseBoolean(sQLiteConfig.pragmaTable.getProperty(SQLiteConfig$Pragma.SHARED_CACHE.pragmaName, "false")));
        this.setOpenMode(SQLiteOpenMode.OPEN_URI);
        SQLiteConfig sQLiteConfig2 = this;
        sQLiteConfig2.setBusyTimeout(Integer.parseInt(sQLiteConfig2.pragmaTable.getProperty(SQLiteConfig$Pragma.BUSY_TIMEOUT.pragmaName, "3000")));
        this.defaultConnectionConfig = SQLiteConnectionConfig.fromPragmaTable(this.pragmaTable);
        this.explicitReadOnly = Boolean.parseBoolean(this.pragmaTable.getProperty(SQLiteConfig$Pragma.JDBC_EXPLICIT_READONLY.pragmaName, "false"));
    }

    public SQLiteConnectionConfig newConnectionConfig() {
        return this.defaultConnectionConfig.copyConfig();
    }

    public Connection createConnection(String string) {
        return JDBC.createConnection(string, this.toProperties());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply(Connection object) {
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        for (SQLiteConfig$Pragma sQLiteConfig$Pragma : SQLiteConfig$Pragma.values()) {
            hashSet.add(sQLiteConfig$Pragma.pragmaName);
        }
        if (object instanceof SQLiteConnection) {
            object2 = (SQLiteConnection)object;
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_ATTACHED, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_ATTACHED, 10));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_COLUMN, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_COLUMN, 2000));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_COMPOUND_SELECT, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_COMPOUND_SELECT, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_EXPR_DEPTH, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_EXPR_DEPTH, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_FUNCTION_ARG, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_FUNCTION_ARG, 100));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_LENGTH, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_LENGTH, 1000000000));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_LIKE_PATTERN_LENGTH, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_LIKE_PATTERN_LENGTH, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_SQL_LENGTH, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_SQL_LENGTH, 1000000));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_TRIGGER_DEPTH, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_TRIGGER_DEPTH, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_VARIABLE_NUMBER, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_VARIABLE_NUMBER, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_VDBE_OP, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_VDBE_OP, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_WORKER_THREADS, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_WORKER_THREADS, -1));
            ((SQLiteConnection)object2).setLimit(SQLiteLimits.SQLITE_LIMIT_PAGE_COUNT, this.parseLimitPragma(SQLiteConfig$Pragma.LIMIT_PAGE_COUNT, 0x3FFFFFFF));
        }
        hashSet.remove(SQLiteConfig$Pragma.OPEN_MODE.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.SHARED_CACHE.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LOAD_EXTENSION.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.DATE_CLASS.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.PASSWORD.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.HEXKEY_MODE.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_ATTACHED.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_COLUMN.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_COMPOUND_SELECT.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_EXPR_DEPTH.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_FUNCTION_ARG.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_LENGTH.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_LIKE_PATTERN_LENGTH.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_SQL_LENGTH.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_TRIGGER_DEPTH.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_VARIABLE_NUMBER.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_VDBE_OP.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_WORKER_THREADS.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LIMIT_PAGE_COUNT.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.JDBC_EXPLICIT_READONLY.pragmaName);
        object2 = object.createStatement();
        try {
            String string;
            if (this.pragmaTable.containsKey(SQLiteConfig$Pragma.PASSWORD.pragmaName) && (string = this.pragmaTable.getProperty(SQLiteConfig$Pragma.PASSWORD.pragmaName)) != null && !string.isEmpty()) {
                void var6_15;
                String string2 = this.pragmaTable.getProperty(SQLiteConfig$Pragma.HEXKEY_MODE.pragmaName);
                if (SQLiteConfig$HexKeyMode.SSE.name().equalsIgnoreCase(string2)) {
                    String string3 = "pragma hexkey = '%s'";
                } else if (SQLiteConfig$HexKeyMode.SQLCIPHER.name().equalsIgnoreCase(string2)) {
                    String string4 = "pragma key = \"x'%s'\"";
                } else {
                    String string5 = "pragma key = '%s'";
                }
                object2.execute(String.format((String)var6_15, string.replace("'", "''")));
                object2.execute("select 1 from sqlite_schema");
            }
            for (Object object3 : this.pragmaTable.keySet()) {
                String string6 = object3.toString();
                if (!hashSet.contains(string6) || (object = this.pragmaTable.getProperty(string6)) == null) continue;
                object2.execute(String.format("pragma %s=%s", string6, object));
            }
            if (object2 == null) return;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            object2.close();
            throw throwable;
        }
        object2.close();
    }

    private void set(SQLiteConfig$Pragma sQLiteConfig$Pragma, boolean bl) {
        this.setPragma(sQLiteConfig$Pragma, Boolean.toString(bl));
    }

    private void set(SQLiteConfig$Pragma sQLiteConfig$Pragma, int n) {
        this.setPragma(sQLiteConfig$Pragma, Integer.toString(n));
    }

    private boolean getBoolean(SQLiteConfig$Pragma sQLiteConfig$Pragma, String string) {
        return Boolean.parseBoolean(this.pragmaTable.getProperty(sQLiteConfig$Pragma.pragmaName, string));
    }

    private int parseLimitPragma(SQLiteConfig$Pragma object, int n) {
        if (!this.pragmaTable.containsKey(object.pragmaName)) {
            return n;
        }
        object = this.pragmaTable.getProperty(object.pragmaName);
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public boolean isEnabledSharedCache() {
        return this.getBoolean(SQLiteConfig$Pragma.SHARED_CACHE, "false");
    }

    public boolean isEnabledLoadExtension() {
        return this.getBoolean(SQLiteConfig$Pragma.LOAD_EXTENSION, "false");
    }

    public int getOpenModeFlags() {
        return this.openModeFlag;
    }

    public void setPragma(SQLiteConfig$Pragma sQLiteConfig$Pragma, String string) {
        this.pragmaTable.put(sQLiteConfig$Pragma.pragmaName, string);
    }

    public Properties toProperties() {
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.OPEN_MODE.pragmaName, Integer.toString(this.openModeFlag));
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.TRANSACTION_MODE.pragmaName, this.defaultConnectionConfig.getTransactionMode().getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_CLASS.pragmaName, this.defaultConnectionConfig.getDateClass().getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName, this.defaultConnectionConfig.getDatePrecision().getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName, this.defaultConnectionConfig.getDateStringFormat());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.JDBC_EXPLICIT_READONLY.pragmaName, this.explicitReadOnly ? "true" : "false");
        return this.pragmaTable;
    }

    static DriverPropertyInfo[] getDriverPropertyInfo() {
        Object[] objectArray = SQLiteConfig$Pragma.values();
        objectArray = new DriverPropertyInfo[objectArray.length];
        int n = 0;
        for (SQLiteConfig$Pragma sQLiteConfig$Pragma : SQLiteConfig$Pragma.values()) {
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(sQLiteConfig$Pragma.pragmaName, null);
            new DriverPropertyInfo(sQLiteConfig$Pragma.pragmaName, null).choices = sQLiteConfig$Pragma.choices;
            driverPropertyInfo.description = sQLiteConfig$Pragma.description;
            driverPropertyInfo.required = false;
            objectArray[n++] = driverPropertyInfo;
        }
        return objectArray;
    }

    public boolean isExplicitReadOnly() {
        return this.explicitReadOnly;
    }

    public void setExplicitReadOnly(boolean bl) {
        this.explicitReadOnly = bl;
    }

    public void setOpenMode(SQLiteOpenMode sQLiteOpenMode) {
        this.openModeFlag |= sQLiteOpenMode.flag;
    }

    public void resetOpenMode(SQLiteOpenMode sQLiteOpenMode) {
        this.openModeFlag &= ~sQLiteOpenMode.flag;
    }

    public void setSharedCache(boolean bl) {
        this.set(SQLiteConfig$Pragma.SHARED_CACHE, bl);
    }

    public void enableLoadExtension(boolean bl) {
        this.set(SQLiteConfig$Pragma.LOAD_EXTENSION, bl);
    }

    public void setReadOnly(boolean bl) {
        if (bl) {
            this.setOpenMode(SQLiteOpenMode.READONLY);
            this.resetOpenMode(SQLiteOpenMode.CREATE);
            this.resetOpenMode(SQLiteOpenMode.READWRITE);
            return;
        }
        this.setOpenMode(SQLiteOpenMode.READWRITE);
        this.setOpenMode(SQLiteOpenMode.CREATE);
        this.resetOpenMode(SQLiteOpenMode.READONLY);
    }

    public void setCacheSize(int n) {
        this.set(SQLiteConfig$Pragma.CACHE_SIZE, n);
    }

    public void enableCaseSensitiveLike(boolean bl) {
        this.set(SQLiteConfig$Pragma.CASE_SENSITIVE_LIKE, bl);
    }

    @Deprecated
    public void enableCountChanges(boolean bl) {
        this.set(SQLiteConfig$Pragma.COUNT_CHANGES, bl);
    }

    public void setDefaultCacheSize(int n) {
        this.set(SQLiteConfig$Pragma.DEFAULT_CACHE_SIZE, n);
    }

    public void deferForeignKeys(boolean bl) {
        this.set(SQLiteConfig$Pragma.DEFER_FOREIGN_KEYS, bl);
    }

    @Deprecated
    public void enableEmptyResultCallBacks(boolean bl) {
        this.set(SQLiteConfig$Pragma.EMPTY_RESULT_CALLBACKS, bl);
    }

    private static String[] toStringArray(SQLiteConfig$PragmaValue[] sQLiteConfig$PragmaValueArray) {
        String[] stringArray = new String[sQLiteConfig$PragmaValueArray.length];
        for (int i = 0; i < sQLiteConfig$PragmaValueArray.length; ++i) {
            stringArray[i] = sQLiteConfig$PragmaValueArray[i].getValue();
        }
        return stringArray;
    }

    public void setEncoding(SQLiteConfig$Encoding sQLiteConfig$Encoding) {
        this.setPragma(SQLiteConfig$Pragma.ENCODING, sQLiteConfig$Encoding.typeName);
    }

    public void enforceForeignKeys(boolean bl) {
        this.set(SQLiteConfig$Pragma.FOREIGN_KEYS, bl);
    }

    @Deprecated
    public void enableFullColumnNames(boolean bl) {
        this.set(SQLiteConfig$Pragma.FULL_COLUMN_NAMES, bl);
    }

    public void enableFullSync(boolean bl) {
        this.set(SQLiteConfig$Pragma.FULL_SYNC, bl);
    }

    public void incrementalVacuum(int n) {
        this.set(SQLiteConfig$Pragma.INCREMENTAL_VACUUM, n);
    }

    public void setJournalMode(SQLiteConfig$JournalMode sQLiteConfig$JournalMode) {
        this.setPragma(SQLiteConfig$Pragma.JOURNAL_MODE, sQLiteConfig$JournalMode.name());
    }

    public void setJounalSizeLimit(int n) {
        this.set(SQLiteConfig$Pragma.JOURNAL_SIZE_LIMIT, n);
    }

    public void useLegacyFileFormat(boolean bl) {
        this.set(SQLiteConfig$Pragma.LEGACY_FILE_FORMAT, bl);
    }

    public void setLegacyAlterTable(boolean bl) {
        this.set(SQLiteConfig$Pragma.LEGACY_ALTER_TABLE, bl);
    }

    public void setLockingMode(SQLiteConfig$LockingMode sQLiteConfig$LockingMode) {
        this.setPragma(SQLiteConfig$Pragma.LOCKING_MODE, sQLiteConfig$LockingMode.name());
    }

    public void setPageSize(int n) {
        this.set(SQLiteConfig$Pragma.PAGE_SIZE, n);
    }

    public void setMaxPageCount(int n) {
        this.set(SQLiteConfig$Pragma.MAX_PAGE_COUNT, n);
    }

    public void setReadUncommited(boolean bl) {
        this.set(SQLiteConfig$Pragma.READ_UNCOMMITTED, bl);
    }

    public void enableRecursiveTriggers(boolean bl) {
        this.set(SQLiteConfig$Pragma.RECURSIVE_TRIGGERS, bl);
    }

    public void enableReverseUnorderedSelects(boolean bl) {
        this.set(SQLiteConfig$Pragma.REVERSE_UNORDERED_SELECTS, bl);
    }

    public void enableShortColumnNames(boolean bl) {
        this.set(SQLiteConfig$Pragma.SHORT_COLUMN_NAMES, bl);
    }

    public void setSynchronous(SQLiteConfig$SynchronousMode sQLiteConfig$SynchronousMode) {
        this.setPragma(SQLiteConfig$Pragma.SYNCHRONOUS, sQLiteConfig$SynchronousMode.name());
    }

    public void setHexKeyMode(SQLiteConfig$HexKeyMode sQLiteConfig$HexKeyMode) {
        this.setPragma(SQLiteConfig$Pragma.HEXKEY_MODE, sQLiteConfig$HexKeyMode.name());
    }

    public void setTempStore(SQLiteConfig$TempStore sQLiteConfig$TempStore) {
        this.setPragma(SQLiteConfig$Pragma.TEMP_STORE, sQLiteConfig$TempStore.name());
    }

    public void setTempStoreDirectory(String string) {
        this.setPragma(SQLiteConfig$Pragma.TEMP_STORE_DIRECTORY, String.format("'%s'", string));
    }

    public void setUserVersion(int n) {
        this.set(SQLiteConfig$Pragma.USER_VERSION, n);
    }

    public void setApplicationId(int n) {
        this.set(SQLiteConfig$Pragma.APPLICATION_ID, n);
    }

    public void setTransactionMode(SQLiteConfig$TransactionMode sQLiteConfig$TransactionMode) {
        this.defaultConnectionConfig.setTransactionMode(sQLiteConfig$TransactionMode);
    }

    public void setTransactionMode(String string) {
        this.setTransactionMode(SQLiteConfig$TransactionMode.getMode(string));
    }

    public SQLiteConfig$TransactionMode getTransactionMode() {
        return this.defaultConnectionConfig.getTransactionMode();
    }

    public void setDatePrecision(String string) {
        this.defaultConnectionConfig.setDatePrecision(SQLiteConfig$DatePrecision.getPrecision(string));
    }

    public void setDateClass(String string) {
        this.defaultConnectionConfig.setDateClass(SQLiteConfig$DateClass.getDateClass(string));
    }

    public void setDateStringFormat(String string) {
        this.defaultConnectionConfig.setDateStringFormat(string);
    }

    public void setBusyTimeout(int n) {
        this.setPragma(SQLiteConfig$Pragma.BUSY_TIMEOUT, Integer.toString(n));
        this.busyTimeout = n;
    }

    public int getBusyTimeout() {
        return this.busyTimeout;
    }

    static /* synthetic */ String[] access$000() {
        return OnOff;
    }

    static /* synthetic */ String[] access$100(SQLiteConfig$PragmaValue[] sQLiteConfig$PragmaValueArray) {
        return SQLiteConfig.toStringArray(sQLiteConfig$PragmaValueArray);
    }

    static {
        for (SQLiteConfig$Pragma sQLiteConfig$Pragma : SQLiteConfig$Pragma.values()) {
            pragmaSet.add(sQLiteConfig$Pragma.pragmaName);
        }
    }
}

