/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.DesktopWindow;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$1;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$2;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$3;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$4;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$5;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.PsapiUtil;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$HDC;
import com.sun.jna.platform.win32.WinDef$HICON;
import com.sun.jna.platform.win32.WinDef$HRGN;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinDef$LPARAM;
import com.sun.jna.platform.win32.WinDef$LRESULT;
import com.sun.jna.platform.win32.WinDef$POINT;
import com.sun.jna.platform.win32.WinDef$RECT;
import com.sun.jna.platform.win32.WinDef$WPARAM;
import com.sun.jna.platform.win32.WinGDI$BITMAP;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFO;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFOHEADER;
import com.sun.jna.platform.win32.WinGDI$ICONINFO;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.ptr.IntByReference;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;

class WindowUtils$W32WindowUtils
extends WindowUtils$NativeWindowUtils {
    private WindowUtils$W32WindowUtils() {
    }

    private WinDef$HWND getHWnd(Component component) {
        WinDef$HWND winDef$HWND = new WinDef$HWND();
        winDef$HWND.setPointer(Native.getComponentPointer((Component)component));
        return winDef$HWND;
    }

    @Override
    public boolean isWindowAlphaSupported() {
        return Boolean.getBoolean("sun.java2d.noddraw");
    }

    private boolean usingUpdateLayeredWindow(Window container) {
        if (container instanceof RootPaneContainer) {
            return ((JComponent)(container = ((RootPaneContainer)((Object)container)).getRootPane())).getClientProperty("transparent-old-bg") != null;
        }
        return false;
    }

    private void storeAlpha(Window container, byte by) {
        if (container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)container)).getRootPane();
            Byte by2 = by == -1 ? null : Byte.valueOf(by);
            ((JComponent)container).putClientProperty("transparent-alpha", by2);
        }
    }

    private byte getAlpha(Window serializable) {
        if (serializable instanceof RootPaneContainer) {
            serializable = ((RootPaneContainer)((Object)serializable)).getRootPane();
            if ((serializable = (Byte)((JComponent)serializable).getClientProperty("transparent-alpha")) != null) {
                return (Byte)serializable;
            }
        }
        return -1;
    }

    @Override
    public void setWindowAlpha(Window window, float f) {
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
        }
        this.whenDisplayable(window, new WindowUtils$W32WindowUtils$1(this, window, f));
    }

    @Override
    public void setWindowTransparent(Window window, boolean bl) {
        boolean bl2;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window must be a RootPaneContainer");
        }
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
        }
        boolean bl3 = bl2 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
        if (bl == bl2) {
            return;
        }
        this.whenDisplayable(window, new WindowUtils$W32WindowUtils$2(this, window, bl));
    }

    @Override
    public void setWindowMask(Component component, Shape shape) {
        if (shape instanceof Area && ((Area)shape).isPolygonal()) {
            this.setMask(component, (Area)shape);
            return;
        }
        super.setWindowMask(component, shape);
    }

    private void setWindowRegion(Component component, WinDef$HRGN winDef$HRGN) {
        this.whenDisplayable(component, new WindowUtils$W32WindowUtils$3(this, component, winDef$HRGN));
    }

    private void setMask(Component component, Area winDef$POINTArray) {
        GDI32 gDI32 = GDI32.INSTANCE;
        PathIterator pathIterator = winDef$POINTArray.getPathIterator(null);
        int n = pathIterator.getWindingRule() == 1 ? 2 : 1;
        float[] fArray = new float[6];
        ArrayList<WinDef$POINT> arrayList = new ArrayList<WinDef$POINT>();
        int n2 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            if (n3 == 0) {
                n2 = 1;
                arrayList.add(new WinDef$POINT((int)fArray[0], (int)fArray[1]));
            } else if (n3 == 1) {
                ++n2;
                arrayList.add(new WinDef$POINT((int)fArray[0], (int)fArray[1]));
            } else if (n3 == 4) {
                arrayList2.add(n2);
            } else {
                throw new RuntimeException("Area is not polygonal: " + winDef$POINTArray);
            }
            pathIterator.next();
        }
        WinDef$POINT[] winDef$POINTArray2 = (WinDef$POINT[])new WinDef$POINT().toArray(arrayList.size());
        ArrayList<WinDef$POINT> arrayList3 = arrayList;
        winDef$POINTArray = arrayList3.toArray(new WinDef$POINT[arrayList3.size()]);
        for (int i = 0; i < winDef$POINTArray2.length; ++i) {
            winDef$POINTArray2[i].x = winDef$POINTArray[i].x;
            winDef$POINTArray2[i].y = winDef$POINTArray[i].y;
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        WinDef$HRGN winDef$HRGN = gDI32.CreatePolyPolygonRgn(winDef$POINTArray2, nArray, nArray.length, n);
        this.setWindowRegion(component, winDef$HRGN);
    }

    @Override
    protected void setMask(Component component, Raster raster) {
        GDI32 gDI32 = GDI32.INSTANCE;
        WinDef$HRGN winDef$HRGN = raster != null ? gDI32.CreateRectRgn(0, 0, 0, 0) : null;
        if (winDef$HRGN != null) {
            WinDef$HRGN winDef$HRGN2 = gDI32.CreateRectRgn(0, 0, 0, 0);
            try {
                RasterRangesUtils.outputOccupiedRanges(raster, new WindowUtils$W32WindowUtils$4(this, winDef$HRGN2, winDef$HRGN));
            }
            finally {
                gDI32.DeleteObject(winDef$HRGN2);
            }
        }
        this.setWindowRegion(component, winDef$HRGN);
    }

    @Override
    public BufferedImage getWindowIcon(WinDef$HWND object) {
        Object object2;
        Object object3 = new WinDef$DWORDByReference();
        WinDef$LRESULT winDef$LRESULT = User32.INSTANCE.SendMessageTimeout((WinDef$HWND)((Object)object), 127, new WinDef$WPARAM(1L), new WinDef$LPARAM(0L), 2, 500, (WinDef$DWORDByReference)((Object)object3));
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = User32.INSTANCE.SendMessageTimeout((WinDef$HWND)((Object)object), 127, new WinDef$WPARAM(0L), new WinDef$LPARAM(0L), 2, 500, (WinDef$DWORDByReference)((Object)object3));
        }
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = User32.INSTANCE.SendMessageTimeout((WinDef$HWND)((Object)object), 127, new WinDef$WPARAM(2L), new WinDef$LPARAM(0L), 2, 500, (WinDef$DWORDByReference)((Object)object3));
        }
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = new WinDef$LRESULT(User32.INSTANCE.GetClassLongPtr((WinDef$HWND)((Object)object), -14).intValue());
            object3.getValue().setValue(winDef$LRESULT.intValue());
        }
        if (winDef$LRESULT.intValue() == 0) {
            winDef$LRESULT = new WinDef$LRESULT(User32.INSTANCE.GetClassLongPtr((WinDef$HWND)((Object)object), -34).intValue());
            object3.getValue().setValue(winDef$LRESULT.intValue());
        }
        if (winDef$LRESULT.intValue() == 0) {
            return null;
        }
        object = new WinDef$HICON(new Pointer(object3.getValue().longValue()));
        object3 = this.getIconSize((WinDef$HICON)((Object)object));
        if (((Dimension)object3).width == 0 || ((Dimension)object3).height == 0) {
            return null;
        }
        int n = ((Dimension)object3).width;
        int n2 = ((Dimension)object3).height;
        byte[] byArray = new byte[n * n2 * 24 / 8];
        Memory memory = new Memory((long)byArray.length);
        byte[] byArray2 = new byte[n * n2 * 24 / 8];
        Memory memory2 = new Memory((long)byArray2.length);
        WinGDI$BITMAPINFO winGDI$BITMAPINFO = new WinGDI$BITMAPINFO();
        winGDI$BITMAPINFO.bmiHeader = object2 = new WinGDI$BITMAPINFOHEADER();
        object2.biWidth = n;
        object2.biHeight = n2;
        object2.biPlanes = 1;
        object2.biBitCount = (short)24;
        object2.biCompression = 0;
        object2.write();
        winGDI$BITMAPINFO.write();
        object2 = User32.INSTANCE.GetDC(null);
        WinGDI$ICONINFO winGDI$ICONINFO = new WinGDI$ICONINFO();
        User32.INSTANCE.GetIconInfo((WinDef$HICON)((Object)object), winGDI$ICONINFO);
        winGDI$ICONINFO.read();
        GDI32.INSTANCE.GetDIBits((WinDef$HDC)((Object)object2), winGDI$ICONINFO.hbmColor, 0, n2, (Pointer)memory, winGDI$BITMAPINFO, 0);
        memory.read(0L, byArray, 0, byArray.length);
        GDI32.INSTANCE.GetDIBits((WinDef$HDC)((Object)object2), winGDI$ICONINFO.hbmMask, 0, n2, (Pointer)memory2, winGDI$BITMAPINFO, 0);
        memory2.read(0L, byArray2, 0, byArray2.length);
        object = new BufferedImage(n, n2, 2);
        int n3 = 0;
        int n4 = n2 - 1;
        for (int i = 0; i < byArray.length; i += 3) {
            int n5 = byArray[i] & 0xFF;
            int n6 = byArray[i + 1] & 0xFF;
            n2 = byArray[i + 2] & 0xFF;
            int n7 = 255 - byArray2[i] & 0xFF;
            n2 = n7 << 24 | n2 << 16 | n6 << 8 | n5;
            ((BufferedImage)object).setRGB(n3, n4, n2);
            n3 = (n3 + 1) % n;
            if (n3 != 0) continue;
            --n4;
        }
        User32.INSTANCE.ReleaseDC(null, (WinDef$HDC)((Object)object2));
        return object;
    }

    @Override
    public Dimension getIconSize(WinDef$HICON object) {
        WinGDI$ICONINFO winGDI$ICONINFO = new WinGDI$ICONINFO();
        try {
            if (!User32.INSTANCE.GetIconInfo((WinDef$HICON)((Object)object), winGDI$ICONINFO)) {
                object = new Dimension();
                return object;
            }
            winGDI$ICONINFO.read();
            object = new WinGDI$BITMAP();
            if (winGDI$ICONINFO.hbmColor != null && winGDI$ICONINFO.hbmColor.getPointer() != Pointer.NULL) {
                int n = GDI32.INSTANCE.GetObject(winGDI$ICONINFO.hbmColor, object.size(), object.getPointer());
                object.read();
                if (n > 0) {
                    object = new Dimension(((WinGDI$BITMAP)((Object)object)).bmWidth.intValue(), ((WinGDI$BITMAP)((Object)object)).bmHeight.intValue());
                    return object;
                }
            } else if (winGDI$ICONINFO.hbmMask != null && winGDI$ICONINFO.hbmMask.getPointer() != Pointer.NULL) {
                int n = GDI32.INSTANCE.GetObject(winGDI$ICONINFO.hbmMask, object.size(), object.getPointer());
                object.read();
                if (n > 0) {
                    object = new Dimension(((WinGDI$BITMAP)((Object)object)).bmWidth.intValue(), ((WinGDI$BITMAP)((Object)object)).bmHeight.intValue() / 2);
                    return object;
                }
            }
        }
        finally {
            if (winGDI$ICONINFO.hbmColor != null && winGDI$ICONINFO.hbmColor.getPointer() != Pointer.NULL) {
                GDI32.INSTANCE.DeleteObject(winGDI$ICONINFO.hbmColor);
            }
            if (winGDI$ICONINFO.hbmMask != null && winGDI$ICONINFO.hbmMask.getPointer() != Pointer.NULL) {
                GDI32.INSTANCE.DeleteObject(winGDI$ICONINFO.hbmMask);
            }
        }
        return new Dimension();
    }

    @Override
    public List<DesktopWindow> getAllWindows(boolean bl) {
        LinkedList<DesktopWindow> linkedList = new LinkedList<DesktopWindow>();
        WindowUtils$W32WindowUtils$5 windowUtils$W32WindowUtils$5 = new WindowUtils$W32WindowUtils$5(this, bl, linkedList);
        if (!User32.INSTANCE.EnumWindows(windowUtils$W32WindowUtils$5, null)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return linkedList;
    }

    @Override
    public String getWindowTitle(WinDef$HWND winDef$HWND) {
        int n = User32.INSTANCE.GetWindowTextLength(winDef$HWND) + 1;
        char[] cArray = new char[n];
        int n2 = User32.INSTANCE.GetWindowText(winDef$HWND, cArray, n);
        return Native.toString((char[])Arrays.copyOfRange(cArray, 0, n2));
    }

    @Override
    public String getProcessFilePath(WinDef$HWND winNT$HANDLE) {
        Object object = new IntByReference();
        User32.INSTANCE.GetWindowThreadProcessId((WinDef$HWND)winNT$HANDLE, (IntByReference)object);
        winNT$HANDLE = Kernel32.INSTANCE.OpenProcess(1024, false, object.getValue());
        if (winNT$HANDLE == null) {
            if (Kernel32.INSTANCE.GetLastError() != 5) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            winNT$HANDLE = Kernel32.INSTANCE.OpenProcess(4096, false, object.getValue());
            if (winNT$HANDLE == null) {
                if (Kernel32.INSTANCE.GetLastError() != 5) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                return "";
            }
        }
        try {
            Object object2;
            object = PsapiUtil.GetProcessImageFileName(winNT$HANDLE);
            if (((String)object).startsWith("\\Device\\Mup\\")) {
                String string = "\\" + ((String)object).substring(11);
                return string;
            }
            char[] cArray = new char[50];
            WinNT$HANDLE winNT$HANDLE2 = Kernel32.INSTANCE.FindFirstVolume(cArray, 50);
            if (winNT$HANDLE2 == null || winNT$HANDLE2.equals((Object)WinBase.INVALID_HANDLE_VALUE)) {
                throw new Win32Exception(Native.getLastError());
            }
            try {
                do {
                    object2 = Native.toString((char[])cArray);
                    for (String string : Kernel32Util.getVolumePathNamesForVolumeName((String)object2)) {
                        if (!string.matches("[a-zA-Z]:\\\\")) continue;
                        for (String string2 : Kernel32Util.queryDosDevice(string.substring(0, 2), 1024)) {
                            if (!((String)object).startsWith(string2)) continue;
                            object = string + ((String)object).substring(string2.length() + 1);
                            return object;
                        }
                    }
                } while (Kernel32.INSTANCE.FindNextVolume(winNT$HANDLE2, cArray, 50));
                if (Native.getLastError() != 18) {
                    throw new Win32Exception(Native.getLastError());
                }
            }
            finally {
                Kernel32.INSTANCE.FindVolumeClose(winNT$HANDLE2);
            }
            object2 = object;
            return object2;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(winNT$HANDLE);
        }
    }

    @Override
    public Rectangle getWindowLocationAndSize(WinDef$HWND winDef$HWND) {
        WinDef$RECT winDef$RECT = new WinDef$RECT();
        if (!User32.INSTANCE.GetWindowRect(winDef$HWND, winDef$RECT)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new Rectangle(winDef$RECT.left, winDef$RECT.top, Math.abs(winDef$RECT.right - winDef$RECT.left), Math.abs(winDef$RECT.bottom - winDef$RECT.top));
    }

    /* synthetic */ WindowUtils$W32WindowUtils(WindowUtils$1 windowUtils$1) {
        this();
    }

    static /* synthetic */ WinDef$HWND access$400(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Component component) {
        return windowUtils$W32WindowUtils.getHWnd(component);
    }

    static /* synthetic */ boolean access$500(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window) {
        return windowUtils$W32WindowUtils.usingUpdateLayeredWindow(window);
    }

    static /* synthetic */ void access$600(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window, byte by) {
        windowUtils$W32WindowUtils.storeAlpha(window, by);
    }

    static /* synthetic */ byte access$700(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window) {
        return windowUtils$W32WindowUtils.getAlpha(window);
    }
}

