/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import java.util.ArrayList;
import java.util.List;

public class BasicStatusManager
implements StatusManager {
    public static final int MAX_HEADER_COUNT = 150;
    public static final int TAIL_SIZE = 150;
    int count = 0;
    protected final List<Status> statusList = new ArrayList<Status>();
    protected final CyclicBuffer<Status> tailBuffer = new CyclicBuffer(150);
    protected final LogbackLock statusListLock = new LogbackLock();
    int level = 0;
    protected final List<StatusListener> statusListenerList = new ArrayList<StatusListener>();
    protected final LogbackLock statusListenerListLock = new LogbackLock();

    @Override
    public void add(Status status) {
        this.fireStatusAddEvent(status);
        ++this.count;
        if (status.getLevel() > this.level) {
            this.level = status.getLevel();
        }
        LogbackLock logbackLock = this.statusListLock;
        synchronized (logbackLock) {
            if (this.statusList.size() < 150) {
                this.statusList.add(status);
            } else {
                this.tailBuffer.add(status);
            }
            return;
        }
    }

    @Override
    public List<Status> getCopyOfStatusList() {
        LogbackLock logbackLock = this.statusListLock;
        synchronized (logbackLock) {
            ArrayList<Status> arrayList = new ArrayList<Status>(this.statusList);
            arrayList.addAll(this.tailBuffer.asList());
            return arrayList;
        }
    }

    private void fireStatusAddEvent(Status status) {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            for (StatusListener statusListener : this.statusListenerList) {
                statusListener.addStatusEvent(status);
            }
            return;
        }
    }

    @Override
    public void clear() {
        LogbackLock logbackLock = this.statusListLock;
        synchronized (logbackLock) {
            this.count = 0;
            this.statusList.clear();
            this.tailBuffer.clear();
            return;
        }
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean add(StatusListener statusListener) {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            if (statusListener instanceof OnConsoleStatusListener) {
                BasicStatusManager basicStatusManager = this;
                boolean bl = basicStatusManager.checkForPresence(basicStatusManager.statusListenerList, statusListener.getClass());
                if (bl) {
                    return false;
                }
            }
            this.statusListenerList.add(statusListener);
        }
        return true;
    }

    private boolean checkForPresence(List<StatusListener> object, Class<?> clazz) {
        object = object.iterator();
        while (object.hasNext()) {
            StatusListener statusListener = (StatusListener)object.next();
            if (statusListener.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(StatusListener statusListener) {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            this.statusListenerList.remove(statusListener);
            return;
        }
    }

    @Override
    public List<StatusListener> getCopyOfStatusListenerList() {
        LogbackLock logbackLock = this.statusListenerListLock;
        synchronized (logbackLock) {
            return new ArrayList<StatusListener>(this.statusListenerList);
        }
    }
}

