/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.PropertySetter$1;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.joran.util.beans.BeanUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.PropertySetterException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertySetter
extends ContextAwareBase {
    protected final Object obj;
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;

    public PropertySetter(BeanDescriptionCache beanDescriptionCache, Object object) {
        this.obj = object;
        this.objClass = object.getClass();
        this.beanDescription = beanDescriptionCache.getBeanDescription(this.objClass);
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Method method = this.findSetterMethod(string);
        if (method == null) {
            this.addWarn("No setter for property [" + string + "] in " + this.objClass.getName() + ".");
            return;
        }
        try {
            this.setProperty(method, string, string2);
            return;
        }
        catch (PropertySetterException propertySetterException) {
            this.addWarn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException);
            return;
        }
    }

    private void setProperty(Method method, String classArray, String object) {
        classArray = method.getParameterTypes();
        try {
            object = StringToObjectConverter.convertArg(this, (String)object, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(classArray[0]) + "] failed. ", throwable);
        }
        if (object == null) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(classArray[0]) + "] failed.");
        }
        try {
            method.invoke(this.obj, object);
            return;
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    public AggregationType computeAggregationType(String string) {
        Object object = this.capitalizeFirstLetter(string);
        if ((object = this.findAdderMethod((String)object)) != null) {
            object = this.computeRawAggregationType((Method)object);
            switch (PropertySetter$1.$SwitchMap$ch$qos$logback$core$util$AggregationType[((Enum)object).ordinal()]) {
                case 1: {
                    return AggregationType.NOT_FOUND;
                }
                case 2: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case 3: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case 4: 
                case 5: {
                    this.addError("Unexpected AggregationType " + String.valueOf(object));
                }
            }
        }
        if ((object = this.findSetterMethod(string)) != null) {
            return this.computeRawAggregationType((Method)object);
        }
        return AggregationType.NOT_FOUND;
    }

    private Method findAdderMethod(String string) {
        string = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getAdder(string);
    }

    private Method findSetterMethod(String string) {
        string = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getSetter(string);
    }

    private Class<?> getParameterClassForMethod(Method classArray) {
        if (classArray == null) {
            return null;
        }
        if ((classArray = classArray.getParameterTypes()).length != 1) {
            return null;
        }
        return classArray[0];
    }

    private AggregationType computeRawAggregationType(Method genericDeclaration) {
        if ((genericDeclaration = this.getParameterClassForMethod((Method)genericDeclaration)) == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(genericDeclaration)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            clazz = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return clazz != null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void addComplexProperty(String string, Object object) {
        Method method = this.findAdderMethod(string);
        if (method != null) {
            Class<?>[] classArray = method.getParameterTypes();
            if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
            return;
        }
        this.addError("Could not find method [add" + string + "] in class [" + this.objClass.getName() + "].");
    }

    void invokeMethodWithSingleParameterOnThisObject(Method method, Object object) {
        Class<?> clazz = object.getClass();
        try {
            method.invoke(this.obj, object);
            return;
        }
        catch (Exception exception) {
            this.addError("Could not invoke method " + method.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + clazz.getName(), exception);
            return;
        }
    }

    public void addBasicProperty(String object, String string) {
        if (string == null) {
            return;
        }
        Method method = this.findAdderMethod((String)(object = this.capitalizeFirstLetter((String)object)));
        if (method == null) {
            this.addError("No adder for property [" + (String)object + "].");
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        this.isSanityCheckSuccessful((String)object, method, classArray, string);
        try {
            object = StringToObjectConverter.convertArg(this, string, classArray[0]);
        }
        catch (Throwable throwable) {
            this.addError("Conversion to type [" + String.valueOf(classArray[0]) + "] failed. ", throwable);
            return;
        }
        if (object != null) {
            this.invokeMethodWithSingleParameterOnThisObject(method, string);
        }
    }

    public void setComplexProperty(String string, Object object) {
        Method method = this.findSetterMethod(string);
        if (method == null) {
            this.addWarn("Not setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (!this.isSanityCheckSuccessful(string, method, classArray, object)) {
            return;
        }
        try {
            this.invokeMethodWithSingleParameterOnThisObject(method, object);
            return;
        }
        catch (Exception exception) {
            PropertySetter propertySetter = this;
            propertySetter.addError("Could not set component " + String.valueOf(propertySetter.obj) + " for parent component " + String.valueOf(this.obj), exception);
            return;
        }
    }

    private boolean isSanityCheckSuccessful(String string, Method genericDeclaration, Class<?>[] classArray, Object object) {
        genericDeclaration = object.getClass();
        if (classArray.length != 1) {
            this.addError("Wrong number of parameters in setter method for property [" + string + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!classArray[0].isAssignableFrom(object.getClass())) {
            this.addError("A \"" + ((Class)genericDeclaration).getName() + "\" object is not assignable to a \"" + classArray[0].getName() + "\" variable.");
            this.addError("The class \"" + classArray[0].getName() + "\" was loaded by ");
            this.addError("[" + String.valueOf(classArray[0].getClassLoader()) + "] whereas object of type ");
            this.addError("\"" + ((Class)genericDeclaration).getName() + "\" was loaded by [" + String.valueOf(((Class)genericDeclaration).getClassLoader()) + "].");
            return false;
        }
        return true;
    }

    private String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public Object getObj() {
        return this.obj;
    }

    Method getRelevantMethod(String object, AggregationType aggregationType) {
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            object = this.findAdderMethod((String)object);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            object = this.findSetterMethod((String)object);
        } else {
            throw new IllegalStateException(String.valueOf((Object)aggregationType) + " not allowed here");
        }
        return object;
    }

    <T extends Annotation> T getAnnotation(String string, Class<T> clazz, Method method) {
        if (method != null) {
            return method.getAnnotation(clazz);
        }
        return null;
    }

    Class<?> getDefaultClassNameByAnnonation(String object, Method method) {
        if ((object = this.getAnnotation((String)object, DefaultClass.class, method)) != null) {
            return object.value();
        }
        return null;
    }

    Class<?> getByConcreteType(String clazz, Method method) {
        clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(clazz);
        if (bl) {
            return clazz;
        }
        return null;
    }

    public Class<?> getClassNameViaImplicitRules(String string, AggregationType object, DefaultNestedComponentRegistry clazz) {
        if ((clazz = ((DefaultNestedComponentRegistry)((Object)clazz)).findDefaultComponentType(this.obj.getClass(), string)) != null) {
            return clazz;
        }
        if ((object = this.getRelevantMethod(string, (AggregationType)((Object)object))) == null) {
            return null;
        }
        clazz = this.getDefaultClassNameByAnnonation(string, (Method)object);
        if (clazz != null) {
            return clazz;
        }
        return this.getByConcreteType(string, (Method)object);
    }
}

