/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP$Usage;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.InvocationGate;
import ch.qos.logback.core.util.SimpleInvocationGate;
import java.io.File;

@NoAutoStart
public class SizeAndTimeBasedFNATP<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    volatile int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    Duration checkIncrement = null;
    static String MISSING_INT_TOKEN = "Missing integer token, that is %i, in FileNamePattern [";
    static String MISSING_DATE_TOKEN = "Missing date token, that is %d, in FileNamePattern [";
    private final SizeAndTimeBasedFNATP$Usage usage;
    InvocationGate invocationGate = new SimpleInvocationGate();

    public SizeAndTimeBasedFNATP() {
        this(SizeAndTimeBasedFNATP$Usage.DIRECT);
    }

    public SizeAndTimeBasedFNATP(SizeAndTimeBasedFNATP$Usage sizeAndTimeBasedFNATP$Usage) {
        this.usage = sizeAndTimeBasedFNATP$Usage;
    }

    @Override
    public void start() {
        super.start();
        if (this.usage == SizeAndTimeBasedFNATP$Usage.DIRECT) {
            this.addWarn("SizeAndTimeBasedFNATP is deprecated. Use SizeAndTimeBasedRollingPolicy instead");
            this.addWarn("For more information see http://logback.qos.ch/manual/appenders.html#SizeAndTimeBasedRollingPolicy");
        }
        if (!super.isErrorFree()) {
            return;
        }
        if (this.maxFileSize == null) {
            this.addError("maxFileSize property is mandatory.");
            this.withErrors();
        }
        if (this.checkIncrement != null) {
            this.invocationGate = new SimpleInvocationGate(this.checkIncrement);
        }
        if (!this.validateDateAndIntegerTokens()) {
            this.withErrors();
            return;
        }
        this.archiveRemover = this.createArchiveRemover();
        this.archiveRemover.setContext(this.context);
        String string = this.tbrp.fileNamePattern.toRegexForFixedDate(this.dateInCurrentPeriod);
        string = FileFilterUtil.afterLastSlash(string);
        this.computeCurrentPeriodsHighestCounterValue(string);
        if (this.isErrorFree()) {
            this.started = true;
        }
    }

    private boolean validateDateAndIntegerTokens() {
        boolean bl = false;
        if (this.tbrp.fileNamePattern.getIntegerTokenConverter() == null) {
            bl = true;
            this.addError(MISSING_INT_TOKEN + this.tbrp.fileNamePatternStr + "]");
            this.addError("See also http://logback.qos.ch/codes.html#sat_missing_integer_token");
        }
        if (this.tbrp.fileNamePattern.getPrimaryDateTokenConverter() == null) {
            bl = true;
            this.addError(MISSING_DATE_TOKEN + this.tbrp.fileNamePatternStr + "]");
        }
        return !bl;
    }

    protected ArchiveRemover createArchiveRemover() {
        return new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
    }

    void computeCurrentPeriodsHighestCounterValue(String string) {
        File[] fileArray = new File(this.getCurrentPeriodsFileNameWithoutCompressionSuffix());
        fileArray = fileArray.getParentFile();
        if ((fileArray = FileFilterUtil.filesInFolderMatchingStemRegex((File)fileArray, string)) == null || fileArray.length == 0) {
            this.currentPeriodsCounter = 0;
            return;
        }
        this.currentPeriodsCounter = FileFilterUtil.findHighestCounter(fileArray, string);
        if (this.tbrp.getParentsRawFileProperty() != null || this.tbrp.compressionMode != CompressionMode.NONE) {
            ++this.currentPeriodsCounter;
        }
    }

    @Override
    public boolean isTriggeringEvent(File comparable, E e) {
        long l;
        long l2 = this.getCurrentTime();
        if (l2 >= (l = this.atomicNextCheck.get())) {
            long l3 = this.computeNextCheck(l2);
            this.atomicNextCheck.set(l3);
            comparable = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(comparable, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.setDateInCurrentPeriod(l2);
            return true;
        }
        return this.checkSizeBasedTrigger((File)comparable, l2);
    }

    private boolean checkSizeBasedTrigger(File file, long l) {
        if (this.invocationGate.isTooSoon(l)) {
            return false;
        }
        if (file == null) {
            this.addWarn("activeFile == null");
            return false;
        }
        if (this.maxFileSize == null) {
            this.addWarn("maxFileSize = null");
            return false;
        }
        if (file.length() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    public Duration getCheckIncrement() {
        return this.checkIncrement;
    }

    public void setCheckIncrement(Duration duration) {
        this.checkIncrement = duration;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    public void setMaxFileSize(FileSize fileSize) {
        this.maxFileSize = fileSize;
    }
}

