/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder$IntervalUnit;
import org.quartz.ScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.spi.MutableTrigger;

public class DailyTimeIntervalScheduleBuilder
extends ScheduleBuilder<DailyTimeIntervalTrigger> {
    private int interval = 1;
    private DateBuilder$IntervalUnit intervalUnit = DateBuilder$IntervalUnit.MINUTE;
    private Set<Integer> daysOfWeek;
    private TimeOfDay startTimeOfDay;
    private TimeOfDay endTimeOfDay;
    private int repeatCount = -1;
    private int misfireInstruction = 0;
    public static final Set<Integer> ALL_DAYS_OF_THE_WEEK;
    public static final Set<Integer> MONDAY_THROUGH_FRIDAY;
    public static final Set<Integer> SATURDAY_AND_SUNDAY;

    protected DailyTimeIntervalScheduleBuilder() {
    }

    public static DailyTimeIntervalScheduleBuilder dailyTimeIntervalSchedule() {
        return new DailyTimeIntervalScheduleBuilder();
    }

    @Override
    public MutableTrigger build() {
        DailyTimeIntervalTriggerImpl dailyTimeIntervalTriggerImpl = new DailyTimeIntervalTriggerImpl();
        dailyTimeIntervalTriggerImpl.setRepeatInterval(this.interval);
        dailyTimeIntervalTriggerImpl.setRepeatIntervalUnit(this.intervalUnit);
        dailyTimeIntervalTriggerImpl.setMisfireInstruction(this.misfireInstruction);
        dailyTimeIntervalTriggerImpl.setRepeatCount(this.repeatCount);
        if (this.daysOfWeek != null) {
            dailyTimeIntervalTriggerImpl.setDaysOfWeek(this.daysOfWeek);
        } else {
            dailyTimeIntervalTriggerImpl.setDaysOfWeek(ALL_DAYS_OF_THE_WEEK);
        }
        if (this.startTimeOfDay != null) {
            dailyTimeIntervalTriggerImpl.setStartTimeOfDay(this.startTimeOfDay);
        } else {
            dailyTimeIntervalTriggerImpl.setStartTimeOfDay(TimeOfDay.hourAndMinuteOfDay(0, 0));
        }
        if (this.endTimeOfDay != null) {
            dailyTimeIntervalTriggerImpl.setEndTimeOfDay(this.endTimeOfDay);
        } else {
            dailyTimeIntervalTriggerImpl.setEndTimeOfDay(TimeOfDay.hourMinuteAndSecondOfDay(23, 59, 59));
        }
        return dailyTimeIntervalTriggerImpl;
    }

    public DailyTimeIntervalScheduleBuilder withInterval(int n, DateBuilder$IntervalUnit dateBuilder$IntervalUnit) {
        if (dateBuilder$IntervalUnit == null || !dateBuilder$IntervalUnit.equals((Object)DateBuilder$IntervalUnit.SECOND) && !dateBuilder$IntervalUnit.equals((Object)DateBuilder$IntervalUnit.MINUTE) && !dateBuilder$IntervalUnit.equals((Object)DateBuilder$IntervalUnit.HOUR)) {
            throw new IllegalArgumentException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = dateBuilder$IntervalUnit;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withIntervalInSeconds(int n) {
        this.withInterval(n, DateBuilder$IntervalUnit.SECOND);
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withIntervalInMinutes(int n) {
        this.withInterval(n, DateBuilder$IntervalUnit.MINUTE);
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withIntervalInHours(int n) {
        this.withInterval(n, DateBuilder$IntervalUnit.HOUR);
        return this;
    }

    public DailyTimeIntervalScheduleBuilder onDaysOfTheWeek(Set<Integer> set) {
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("Days of week must be an non-empty set.");
        }
        for (Integer n : set) {
            if (ALL_DAYS_OF_THE_WEEK.contains(n)) continue;
            throw new IllegalArgumentException("Invalid value for day of week: " + n);
        }
        this.daysOfWeek = set;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder onDaysOfTheWeek(Integer ... integerArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>(12);
        Collections.addAll(hashSet, integerArray);
        return this.onDaysOfTheWeek(hashSet);
    }

    public DailyTimeIntervalScheduleBuilder onMondayThroughFriday() {
        this.daysOfWeek = MONDAY_THROUGH_FRIDAY;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder onSaturdayAndSunday() {
        this.daysOfWeek = SATURDAY_AND_SUNDAY;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder onEveryDay() {
        this.daysOfWeek = ALL_DAYS_OF_THE_WEEK;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder startingDailyAt(TimeOfDay timeOfDay) {
        if (timeOfDay == null) {
            throw new IllegalArgumentException("Start time of day cannot be null!");
        }
        this.startTimeOfDay = timeOfDay;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder endingDailyAt(TimeOfDay timeOfDay) {
        this.endTimeOfDay = timeOfDay;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder endingDailyAfterCount(int n) {
        long l;
        if (n <= 0) {
            throw new IllegalArgumentException("Ending daily after count must be a positive number!");
        }
        if (this.startTimeOfDay == null) {
            throw new IllegalArgumentException("You must set the startDailyAt() before calling this endingDailyAfterCount()!");
        }
        Date date = new Date();
        Date date2 = this.startTimeOfDay.getTimeOfDayForDate(date);
        date = TimeOfDay.hourMinuteAndSecondOfDay(23, 59, 59).getTimeOfDayForDate(date);
        long l2 = date.getTime() - date2.getTime();
        if (this.intervalUnit == DateBuilder$IntervalUnit.SECOND) {
            l = (long)this.interval * 1000L;
        } else if (this.intervalUnit == DateBuilder$IntervalUnit.MINUTE) {
            l = (long)this.interval * 1000L * 60L;
        } else if (this.intervalUnit == DateBuilder$IntervalUnit.HOUR) {
            l = (long)this.interval * 1000L * 60L * 24L;
        } else {
            throw new IllegalArgumentException("The IntervalUnit: " + (Object)((Object)this.intervalUnit) + " is invalid for this trigger.");
        }
        if (l2 - l <= 0L) {
            throw new IllegalArgumentException("The startTimeOfDay is too late with given Interval and IntervalUnit values.");
        }
        long l3 = l2 / l;
        if ((long)n > l3) {
            throw new IllegalArgumentException("The given count " + n + " is too large! The max you can set is " + l3);
        }
        long l4 = (long)(n - 1) * l;
        if ((date2 = new Date(date2.getTime() + l4)).getTime() > date.getTime()) {
            throw new IllegalArgumentException("The given count " + n + " is too large! The max you can set is " + l3);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        this.endTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay(n2, n3, n4);
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }

    public DailyTimeIntervalScheduleBuilder withRepeatCount(int n) {
        this.repeatCount = n;
        return this;
    }

    private void validateInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Interval must be a positive value.");
        }
    }

    static {
        int n;
        HashSet<Integer> hashSet = new HashSet<Integer>(7);
        for (n = 1; n <= 7; ++n) {
            hashSet.add(n);
        }
        ALL_DAYS_OF_THE_WEEK = Collections.unmodifiableSet(hashSet);
        hashSet = new HashSet(5);
        for (n = 2; n <= 6; ++n) {
            hashSet.add(n);
        }
        MONDAY_THROUGH_FRIDAY = Collections.unmodifiableSet(hashSet);
        hashSet = new HashSet<Integer>(2);
        hashSet.add(1);
        hashSet.add(7);
        SATURDAY_AND_SUNDAY = Collections.unmodifiableSet(hashSet);
    }
}

