/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.utils.Key;

public class JobBuilder {
    private JobKey key;
    private String description;
    private Class<? extends Job> jobClass;
    private boolean durability;
    private boolean shouldRecover;
    private JobDataMap jobDataMap = new JobDataMap();

    protected JobBuilder() {
    }

    public static JobBuilder newJob() {
        return new JobBuilder();
    }

    public static JobBuilder newJob(Class<? extends Job> clazz) {
        JobBuilder jobBuilder = new JobBuilder();
        jobBuilder.ofType(clazz);
        return jobBuilder;
    }

    public JobDetail build() {
        JobDetailImpl jobDetailImpl = new JobDetailImpl();
        jobDetailImpl.setJobClass(this.jobClass);
        jobDetailImpl.setDescription(this.description);
        if (this.key == null) {
            this.key = new JobKey(Key.createUniqueName(null), null);
        }
        jobDetailImpl.setKey(this.key);
        jobDetailImpl.setDurability(this.durability);
        jobDetailImpl.setRequestsRecovery(this.shouldRecover);
        if (!this.jobDataMap.isEmpty()) {
            jobDetailImpl.setJobDataMap(this.jobDataMap);
        }
        return jobDetailImpl;
    }

    public JobBuilder withIdentity(String string) {
        this.key = new JobKey(string, null);
        return this;
    }

    public JobBuilder withIdentity(String string, String string2) {
        this.key = new JobKey(string, string2);
        return this;
    }

    public JobBuilder withIdentity(JobKey jobKey) {
        this.key = jobKey;
        return this;
    }

    public JobBuilder withDescription(String string) {
        this.description = string;
        return this;
    }

    public JobBuilder ofType(Class<? extends Job> clazz) {
        this.jobClass = clazz;
        return this;
    }

    public JobBuilder requestRecovery() {
        this.shouldRecover = true;
        return this;
    }

    public JobBuilder requestRecovery(boolean bl) {
        this.shouldRecover = bl;
        return this;
    }

    public JobBuilder storeDurably() {
        return this.storeDurably(true);
    }

    public JobBuilder storeDurably(boolean bl) {
        this.durability = bl;
        return this;
    }

    public JobBuilder usingJobData(String string, String string2) {
        this.jobDataMap.put(string, string2);
        return this;
    }

    public JobBuilder usingJobData(String string, Integer n) {
        this.jobDataMap.put(string, (Object)n);
        return this;
    }

    public JobBuilder usingJobData(String string, Long l) {
        this.jobDataMap.put(string, (Object)l);
        return this;
    }

    public JobBuilder usingJobData(String string, Float f) {
        this.jobDataMap.put(string, (Object)f);
        return this;
    }

    public JobBuilder usingJobData(String string, Double d) {
        this.jobDataMap.put(string, (Object)d);
        return this;
    }

    public JobBuilder usingJobData(String string, Boolean bl) {
        this.jobDataMap.put(string, (Object)bl);
        return this;
    }

    public JobBuilder usingJobData(JobDataMap jobDataMap) {
        this.jobDataMap.putAll(jobDataMap);
        return this;
    }

    public JobBuilder setJobData(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
        return this;
    }
}

