/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger$CompletedExecutionInstruction;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private final Object sigLock;
    private boolean signaled;
    private long signaledNextFireTime;
    private boolean paused;
    private AtomicBoolean halted;
    private Random random;
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime;
    private int idleWaitVariablness;
    private final Logger log;
    private static final long MIN_DELAY = 20L;
    private static final long MAX_DELAY = 600000L;

    QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources) {
        QuartzSchedulerResources quartzSchedulerResources2 = quartzSchedulerResources;
        this(quartzScheduler, quartzSchedulerResources2, quartzSchedulerResources2.getMakeSchedulerThreadDaemon(), 5);
    }

    QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources, boolean bl, int n) {
        super(quartzScheduler.getSchedulerThreadGroup(), quartzSchedulerResources.getThreadName());
        this.sigLock = new Object();
        this.random = new Random(System.currentTimeMillis());
        this.idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
        this.idleWaitVariablness = 7000;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.qs = quartzScheduler;
        this.qsRsrcs = quartzSchedulerResources;
        this.setDaemon(bl);
        if (quartzSchedulerResources.isThreadsInheritInitializersClassLoadContext()) {
            this.log.info("QuartzSchedulerThread Inheriting ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.setPriority(n);
        this.paused = true;
        this.halted = new AtomicBoolean(false);
    }

    void setIdleWaitTime(long l) {
        this.idleWaitTime = l;
        this.idleWaitVariablness = (int)((double)l * 0.2);
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    void togglePause(boolean bl) {
        Object object = this.sigLock;
        synchronized (object) {
            this.paused = bl;
            if (this.paused) {
                this.signalSchedulingChange(0L);
            } else {
                this.sigLock.notifyAll();
            }
            return;
        }
    }

    void halt(boolean bl) {
        Object object = this.sigLock;
        synchronized (object) {
            this.halted.set(true);
            if (this.paused) {
                this.sigLock.notifyAll();
            } else {
                this.signalSchedulingChange(0L);
            }
        }
        if (bl) {
            boolean bl2 = false;
            try {
                while (true) {
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                        continue;
                    }
                    break;
                }
                if (bl2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    public void signalSchedulingChange(long l) {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = true;
            this.signaledNextFireTime = l;
            this.sigLock.notifyAll();
            return;
        }
    }

    public void clearSignaledSchedulingChange() {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = false;
            this.signaledNextFireTime = 0L;
            return;
        }
    }

    public boolean isScheduleChanged() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaled;
        }
    }

    public long getSignaledNextFireTime() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaledNextFireTime;
        }
    }

    @Override
    public void run() {
        int n = 0;
        while (!this.halted.get()) {
            try {
                List<OperableTrigger> list;
                long l;
                block46: {
                    int n2;
                    Object object = this.sigLock;
                    synchronized (object) {
                        while (this.paused && !this.halted.get()) {
                            try {
                                this.sigLock.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            n = 0;
                        }
                        if (this.halted.get()) {
                            break;
                        }
                    }
                    if (n > 1) {
                        try {
                            long l2 = QuartzSchedulerThread.computeDelayForRepeatedErrors(this.qsRsrcs.getJobStore(), n);
                            Thread.sleep(l2);
                        }
                        catch (Exception exception) {}
                    }
                    if ((n2 = this.qsRsrcs.getThreadPool().blockForAvailableThreads()) <= 0) continue;
                    l = System.currentTimeMillis();
                    this.clearSignaledSchedulingChange();
                    try {
                        list = this.qsRsrcs.getJobStore().acquireNextTriggers(l + this.idleWaitTime, Math.min(n2, this.qsRsrcs.getMaxBatchSize()), this.qsRsrcs.getBatchTimeWindow());
                        n = 0;
                        if (!this.log.isDebugEnabled()) break block46;
                        this.log.debug("batch acquisition of " + (list == null ? 0 : list.size()) + " triggers");
                    }
                    catch (JobPersistenceException jobPersistenceException) {
                        if (n == 0) {
                            this.qs.notifySchedulerListenersError("An error occurred while scanning for the next triggers to fire.", jobPersistenceException);
                        }
                        if (n >= Integer.MAX_VALUE) continue;
                        ++n;
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        if (n == 0) {
                            this.getLog().error("quartzSchedulerThreadLoop: RuntimeException " + runtimeException.getMessage(), (Throwable)runtimeException);
                        }
                        if (n >= Integer.MAX_VALUE) continue;
                        ++n;
                        continue;
                    }
                }
                if (list != null && !list.isEmpty()) {
                    List<Object> list2;
                    block47: {
                        int n3;
                        l = System.currentTimeMillis();
                        long l3 = list.get(0).getNextFireTime().getTime();
                        long l4 = l3 - l;
                        while (l4 > 2L) {
                            Object object = this.sigLock;
                            synchronized (object) {
                                if (this.halted.get()) {
                                    break;
                                }
                                if (!this.isCandidateNewTimeEarlierWithinReason(l3, false)) {
                                    try {
                                        l = System.currentTimeMillis();
                                        l4 = l3 - l;
                                        if (l4 >= 1L) {
                                            this.sigLock.wait(l4);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            if (this.releaseIfScheduleChangedSignificantly(list, l3)) break;
                            l = System.currentTimeMillis();
                            l4 = l3 - l;
                        }
                        if (list.isEmpty()) continue;
                        list2 = new ArrayList();
                        List<TriggerFiredResult> list3 = this.sigLock;
                        synchronized (list3) {
                            n3 = !this.halted.get() ? 1 : 0;
                        }
                        if (n3 != 0) {
                            try {
                                list3 = this.qsRsrcs.getJobStore().triggersFired(list);
                                if (list3 == null) break block47;
                                list2 = list3;
                            }
                            catch (SchedulerException schedulerException) {
                                this.qs.notifySchedulerListenersError("An error occurred while firing triggers '" + list + "'", schedulerException);
                                for (n3 = 0; n3 < list.size(); ++n3) {
                                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(list.get(n3));
                                }
                                continue;
                            }
                        }
                    }
                    for (int i = 0; i < list2.size(); ++i) {
                        Object object = (TriggerFiredResult)list2.get(i);
                        TriggerFiredBundle triggerFiredBundle = ((TriggerFiredResult)object).getTriggerFiredBundle();
                        if ((object = ((TriggerFiredResult)object).getException()) instanceof RuntimeException) {
                            this.getLog().error("RuntimeException while firing trigger " + list.get(i), (Throwable)object);
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(list.get(i));
                            continue;
                        }
                        if (triggerFiredBundle == null) {
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(list.get(i));
                            continue;
                        }
                        try {
                            object = this.qsRsrcs.getJobRunShellFactory().createJobRunShell(triggerFiredBundle);
                            ((JobRunShell)object).initialize(this.qs);
                        }
                        catch (SchedulerException schedulerException) {
                            this.qsRsrcs.getJobStore().triggeredJobComplete(list.get(i), triggerFiredBundle.getJobDetail(), Trigger$CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                            continue;
                        }
                        if (this.qsRsrcs.getThreadPool().runInThread((Runnable)object)) continue;
                        this.getLog().error("ThreadPool.runInThread() return false!");
                        this.qsRsrcs.getJobStore().triggeredJobComplete(list.get(i), triggerFiredBundle.getJobDetail(), Trigger$CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                    }
                    continue;
                }
                long l5 = System.currentTimeMillis();
                long l6 = l5 + this.getRandomizedIdleWaitTime();
                long l7 = l6 - l5;
                Object object = this.sigLock;
                synchronized (object) {
                    try {
                        if (!this.halted.get() && !this.isScheduleChanged()) {
                            this.sigLock.wait(l7);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (RuntimeException runtimeException) {
                this.getLog().error("Runtime error occurred in main trigger firing loop.", (Throwable)runtimeException);
            }
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    private static long computeDelayForRepeatedErrors(JobStore jobStore, int n) {
        long l;
        try {
            l = jobStore.getAcquireRetryDelay(n);
        }
        catch (Exception exception) {
            l = 100L;
        }
        if (l < 20L) {
            l = 20L;
        }
        if (l > 600000L) {
            l = 600000L;
        }
        return l;
    }

    private boolean releaseIfScheduleChangedSignificantly(List<OperableTrigger> list, long l) {
        if (this.isCandidateNewTimeEarlierWithinReason(l, true)) {
            for (OperableTrigger operableTrigger : list) {
                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(operableTrigger);
            }
            list.clear();
            return true;
        }
        return false;
    }

    private boolean isCandidateNewTimeEarlierWithinReason(long l, boolean bl) {
        Object object = this.sigLock;
        synchronized (object) {
            long l2;
            if (!this.isScheduleChanged()) {
                return false;
            }
            boolean bl2 = false;
            if (this.getSignaledNextFireTime() == 0L) {
                bl2 = true;
            } else if (this.getSignaledNextFireTime() < l) {
                bl2 = true;
            }
            if (bl2 && (l2 = l - System.currentTimeMillis()) < (this.qsRsrcs.getJobStore().supportsPersistence() ? 70L : 7L)) {
                bl2 = false;
            }
            if (bl) {
                this.clearSignaledSchedulingChange();
            }
            return bl2;
        }
    }

    public Logger getLog() {
        return this.log;
    }
}

