/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping$WhenMappings;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KPackageImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader$Kind;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\u0006\u0010(\u001a\u00020\u000eH\u0002\u001a$\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\u0006\u0010*\u001a\u00020\tH\u0002\u001a\u000e\u0010+\u001a\u0004\u0018\u00010,*\u00020-H\u0002\"/\u0010\u0000\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\"\u001b\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"-\u0010\u001d\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0003\"\b\b\u0000\u0010\u0002*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u001b\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\"\u001b\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006."}, d2={"javaConstructor", "Ljava/lang/reflect/Constructor;", "T", "Lkotlin/reflect/KFunction;", "getJavaConstructor$annotations", "(Lkotlin/reflect/KFunction;)V", "getJavaConstructor", "(Lkotlin/reflect/KFunction;)Ljava/lang/reflect/Constructor;", "javaField", "Ljava/lang/reflect/Field;", "Lkotlin/reflect/KProperty;", "getJavaField", "(Lkotlin/reflect/KProperty;)Ljava/lang/reflect/Field;", "javaGetter", "Ljava/lang/reflect/Method;", "getJavaGetter", "(Lkotlin/reflect/KProperty;)Ljava/lang/reflect/Method;", "javaMethod", "getJavaMethod", "(Lkotlin/reflect/KFunction;)Ljava/lang/reflect/Method;", "javaSetter", "Lkotlin/reflect/KMutableProperty;", "getJavaSetter", "(Lkotlin/reflect/KMutableProperty;)Ljava/lang/reflect/Method;", "javaType", "Ljava/lang/reflect/Type;", "Lkotlin/reflect/KType;", "getJavaType", "(Lkotlin/reflect/KType;)Ljava/lang/reflect/Type;", "kotlinFunction", "", "getKotlinFunction", "(Ljava/lang/reflect/Constructor;)Lkotlin/reflect/KFunction;", "(Ljava/lang/reflect/Method;)Lkotlin/reflect/KFunction;", "kotlinProperty", "getKotlinProperty", "(Ljava/lang/reflect/Field;)Lkotlin/reflect/KProperty;", "findKFunction", "", "Lkotlin/reflect/KCallable;", "method", "findKProperty", "field", "getKPackage", "Lkotlin/reflect/KDeclarationContainer;", "Ljava/lang/reflect/Member;", "kotlin-reflection"})
public final class ReflectJvmMapping {
    public static final Field getJavaField(KProperty<?> kProperty) {
        Intrinsics.checkNotNullParameter(kProperty, (String)"");
        KPropertyImpl<?> kPropertyImpl = UtilKt.asKPropertyImpl(kProperty);
        if (kPropertyImpl != null) {
            return kPropertyImpl.getJavaField();
        }
        return null;
    }

    public static final Method getJavaGetter(KProperty<?> kProperty) {
        Intrinsics.checkNotNullParameter(kProperty, (String)"");
        return ReflectJvmMapping.getJavaMethod((KFunction)kProperty.getGetter());
    }

    public static final Method getJavaSetter(KMutableProperty<?> kMutableProperty) {
        Intrinsics.checkNotNullParameter(kMutableProperty, (String)"");
        return ReflectJvmMapping.getJavaMethod((KFunction)kMutableProperty.getSetter());
    }

    public static final Method getJavaMethod(KFunction<?> kFunction) {
        Intrinsics.checkNotNullParameter(kFunction, (String)"");
        KCallableImpl<?> kCallableImpl = UtilKt.asKCallableImpl(kFunction);
        if ((kCallableImpl != null && (kCallableImpl = kCallableImpl.getCaller()) != null ? (KFunction<?>)kCallableImpl.getMember() : (kFunction = null)) instanceof Method) {
            return (Method)kFunction;
        }
        return null;
    }

    public static final <T> Constructor<T> getJavaConstructor(KFunction<? extends T> kFunction) {
        Intrinsics.checkNotNullParameter(kFunction, (String)"");
        KCallableImpl<?> kCallableImpl = UtilKt.asKCallableImpl(kFunction);
        if ((kCallableImpl != null && (kCallableImpl = kCallableImpl.getCaller()) != null ? (KFunction<? extends T>)kCallableImpl.getMember() : (kFunction = null)) instanceof Constructor) {
            return (Constructor)kFunction;
        }
        return null;
    }

    public static /* synthetic */ void getJavaConstructor$annotations(KFunction kFunction) {
    }

    public static final Type getJavaType(KType kType) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"");
        Type type2 = ((KTypeImpl)kType).getJavaType();
        if (type2 == null) {
            type2 = TypesJVMKt.getJavaType((KType)kType);
        }
        return type2;
    }

    public static final KProperty<?> getKotlinProperty(Field kClass) {
        Intrinsics.checkNotNullParameter((Object)kClass, (String)"");
        if (kClass.isSynthetic()) {
            return null;
        }
        if (Modifier.isStatic(kClass.getModifiers())) {
            KClass<?> kClass2 = ReflectJvmMapping.getKPackage((Member)kClass);
            if (kClass2 != null) {
                return ReflectJvmMapping.findKProperty(kClass2.getMembers(), (Field)kClass);
            }
            Class<?> clazz = kClass.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            kClass2 = KClasses.getCompanionObject(JvmClassMappingKt.getKotlinClass(clazz));
            if (kClass2 != null) {
                Class<?> clazz2 = kClass.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
                String string = kClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Field field = UtilKt.getDeclaredFieldOrNull(clazz2, string);
                if (field != null && (kClass2 = ReflectJvmMapping.findKProperty(KClasses.getMemberProperties(kClass2), field)) != null) {
                    kClass = kClass2;
                    return kClass;
                }
            }
        }
        Class<?> clazz = kClass.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectJvmMapping.findKProperty(KClasses.getMemberProperties(JvmClassMappingKt.getKotlinClass(clazz)), (Field)kClass);
    }

    private static final KDeclarationContainer getKPackage(Member member) {
        Class<?> clazz = member.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        Object object = ReflectKotlinClass.Factory.create(clazz);
        KotlinClassHeader$Kind kotlinClassHeader$Kind = object != null && (object = ((ReflectKotlinClass)object).getClassHeader()) != null ? ((KotlinClassHeader)object).getKind() : null;
        switch (kotlinClassHeader$Kind == null ? -1 : ReflectJvmMapping$WhenMappings.$EnumSwitchMapping$0[kotlinClassHeader$Kind.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Class<?> clazz2 = member.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"");
                return (KDeclarationContainer)new KPackageImpl(clazz2);
            }
        }
        return null;
    }

    public static final KFunction<?> getKotlinFunction(Method kFunction) {
        Intrinsics.checkNotNullParameter((Object)kFunction, (String)"");
        if (Modifier.isStatic(kFunction.getModifiers())) {
            KClass<?> kClass = ReflectJvmMapping.getKPackage((Member)kFunction);
            if (kClass != null) {
                return ReflectJvmMapping.findKFunction(kClass.getMembers(), (Method)kFunction);
            }
            Class<?> clazz = kFunction.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            kClass = KClasses.getCompanionObject(JvmClassMappingKt.getKotlinClass(clazz));
            if (kClass != null) {
                Class clazz2 = JvmClassMappingKt.getJavaClass(kClass);
                String string = kFunction.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Class<?>[] classArray = kFunction.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
                KFunction<?> kFunction2 = classArray;
                kFunction2 = UtilKt.getDeclaredMethodOrNull(clazz2, string, Arrays.copyOf(classArray, ((Class<?>[])kFunction2).length));
                if (kFunction2 != null && (kFunction2 = ReflectJvmMapping.findKFunction(KClasses.getFunctions(kClass), kFunction2)) != null) {
                    kFunction = kFunction2;
                    return kFunction;
                }
            }
        }
        Class<?> clazz = kFunction.getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectJvmMapping.findKFunction(KClasses.getFunctions(JvmClassMappingKt.getKotlinClass(clazz)), (Method)kFunction);
    }

    private static final KFunction<?> findKFunction(Collection<? extends KCallable<?>> collection, Method method) {
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KFunction) || !Intrinsics.areEqual((Object)kCallable.getName(), (Object)method.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaMethod((KFunction)kCallable), (Object)method)) continue;
            return (KFunction)kCallable;
        }
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KFunction) || Intrinsics.areEqual((Object)kCallable.getName(), (Object)method.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaMethod((KFunction)kCallable), (Object)method)) continue;
            return (KFunction)kCallable;
        }
        return null;
    }

    private static final KProperty<?> findKProperty(Collection<? extends KCallable<?>> collection, Field field) {
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KProperty) || !Intrinsics.areEqual((Object)kCallable.getName(), (Object)field.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaField((KProperty)kCallable), (Object)field)) continue;
            return (KProperty)kCallable;
        }
        for (KCallable<?> kCallable : collection) {
            if (!(kCallable instanceof KProperty) || Intrinsics.areEqual((Object)kCallable.getName(), (Object)field.getName()) || !Intrinsics.areEqual((Object)ReflectJvmMapping.getJavaField((KProperty)kCallable), (Object)field)) continue;
            return (KProperty)kCallable;
        }
        return null;
    }

    public static final <T> KFunction<T> getKotlinFunction(Constructor<T> constructor) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(constructor, (String)"");
            Class<T> clazz = constructor.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            Object object = JvmClassMappingKt.getKotlinClass(clazz).getConstructors();
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                KFunction kFunction = (KFunction)e;
                if (!Intrinsics.areEqual(ReflectJvmMapping.getJavaConstructor(kFunction), constructor)) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }
}

