/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;

public final class JavaToKotlinClassMapper {
    public static final JavaToKotlinClassMapper INSTANCE = new JavaToKotlinClassMapper();

    private JavaToKotlinClassMapper() {
    }

    public final Collection<ClassDescriptor> mapPlatformClass(FqName object, KotlinBuiltIns kotlinBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(this, (FqName)object, kotlinBuiltIns, null, 4, null);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        object = classDescriptor;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object));
        if (fqName2 == null) {
            return SetsKt.setOf((Object)object);
        }
        FqName fqName3 = fqName2;
        Object[] objectArray = new ClassDescriptor[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns.getBuiltInClassByFqName(fqName3), (String)"");
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    public final ClassDescriptor mapJavaToKotlin(FqName object, KotlinBuiltIns kotlinBuiltIns, Integer n) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        Object object2 = object = n != null && Intrinsics.areEqual((Object)object, (Object)JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME()) ? StandardNames.getFunctionClassId(n) : JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin((FqName)object);
        if (object2 != null) {
            return kotlinBuiltIns.getBuiltInClassByFqName(((ClassId)object2).asSingleFqName());
        }
        return null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMapper javaToKotlinClassMapper, FqName fqName2, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMapper.mapJavaToKotlin(fqName2, kotlinBuiltIns, n);
    }

    public final boolean isMutable(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        return JavaToKotlinClassMap.INSTANCE.isMutable(DescriptorUtils.getFqName(classDescriptor));
    }

    public final boolean isReadOnly(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        return JavaToKotlinClassMap.INSTANCE.isReadOnly(DescriptorUtils.getFqName(classDescriptor));
    }

    public final ClassDescriptor convertMutableToReadOnly(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        String string = "mutable";
        Object object = DescriptorUtils.getFqName(classDescriptor);
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly((FqNameUnsafe)object);
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + classDescriptor + " is not a " + string + " collection");
        }
        object = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(classDescriptor).getBuiltInClassByFqName((FqName)object);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        return classDescriptor2;
    }

    public final ClassDescriptor convertReadOnlyToMutable(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        String string = "read-only";
        Object object = DescriptorUtils.getFqName(classDescriptor);
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable((FqNameUnsafe)object);
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + classDescriptor + " is not a " + string + " collection");
        }
        object = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(classDescriptor).getBuiltInClassByFqName((FqName)object);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"");
        return classDescriptor2;
    }
}

