/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Array;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Object;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Primitive;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    @Override
    public final JvmType boxType(JvmType jvmType) {
        Intrinsics.checkNotNullParameter((Object)jvmType, (String)"");
        if (jvmType instanceof JvmType$Primitive && ((JvmType$Primitive)jvmType).getJvmPrimitiveType() != null) {
            String string = JvmClassName.byFqNameWithoutInnerClasses(((JvmType$Primitive)jvmType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return this.createObjectType(string);
        }
        return jvmType;
    }

    @Override
    public final JvmType createFromString(String object) {
        JvmPrimitiveType[] jvmPrimitiveTypeArray;
        JvmPrimitiveType[] jvmPrimitiveTypeArray2;
        char c;
        block6: {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            char c2 = c = ((CharSequence)object).length() > 0 ? (char)'\u0001' : '\u0000';
            if (_Assertions.ENABLED && c == '\u0000') {
                String string = "empty string as JvmType";
                throw new AssertionError((Object)string);
            }
            c = object.charAt(0);
            jvmPrimitiveTypeArray2 = JvmPrimitiveType.values();
            int n = jvmPrimitiveTypeArray2.length;
            for (int i = 0; i < n; ++i) {
                JvmPrimitiveType[] jvmPrimitiveTypeArray3;
                JvmPrimitiveType[] jvmPrimitiveTypeArray4 = jvmPrimitiveTypeArray3 = jvmPrimitiveTypeArray2[i];
                if (!(jvmPrimitiveTypeArray3.getDesc().charAt(0) == c)) continue;
                jvmPrimitiveTypeArray = jvmPrimitiveTypeArray3;
                break block6;
            }
            jvmPrimitiveTypeArray = jvmPrimitiveTypeArray2 = null;
        }
        if (jvmPrimitiveTypeArray != null) {
            object = jvmPrimitiveTypeArray2;
            return new JvmType$Primitive((JvmPrimitiveType)((Object)object));
        }
        char c3 = c;
        if (c3 == 'V') {
            return new JvmType$Primitive(null);
        }
        if (c3 == '[') {
            String string = object.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return new JvmType$Array(this.createFromString(string));
        }
        char c4 = c3 = c == 'L' && StringsKt.endsWith$default((CharSequence)((CharSequence)object), (char)';', (boolean)false, (int)2, null) ? (char)'\u0001' : '\u0000';
        if (_Assertions.ENABLED && c3 == '\u0000') {
            object = "Type that is not primitive nor array should be Object, but '" + (String)object + "' was found";
            throw new AssertionError(object);
        }
        String string = object.substring(1, object.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return new JvmType$Object(string);
    }

    @Override
    public final JvmType createPrimitiveType(PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"");
        switch (JvmTypeFactoryImpl$WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                return JvmType.Companion.getBOOLEAN$descriptors_jvm();
            }
            case 2: {
                return JvmType.Companion.getCHAR$descriptors_jvm();
            }
            case 3: {
                return JvmType.Companion.getBYTE$descriptors_jvm();
            }
            case 4: {
                return JvmType.Companion.getSHORT$descriptors_jvm();
            }
            case 5: {
                return JvmType.Companion.getINT$descriptors_jvm();
            }
            case 6: {
                return JvmType.Companion.getFLOAT$descriptors_jvm();
            }
            case 7: {
                return JvmType.Companion.getLONG$descriptors_jvm();
            }
            case 8: {
                return JvmType.Companion.getDOUBLE$descriptors_jvm();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public final JvmType$Object createObjectType(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new JvmType$Object(string);
    }

    @Override
    public final String toString(JvmType jvmType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jvmType, (String)"");
        JvmType jvmType2 = jvmType;
        if (jvmType2 instanceof JvmType$Array) {
            return "[" + this.toString(((JvmType$Array)jvmType).getElementType());
        }
        if (jvmType2 instanceof JvmType$Primitive) {
            object = ((JvmType$Primitive)jvmType).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                return "V";
            }
        } else {
            if (jvmType2 instanceof JvmType$Object) {
                return "L" + ((JvmType$Object)jvmType).getInternalName() + ';';
            }
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    public final JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }
}

