/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderOptimized;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AbstractDeserializedPackageFragmentProvider$fragments$1;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.KotlinMetadataFinder;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public abstract class AbstractDeserializedPackageFragmentProvider
implements PackageFragmentProviderOptimized {
    private final StorageManager storageManager;
    private final KotlinMetadataFinder finder;
    private final ModuleDescriptor moduleDescriptor;
    protected DeserializationComponents components;
    private final MemoizedFunctionToNullable<FqName, PackageFragmentDescriptor> fragments;

    public AbstractDeserializedPackageFragmentProvider(StorageManager storageManager, KotlinMetadataFinder kotlinMetadataFinder, ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinMetadataFinder, (String)"");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        this.storageManager = storageManager;
        this.finder = kotlinMetadataFinder;
        this.moduleDescriptor = moduleDescriptor;
        this.fragments = this.storageManager.createMemoizedFunctionWithNullableValues(new AbstractDeserializedPackageFragmentProvider$fragments$1(this));
    }

    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    protected final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    protected final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    protected final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents != null) {
            return deserializationComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    protected final void setComponents(DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        this.components = deserializationComponents;
    }

    protected abstract DeserializedPackageFragment findPackage(FqName var1);

    @Override
    public void collectPackageFragments(FqName fqName2, Collection<PackageFragmentDescriptor> collection) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter(collection, (String)"");
        CollectionsKt.addIfNotNull(collection, this.fragments.invoke(fqName2));
    }

    @Override
    public boolean isEmpty(FqName object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        return (object = this.fragments.isComputed((FqName)object) ? (PackageFragmentDescriptor)this.fragments.invoke(object) : (PackageFragmentDescriptor)this.findPackage((FqName)object)) == null;
    }

    @Override
    @Deprecated(message="for usages use #packageFragments(FqName) at final point, for impl use #collectPackageFragments(FqName, MutableCollection<PackageFragmentDescriptor>)")
    public List<PackageFragmentDescriptor> getPackageFragments(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return kotlin.collections.CollectionsKt.listOfNotNull((Object)this.fragments.invoke(fqName2));
    }

    @Override
    public Collection<FqName> getSubPackagesOf(FqName fqName2, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return SetsKt.emptySet();
    }
}

