/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.types.ErasureProjectionComputer;
import kotlin.reflect.jvm.internal.impl.types.ErasureTypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution$Companion;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterErasureOptions;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser$Companion;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser$DataToEraseUpperBound;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser$erroneousErasedBound$2;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser$getErasedUpperBound$1;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.IntersectionTypeKt;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class TypeParameterUpperBoundEraser {
    public static final TypeParameterUpperBoundEraser$Companion Companion = new TypeParameterUpperBoundEraser$Companion(null);
    private final ErasureProjectionComputer projectionComputer;
    private final TypeParameterErasureOptions options;
    private final LockBasedStorageManager storage;
    private final Lazy erroneousErasedBound$delegate;
    private final MemoizedFunctionToNotNull<TypeParameterUpperBoundEraser$DataToEraseUpperBound, KotlinType> getErasedUpperBound;

    public TypeParameterUpperBoundEraser(ErasureProjectionComputer erasureProjectionComputer, TypeParameterErasureOptions typeParameterErasureOptions) {
        Intrinsics.checkNotNullParameter((Object)erasureProjectionComputer, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeParameterErasureOptions, (String)"");
        this.projectionComputer = erasureProjectionComputer;
        this.options = typeParameterErasureOptions;
        this.storage = new LockBasedStorageManager("Type parameter upper bound erasure results");
        this.erroneousErasedBound$delegate = LazyKt.lazy((Function0)new TypeParameterUpperBoundEraser$erroneousErasedBound$2(this));
        MemoizedFunctionToNotNull memoizedFunctionToNotNull = this.storage.createMemoizedFunction(new TypeParameterUpperBoundEraser$getErasedUpperBound$1(this));
        Intrinsics.checkNotNullExpressionValue(memoizedFunctionToNotNull, (String)"");
        this.getErasedUpperBound = memoizedFunctionToNotNull;
    }

    public /* synthetic */ TypeParameterUpperBoundEraser(ErasureProjectionComputer erasureProjectionComputer, TypeParameterErasureOptions typeParameterErasureOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            typeParameterErasureOptions = new TypeParameterErasureOptions(false, false);
        }
        this(erasureProjectionComputer, typeParameterErasureOptions);
    }

    private final ErrorType getErroneousErasedBound() {
        Lazy lazy = this.erroneousErasedBound$delegate;
        return (ErrorType)lazy.getValue();
    }

    public final KotlinType getErasedUpperBound(TypeParameterDescriptor typeParameterDescriptor, ErasureTypeAttributes erasureTypeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)erasureTypeAttributes, (String)"");
        Object object = this.getErasedUpperBound.invoke(new TypeParameterUpperBoundEraser$DataToEraseUpperBound(typeParameterDescriptor, erasureTypeAttributes));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return (KotlinType)object;
    }

    private final KotlinType getDefaultType(ErasureTypeAttributes erasureTypeAttributes) {
        KotlinType kotlinType = erasureTypeAttributes.getDefaultType();
        if (kotlinType == null || (kotlinType = TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType)) == null) {
            kotlinType = this.getErroneousErasedBound();
        }
        return kotlinType;
    }

    private final KotlinType getErasedUpperBoundInternal(TypeParameterDescriptor object, ErasureTypeAttributes object2) {
        Annotated annotated;
        Map map;
        Set<TypeParameterDescriptor> set = ((ErasureTypeAttributes)object2).getVisitedTypeParameters();
        if (set != null && set.contains(object.getOriginal())) {
            return this.getDefaultType((ErasureTypeAttributes)object2);
        }
        SimpleType simpleType2 = object.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
        Object object3 = TypeUtilsKt.extractTypeParametersFromUpperBounds(simpleType2, set);
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10)), (int)16);
        Object object4 = new LinkedHashMap(n);
        object3 = object3.iterator();
        while (object3.hasNext()) {
            TypeProjection typeProjection;
            Object object5 = object3.next();
            map = object4;
            annotated = (TypeParameterDescriptor)object5;
            if (set == null || !set.contains(annotated)) {
                TypeParameterUpperBoundEraser typeParameterUpperBoundEraser = this;
                typeProjection = this.projectionComputer.computeProjection((TypeParameterDescriptor)annotated, (ErasureTypeAttributes)object2, typeParameterUpperBoundEraser, typeParameterUpperBoundEraser.getErasedUpperBound((TypeParameterDescriptor)annotated, ((ErasureTypeAttributes)object2).withNewVisitedTypeParameter((TypeParameterDescriptor)object)));
            } else {
                TypeProjection typeProjection2 = TypeUtils.makeStarProjection((TypeParameterDescriptor)annotated, (ErasureTypeAttributes)object2);
                typeProjection = typeProjection2;
                Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"");
            }
            object5 = typeProjection;
            object5 = TuplesKt.to((Object)annotated.getTypeConstructor(), object5);
            map.put(object5.getFirst(), object5.getSecond());
        }
        set = object4;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(TypeConstructorSubstitution$Companion.createByConstructorsMap$default(TypeConstructorSubstitution.Companion, (Map)((Object)set), false, 2, null));
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"");
        object3 = typeSubstitutor2;
        List<KotlinType> list = object.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        object = this.substituteErasedUpperBounds((TypeSubstitutor)object3, list, (ErasureTypeAttributes)object2);
        if (!((Collection)object).isEmpty()) {
            Object object6;
            if (!this.options.getIntersectUpperBounds()) {
                if (!(object.size() == 1)) {
                    object3 = "Should only be one computed upper bound if no need to intersect all bounds";
                    throw new IllegalArgumentException(object3.toString());
                }
                return (KotlinType)CollectionsKt.single((Iterable)((Iterable)object));
            }
            object4 = object6 = (Iterable)CollectionsKt.toList((Iterable)((Iterable)object));
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object6, (int)10));
            object6 = object4.iterator();
            while (object6.hasNext()) {
                map = object6.next();
                annotated = (KotlinType)((Object)map);
                object2 = object;
                object2.add(((KotlinType)annotated).unwrap());
            }
            return IntersectionTypeKt.intersectTypes((List)object);
        }
        return this.getDefaultType((ErasureTypeAttributes)object2);
    }

    private final Set<KotlinType> substituteErasedUpperBounds(TypeSubstitutor typeSubstitutor2, List<? extends KotlinType> object, ErasureTypeAttributes erasureTypeAttributes) {
        Set set;
        Set set2 = set = SetsKt.createSetBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            KotlinType kotlinType = (KotlinType)object.next();
            ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof ClassDescriptor) {
                set2.add(Companion.replaceArgumentsOfUpperBound(kotlinType, typeSubstitutor2, erasureTypeAttributes.getVisitedTypeParameters(), this.options.getLeaveNonTypeParameterTypes()));
            } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Set<TypeParameterDescriptor> set3 = erasureTypeAttributes.getVisitedTypeParameters();
                boolean bl = set3 != null ? set3.contains(classifierDescriptor) : false;
                if (bl) {
                    set2.add(this.getDefaultType(erasureTypeAttributes));
                } else {
                    List<KotlinType> list = ((TypeParameterDescriptor)classifierDescriptor).getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"");
                    set2.addAll((Collection)this.substituteErasedUpperBounds(typeSubstitutor2, list, erasureTypeAttributes));
                }
            }
            if (this.options.getIntersectUpperBounds()) continue;
        }
        return SetsKt.build((Set)set);
    }

    public static final /* synthetic */ KotlinType access$getErasedUpperBoundInternal(TypeParameterUpperBoundEraser typeParameterUpperBoundEraser, TypeParameterDescriptor typeParameterDescriptor, ErasureTypeAttributes erasureTypeAttributes) {
        return typeParameterUpperBoundEraser.getErasedUpperBoundInternal(typeParameterDescriptor, erasureTypeAttributes);
    }
}

