/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.Cache;
import io.ktor.server.sessions.KeyState;
import io.ktor.server.sessions.ListElement;
import io.ktor.server.sessions.PullableLinkedList;
import io.ktor.server.sessions.TimeoutWorker;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0019\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u001cH\u0016J\u0017\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010&\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00028\u00002\b\b\u0002\u0010'\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000fX\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u0014X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lio/ktor/server/sessions/BaseTimeoutCache;", "K", "", "V", "Lio/ktor/server/sessions/Cache;", "timeoutValue", "", "touchOnGet", "", "delegate", "(JZLio/ktor/server/sessions/Cache;)V", "cond", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "items", "Lio/ktor/server/sessions/PullableLinkedList;", "Lio/ktor/server/sessions/KeyState;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "map", "Ljava/util/WeakHashMap;", "workerThread", "Ljava/lang/Thread;", "getWorkerThread", "()Ljava/lang/Thread;", "workerThread$delegate", "Lkotlin/Lazy;", "forkIfNeeded", "", "getOrCompute", "key", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invalidate", "(Ljava/lang/Object;)Ljava/lang/Object;", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "invalidateAll", "peek", "pull", "create", "(Ljava/lang/Object;Z)V", "remove", "(Ljava/lang/Object;)V", "ktor-server-sessions"})
@SourceDebugExtension(value={"SMAP\nCacheJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheJvm.kt\nio/ktor/server/sessions/BaseTimeoutCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,281:1\n361#2,7:282\n*S KotlinDebug\n*F\n+ 1 CacheJvm.kt\nio/ktor/server/sessions/BaseTimeoutCache\n*L\n158#1:282,7\n*E\n"})
public final class BaseTimeoutCache<K, V>
implements Cache<K, V> {
    private final long timeoutValue;
    private final boolean touchOnGet;
    @NotNull
    private final Cache<K, V> delegate;
    @NotNull
    private final ReentrantLock lock;
    private final Condition cond;
    @NotNull
    private final PullableLinkedList<KeyState<K>> items;
    @NotNull
    private final WeakHashMap<K, KeyState<K>> map;
    @NotNull
    private final Lazy workerThread$delegate;

    public BaseTimeoutCache(long timeoutValue, boolean touchOnGet, @NotNull Cache<? super K, V> delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        this.timeoutValue = timeoutValue;
        this.touchOnGet = touchOnGet;
        this.delegate = delegate;
        this.lock = new ReentrantLock();
        this.cond = this.lock.newCondition();
        this.items = new PullableLinkedList();
        this.map = new WeakHashMap();
        this.workerThread$delegate = LazyKt.lazy((Function0)new Function0<Thread>(this){
            final /* synthetic */ BaseTimeoutCache<K, V> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Thread invoke() {
                Thread thread2;
                ReentrantLock reentrantLock = BaseTimeoutCache.access$getLock$p(this.this$0);
                Condition condition = BaseTimeoutCache.access$getCond$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(condition, "access$getCond$p(...)");
                Thread $this$invoke_u24lambda_u240 = thread2 = new Thread(new TimeoutWorker<K>(this.this$0, reentrantLock, condition, BaseTimeoutCache.access$getItems$p(this.this$0)));
                boolean bl = false;
                $this$invoke_u24lambda_u240.setDaemon(true);
                $this$invoke_u24lambda_u240.start();
                return thread2;
            }
        });
    }

    private final Thread getWorkerThread() {
        Lazy lazy2 = this.workerThread$delegate;
        return (Thread)lazy2.getValue();
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull K key2, @NotNull Continuation<? super V> $completion) {
        if (this.touchOnGet) {
            BaseTimeoutCache.pull$default(this, key2, false, 2, null);
        }
        return this.delegate.getOrCompute(key2, $completion);
    }

    @Override
    @Nullable
    public V peek(@NotNull K key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        if (this.touchOnGet) {
            this.pull(key2, false);
        }
        return this.delegate.peek(key2);
    }

    @Override
    @Nullable
    public V invalidate(@NotNull K key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        this.remove(key2);
        return this.delegate.invalidate(key2);
    }

    @Override
    public boolean invalidate(@NotNull K key2, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.delegate.invalidate(key2, value)) {
            this.remove(key2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.items.clear();
            this.cond.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void forkIfNeeded() {
        if (!this.items.isEmpty() && !this.getWorkerThread().isAlive()) {
            throw new IllegalStateException("Daemon thread is already dead");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pull(K key2, boolean create2) {
        Lock lock = this.lock;
        lock.lock();
        try {
            KeyState state;
            KeyState keyState;
            boolean bl = false;
            if (create2) {
                Object object;
                Map $this$getOrPut$iv = this.map;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key2);
                if (value$iv == null) {
                    boolean bl2 = false;
                    KeyState<K> answer$iv = new KeyState<K>(key2, this.timeoutValue);
                    $this$getOrPut$iv.put(key2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                keyState = (KeyState)object;
            } else {
                keyState = state = this.map.get(key2);
            }
            if (state != null) {
                state.touch();
                this.items.pull((KeyState<K>)((ListElement)state));
                this.cond.signalAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.forkIfNeeded();
    }

    static /* synthetic */ void pull$default(BaseTimeoutCache baseTimeoutCache, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        baseTimeoutCache.pull(object, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void remove(K key2) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            KeyState<K> keyState = this.map.remove(key2);
            if (keyState != null) {
                KeyState<K> it = keyState;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                this.items.remove((KeyState<K>)((ListElement)it));
                this.cond.signalAll();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(BaseTimeoutCache $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Condition access$getCond$p(BaseTimeoutCache $this) {
        return $this.cond;
    }

    public static final /* synthetic */ PullableLinkedList access$getItems$p(BaseTimeoutCache $this) {
        return $this.items;
    }
}

