/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions.serialization;

import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.NamedValueDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0014H\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\fH\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/ktor/server/sessions/serialization/MapDecoder;", "Lkotlinx/serialization/internal/NamedValueDecoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "string", "", "(Lkotlinx/serialization/modules/SerializersModule;Ljava/lang/String;)V", "parameterNames", "", "parameters", "Lio/ktor/http/Parameters;", "position", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "size", "currentElement", "tag", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeTaggedBoolean", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "enumDescriptor", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "", "decodeTaggedNotNullMark", "decodeTaggedNull", "", "decodeTaggedString", "elementName", "index", "ktor-server-sessions"})
public final class MapDecoder
extends NamedValueDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final List<String> parameterNames;
    private final int size;
    private int position;

    public MapDecoder(@NotNull SerializersModule serializersModule, @NotNull String string) {
        Intrinsics.checkNotNullParameter(serializersModule, "serializersModule");
        Intrinsics.checkNotNullParameter(string, "string");
        this.serializersModule = serializersModule;
        this.parameters = QueryKt.parseQueryString$default(string, 0, 0, true, 6, null);
        this.parameterNames = CollectionsKt.toList((Iterable)this.parameters.names());
        this.size = this.parameterNames.size() * 2;
        this.position = -1;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    protected String elementName(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        int i2 = index / 2;
        return this.parameterNames.get(i2);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.position < this.size - 1) {
            int n = this.position;
            this.position = n + 1;
            return this.position;
        }
        return -1;
    }

    private final String currentElement(String tag2) {
        String string;
        if (this.position % 2 == 0) {
            string = tag2;
        } else {
            String string2 = this.parameters.get(tag2);
            string = string2;
            Intrinsics.checkNotNull(string2);
        }
        String value = string;
        return StringsKt.startsWith$default(value, "#bo", false, 2, null) ? StringsKt.drop(value, 3) : (StringsKt.startsWith$default(value, "#ch", false, 2, null) ? StringsKt.drop(value, 3) : StringsKt.drop(value, 2));
    }

    @Override
    protected boolean decodeTaggedBoolean(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return Intrinsics.areEqual(this.currentElement(tag2), "t");
    }

    @Override
    protected char decodeTaggedChar(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return this.currentElement(tag2).charAt(0);
    }

    @Override
    protected double decodeTaggedDouble(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return Double.parseDouble(this.currentElement(tag2));
    }

    @Override
    protected float decodeTaggedFloat(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return Float.parseFloat(this.currentElement(tag2));
    }

    @Override
    protected int decodeTaggedInt(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return Integer.parseInt(this.currentElement(tag2));
    }

    @Override
    protected long decodeTaggedLong(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return Long.parseLong(this.currentElement(tag2));
    }

    @Override
    @NotNull
    protected String decodeTaggedString(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return this.currentElement(tag2);
    }

    @Override
    protected boolean decodeTaggedNotNullMark(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return !Intrinsics.areEqual(this.currentElement(tag2), "#n");
    }

    @Override
    @Nullable
    protected Void decodeTaggedNull(@NotNull String tag2) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        return null;
    }

    @Override
    protected int decodeTaggedEnum(@NotNull String tag2, @NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(tag2, "tag");
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        String enumName = this.decodeTaggedString(tag2);
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new IllegalStateException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

