/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Throwables {
    private static final Method getSuppressed = Throwables.initGetSuppressed();
    private static final String[] TEST_FRAMEWORK_METHOD_NAME_PREFIXES = new String[]{"org.junit.runner.", "org.junit.runners.", "org.junit.experimental.runners.", "org.junit.internal.", "junit.extensions", "junit.framework", "junit.runner", "junit.textui"};
    private static final String[] TEST_FRAMEWORK_TEST_METHOD_NAME_PREFIXES = new String[]{"org.junit.internal.StackTracesTest"};
    private static final String[] REFLECTION_METHOD_NAME_PREFIXES = new String[]{"sun.reflect.", "java.lang.reflect.", "jdk.internal.reflect.", "org.junit.rules.RunRules.<init>(", "org.junit.rules.RunRules.applyAll(", "org.junit.runners.RuleContainer.apply(", "junit.framework.TestCase.runBare("};

    private Throwables() {
    }

    public static Exception rethrowAsException(Throwable e) throws Exception {
        Throwables.rethrow(e);
        return null;
    }

    private static <T extends Throwable> void rethrow(Throwable e) throws T {
        throw e;
    }

    public static String getStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        exception.printStackTrace(writer);
        return stringWriter.toString();
    }

    public static String getTrimmedStackTrace(Throwable exception) {
        List<String> trimmedStackTraceLines = Throwables.getTrimmedStackTraceLines(exception);
        if (trimmedStackTraceLines.isEmpty()) {
            return Throwables.getFullStackTrace(exception);
        }
        StringBuilder result2 = new StringBuilder(exception.toString());
        Throwables.appendStackTraceLines(trimmedStackTraceLines, result2);
        Throwables.appendStackTraceLines(Throwables.getCauseStackTraceLines(exception), result2);
        return result2.toString();
    }

    private static List<String> getTrimmedStackTraceLines(Throwable exception) {
        List<StackTraceElement> stackTraceElements = Arrays.asList(exception.getStackTrace());
        int linesToInclude = stackTraceElements.size();
        State state = State.PROCESSING_OTHER_CODE;
        for (StackTraceElement stackTraceElement : Throwables.asReversedList(stackTraceElements)) {
            if ((state = state.processStackTraceElement(stackTraceElement)) == State.DONE) {
                ArrayList<String> trimmedLines = new ArrayList<String>(linesToInclude + 2);
                trimmedLines.add("");
                for (StackTraceElement each : stackTraceElements.subList(0, linesToInclude)) {
                    trimmedLines.add("\tat " + each);
                }
                if (exception.getCause() != null) {
                    trimmedLines.add("\t... " + (stackTraceElements.size() - trimmedLines.size()) + " trimmed");
                }
                return trimmedLines;
            }
            --linesToInclude;
        }
        return Collections.emptyList();
    }

    private static Method initGetSuppressed() {
        try {
            return Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static boolean hasSuppressed(Throwable exception) {
        if (getSuppressed == null) {
            return false;
        }
        try {
            Throwable[] suppressed = (Throwable[])getSuppressed.invoke((Object)exception, new Object[0]);
            return suppressed.length != 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static List<String> getCauseStackTraceLines(Throwable exception) {
        if (exception.getCause() != null || Throwables.hasSuppressed(exception)) {
            String fullTrace = Throwables.getFullStackTrace(exception);
            BufferedReader reader = new BufferedReader(new StringReader(fullTrace.substring(exception.toString().length())));
            ArrayList<String> causedByLines = new ArrayList<String>();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("Caused by: ") && !line.trim().startsWith("Suppressed: ")) continue;
                    causedByLines.add(line);
                    while ((line = reader.readLine()) != null) {
                        causedByLines.add(line);
                    }
                    return causedByLines;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static String getFullStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        exception.printStackTrace(writer);
        return stringWriter.toString();
    }

    private static void appendStackTraceLines(List<String> stackTraceLines, StringBuilder destBuilder) {
        for (String stackTraceLine : stackTraceLines) {
            destBuilder.append(String.format("%s%n", stackTraceLine));
        }
    }

    private static <T> List<T> asReversedList(final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(list.size() - index - 1);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    private static boolean isTestFrameworkMethod(String methodName) {
        return Throwables.isMatchingMethod(methodName, TEST_FRAMEWORK_METHOD_NAME_PREFIXES) && !Throwables.isMatchingMethod(methodName, TEST_FRAMEWORK_TEST_METHOD_NAME_PREFIXES);
    }

    private static boolean isReflectionMethod(String methodName) {
        return Throwables.isMatchingMethod(methodName, REFLECTION_METHOD_NAME_PREFIXES);
    }

    private static boolean isMatchingMethod(String methodName, String[] methodNamePrefixes) {
        for (String methodNamePrefix : methodNamePrefixes) {
            if (!methodName.startsWith(methodNamePrefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PROCESSING_OTHER_CODE{

            public State processLine(String methodName) {
                if (Throwables.isTestFrameworkMethod(methodName)) {
                    return PROCESSING_TEST_FRAMEWORK_CODE;
                }
                return this;
            }
        }
        ,
        PROCESSING_TEST_FRAMEWORK_CODE{

            public State processLine(String methodName) {
                if (Throwables.isReflectionMethod(methodName)) {
                    return PROCESSING_REFLECTION_CODE;
                }
                if (Throwables.isTestFrameworkMethod(methodName)) {
                    return this;
                }
                return PROCESSING_OTHER_CODE;
            }
        }
        ,
        PROCESSING_REFLECTION_CODE{

            public State processLine(String methodName) {
                if (Throwables.isReflectionMethod(methodName)) {
                    return this;
                }
                if (Throwables.isTestFrameworkMethod(methodName)) {
                    return PROCESSING_TEST_FRAMEWORK_CODE;
                }
                return DONE;
            }
        }
        ,
        DONE{

            public State processLine(String methodName) {
                return this;
            }
        };


        protected abstract State processLine(String var1);

        public final State processStackTraceElement(StackTraceElement element2) {
            return this.processLine(element2.getClassName() + "." + element2.getMethodName() + "()");
        }
    }
}

