/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestWatcher
implements TestRule {
    @Override
    public Statement apply(final Statement base2, final Description description2) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                TestWatcher.this.startingQuietly(description2, errors);
                try {
                    base2.evaluate();
                    TestWatcher.this.succeededQuietly(description2, errors);
                }
                catch (org.junit.internal.AssumptionViolatedException e) {
                    errors.add(e);
                    TestWatcher.this.skippedQuietly(e, description2, errors);
                }
                catch (Throwable e) {
                    errors.add(e);
                    TestWatcher.this.failedQuietly(e, description2, errors);
                }
                finally {
                    TestWatcher.this.finishedQuietly(description2, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description2, List<Throwable> errors) {
        try {
            this.succeeded(description2);
        }
        catch (Throwable e) {
            errors.add(e);
        }
    }

    private void failedQuietly(Throwable e, Description description2, List<Throwable> errors) {
        try {
            this.failed(e, description2);
        }
        catch (Throwable e1) {
            errors.add(e1);
        }
    }

    private void skippedQuietly(org.junit.internal.AssumptionViolatedException e, Description description2, List<Throwable> errors) {
        try {
            if (e instanceof AssumptionViolatedException) {
                this.skipped((AssumptionViolatedException)e, description2);
            } else {
                this.skipped(e, description2);
            }
        }
        catch (Throwable e1) {
            errors.add(e1);
        }
    }

    private void startingQuietly(Description description2, List<Throwable> errors) {
        try {
            this.starting(description2);
        }
        catch (Throwable e) {
            errors.add(e);
        }
    }

    private void finishedQuietly(Description description2, List<Throwable> errors) {
        try {
            this.finished(description2);
        }
        catch (Throwable e) {
            errors.add(e);
        }
    }

    protected void succeeded(Description description2) {
    }

    protected void failed(Throwable e, Description description2) {
    }

    protected void skipped(AssumptionViolatedException e, Description description2) {
        AssumptionViolatedException asInternalException = e;
        this.skipped((org.junit.internal.AssumptionViolatedException)asInternalException, description2);
    }

    @Deprecated
    protected void skipped(org.junit.internal.AssumptionViolatedException e, Description description2) {
    }

    protected void starting(Description description2) {
    }

    protected void finished(Description description2) {
    }
}

