/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.datasource;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PoolSetup {
    static void setupConnection(String name, String url2, String username, String password, Properties properties2) throws SQLException {
        GenericObjectPool connectionPool = new GenericObjectPool(null, NumberUtils.toInt(properties2.getProperty("dbcpMaxActive"), 8), (byte)NumberUtils.toInt(properties2.getProperty("dbcpWhenExhaustedAction"), 1), NumberUtils.toLong(properties2.getProperty("dbcpMaxWait"), -1L), NumberUtils.toInt(properties2.getProperty("dbcpMaxIdle"), 8), NumberUtils.toInt(properties2.getProperty("dbcpMinIdle"), 0), BooleanUtils.toBoolean(properties2.getProperty("dbcpTestOnBorrow")), BooleanUtils.toBoolean(properties2.getProperty("dbcpTestOnReturn")), NumberUtils.toLong(properties2.getProperty("dbcpTimeBetweenEvictionRunsMillis"), -1L), NumberUtils.toInt(properties2.getProperty("dbcpNumTestsPerEvictionRun"), 3), NumberUtils.toLong(properties2.getProperty("dbcpMinEvictableIdleTimeMillis"), 1800000L), BooleanUtils.toBoolean(properties2.getProperty("dbcpTestWhileIdle")), NumberUtils.toLong(properties2.getProperty("dbcpSoftMinEvictableIdleTimeMillis"), -1L));
        DriverManagerConnectionFactory connectionFactory = username == null || password == null ? new DriverManagerConnectionFactory(url2, null) : new DriverManagerConnectionFactory(url2, username, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, properties2.getProperty("dbcpValidationQuery"), BooleanUtils.toBoolean(properties2.getProperty("dbcpDefaultReadOnly")), BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBooleanObject(properties2.getProperty("dbcpDefaultAutoCommit")), true));
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("WARNING: DBCP needed but not in the classpath. ");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(name, (ObjectPool)connectionPool);
    }

    static String getUrl(String poolName) {
        return "jdbc:apache:commons:dbcp:" + poolName;
    }
}

