/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.osjava.sj.loader.convert.ConverterIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorConverter
implements ConverterIF {
    Logger LOGGER = LoggerFactory.getLogger(ConstructorConverter.class);

    @Override
    public Object convert(Properties properties2, String type2) {
        String value = properties2.getProperty("valueToConvert");
        if (value == null) {
            this.LOGGER.error("properties={} type={}", (Object)properties2, (Object)type2);
            throw new RuntimeException("Missing value");
        }
        try {
            Class<?> clazz = Class.forName(type2);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find class: " + type2, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find (String) constructor on class: " + type2, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class: " + type2, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access class: " + type2, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to pass argument " + value + " to class: " + type2, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke (String) constructor on class: " + type2, e);
        }
    }
}

