/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2;

import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.EncodableDigest;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.GeneralDigest;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Memoable;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Pack;

public class SHA256Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 32;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X = new int[64];
    private int xOff;
    static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256Digest() {
        this.reset();
    }

    public SHA256Digest(SHA256Digest t3) {
        super(t3);
        this.copyIn(t3);
    }

    private void copyIn(SHA256Digest t3) {
        super.copyIn(t3);
        this.H1 = t3.H1;
        this.H2 = t3.H2;
        this.H3 = t3.H3;
        this.H4 = t3.H4;
        this.H5 = t3.H5;
        this.H6 = t3.H6;
        this.H7 = t3.H7;
        this.H8 = t3.H8;
        System.arraycopy(t3.X, 0, this.X, 0, t3.X.length);
        this.xOff = t3.xOff;
    }

    public SHA256Digest(byte[] encodedState) {
        super(encodedState);
        this.H1 = Pack.bigEndianToInt(encodedState, 16);
        this.H2 = Pack.bigEndianToInt(encodedState, 20);
        this.H3 = Pack.bigEndianToInt(encodedState, 24);
        this.H4 = Pack.bigEndianToInt(encodedState, 28);
        this.H5 = Pack.bigEndianToInt(encodedState, 32);
        this.H6 = Pack.bigEndianToInt(encodedState, 36);
        this.H7 = Pack.bigEndianToInt(encodedState, 40);
        this.H8 = Pack.bigEndianToInt(encodedState, 44);
        this.xOff = Pack.bigEndianToInt(encodedState, 48);
        for (int i2 = 0; i2 != this.xOff; ++i2) {
            this.X[i2] = Pack.bigEndianToInt(encodedState, 52 + i2 * 4);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        int n = in[inOff] << 24;
        n |= (in[++inOff] & 0xFF) << 16;
        n |= (in[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n |= in[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] out2, int outOff) {
        this.finish();
        Pack.intToBigEndian(this.H1, out2, outOff);
        Pack.intToBigEndian(this.H2, out2, outOff + 4);
        Pack.intToBigEndian(this.H3, out2, outOff + 8);
        Pack.intToBigEndian(this.H4, out2, outOff + 12);
        Pack.intToBigEndian(this.H5, out2, outOff + 16);
        Pack.intToBigEndian(this.H6, out2, outOff + 20);
        Pack.intToBigEndian(this.H7, out2, outOff + 24);
        Pack.intToBigEndian(this.H8, out2, outOff + 28);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1779033703;
        this.H2 = -1150833019;
        this.H3 = 1013904242;
        this.H4 = -1521486534;
        this.H5 = 1359893119;
        this.H6 = -1694144372;
        this.H7 = 528734635;
        this.H8 = 1541459225;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    @Override
    protected void processBlock() {
        int i2;
        for (int t3 = 16; t3 <= 63; ++t3) {
            this.X[t3] = this.Theta1(this.X[t3 - 2]) + this.X[t3 - 7] + this.Theta0(this.X[t3 - 15]) + this.X[t3 - 16];
        }
        int a2 = this.H1;
        int b2 = this.H2;
        int c = this.H3;
        int d = this.H4;
        int e = this.H5;
        int f = this.H6;
        int g2 = this.H7;
        int h7 = this.H8;
        int t4 = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            d += (h7 += this.Sum1(e) + this.Ch(e, f, g2) + K[t4] + this.X[t4]);
            h7 += this.Sum0(a2) + this.Maj(a2, b2, c);
            c += (g2 += this.Sum1(d) + this.Ch(d, e, f) + K[++t4] + this.X[t4]);
            g2 += this.Sum0(h7) + this.Maj(h7, a2, b2);
            b2 += (f += this.Sum1(c) + this.Ch(c, d, e) + K[++t4] + this.X[t4]);
            f += this.Sum0(g2) + this.Maj(g2, h7, a2);
            a2 += (e += this.Sum1(b2) + this.Ch(b2, c, d) + K[++t4] + this.X[t4]);
            e += this.Sum0(f) + this.Maj(f, g2, h7);
            h7 += (d += this.Sum1(a2) + this.Ch(a2, b2, c) + K[++t4] + this.X[t4]);
            d += this.Sum0(e) + this.Maj(e, f, g2);
            g2 += (c += this.Sum1(h7) + this.Ch(h7, a2, b2) + K[++t4] + this.X[t4]);
            c += this.Sum0(d) + this.Maj(d, e, f);
            f += (b2 += this.Sum1(g2) + this.Ch(g2, h7, a2) + K[++t4] + this.X[t4]);
            b2 += this.Sum0(c) + this.Maj(c, d, e);
            e += (a2 += this.Sum1(f) + this.Ch(f, g2, h7) + K[++t4] + this.X[t4]);
            a2 += this.Sum0(b2) + this.Maj(b2, c, d);
            ++t4;
        }
        this.H1 += a2;
        this.H2 += b2;
        this.H3 += c;
        this.H4 += d;
        this.H5 += e;
        this.H6 += f;
        this.H7 += g2;
        this.H8 += h7;
        this.xOff = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int Ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private int Maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private int Sum0(int x) {
        return (x >>> 2 | x << 30) ^ (x >>> 13 | x << 19) ^ (x >>> 22 | x << 10);
    }

    private int Sum1(int x) {
        return (x >>> 6 | x << 26) ^ (x >>> 11 | x << 21) ^ (x >>> 25 | x << 7);
    }

    private int Theta0(int x) {
        return (x >>> 7 | x << 25) ^ (x >>> 18 | x << 14) ^ x >>> 3;
    }

    private int Theta1(int x) {
        return (x >>> 17 | x << 15) ^ (x >>> 19 | x << 13) ^ x >>> 10;
    }

    @Override
    public Memoable copy() {
        return new SHA256Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA256Digest d = (SHA256Digest)other;
        this.copyIn(d);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] state = new byte[52 + this.xOff * 4];
        super.populateState(state);
        Pack.intToBigEndian(this.H1, state, 16);
        Pack.intToBigEndian(this.H2, state, 20);
        Pack.intToBigEndian(this.H3, state, 24);
        Pack.intToBigEndian(this.H4, state, 28);
        Pack.intToBigEndian(this.H5, state, 32);
        Pack.intToBigEndian(this.H6, state, 36);
        Pack.intToBigEndian(this.H7, state, 40);
        Pack.intToBigEndian(this.H8, state, 44);
        Pack.intToBigEndian(this.xOff, state, 48);
        for (int i2 = 0; i2 != this.xOff; ++i2) {
            Pack.intToBigEndian(this.X[i2], state, 52 + i2 * 4);
        }
        return state;
    }
}

