/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.ModelClassToModelHandlerLinker;
import ch.qos.logback.classic.joran.serializedModel.HardenedModelInputStream;
import ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.Configurator$ExecutionStatus;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

@ConfiguratorRank(value=10)
public class SerializedModelConfigurator
extends ContextAwareBase
implements Configurator {
    public static final String AUTOCONFIG_MODEL_FILE = "logback.scmo";
    public static final String TEST_AUTOCONFIG_MODEL_FILE = "logback-test.scmo";
    protected ModelInterpretationContext modelInterpretationContext;

    @Override
    public Configurator$ExecutionStatus configure(LoggerContext object) {
        object = this.performMultiStepModelFileSearch(true);
        if (object != null) {
            this.configureByResource((URL)object);
            return Configurator$ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator$ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    private void configureByResource(URL uRL) {
        String string = uRL.toString();
        if (string.endsWith(".scmo")) {
            if ((uRL = this.retrieveModel(uRL)) == null) {
                this.addWarn("Empty model. Abandoning.");
                return;
            }
            ModelUtil.resetForReuse((Model)uRL);
            this.buildModelInterpretationContext((Model)uRL);
            string = new DefaultProcessor(this.context, this.modelInterpretationContext);
            Object object = new ModelClassToModelHandlerLinker(this.context);
            object.link((DefaultProcessor)string);
            object = this.context.getConfigurationLock();
            synchronized (object) {
                string.process((Model)uRL);
            }
        } else {
            throw new LogbackException("Unexpected filename extension of file [" + uRL.toString() + "]. Should be .scmo");
        }
    }

    private void buildModelInterpretationContext(Model model) {
        this.modelInterpretationContext = new ModelInterpretationContext(this.context, (Object)this);
        this.modelInterpretationContext.setTopModel(model);
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules(this.modelInterpretationContext.getDefaultNestedComponentRegistry());
        this.modelInterpretationContext.createAppenderBags();
    }

    private Model retrieveModel(URL uRL) {
        block10: {
            Model model;
            block9: {
                long l = System.currentTimeMillis();
                InputStream inputStream = uRL.openStream();
                try {
                    HardenedModelInputStream hardenedModelInputStream = new HardenedModelInputStream(inputStream);
                    Model model2 = (Model)hardenedModelInputStream.readObject();
                    long l2 = System.currentTimeMillis() - l;
                    this.addInfo("Model at [" + String.valueOf(uRL) + "] read in " + l2 + " milliseconds");
                    model = model2;
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        this.addError("Failed to open " + String.valueOf(uRL), iOException);
                        break block10;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.addError("Failed read model object in " + String.valueOf(uRL), classNotFoundException);
                    }
                }
                inputStream.close();
            }
            return model;
        }
        return null;
    }

    private URL performMultiStepModelFileSearch(boolean bl) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject((Object)this);
        URL uRL = this.findModelConfigFileURLFromSystemProperties(classLoader);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(TEST_AUTOCONFIG_MODEL_FILE, classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(AUTOCONFIG_MODEL_FILE, classLoader, bl);
        return uRL;
    }

    URL findModelConfigFileURLFromSystemProperties(ClassLoader object) {
        String string = OptionHelper.getSystemProperty((String)"logback.scmoFile");
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource((String)string, (ClassLoader)object);
                if (uRL != null) {
                    object = uRL;
                    return object;
                }
                object = new File(string);
                if (((File)object).exists() && ((File)object).isFile()) {
                    try {
                        uRL = ((File)object).toURI().toURL();
                        object = uRL;
                        return object;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                this.statusOnResourceSearch(string, uRL);
            }
        }
        return null;
    }

    private URL getResource(String string, ClassLoader object, boolean bl) {
        object = Loader.getResource((String)string, (ClassLoader)object);
        if (bl) {
            this.statusOnResourceSearch(string, (URL)object);
        }
        return object;
    }

    private void statusOnResourceSearch(String string, URL uRL) {
        StatusManager statusManager = this.context.getStatusManager();
        if (uRL == null) {
            statusManager.add((Status)new InfoStatus("Could NOT find resource [" + string + "]", (Object)this.context));
            return;
        }
        statusManager.add((Status)new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", (Object)this.context));
    }
}

