/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.CloseUtil;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.net.SocketFactory;

public class SocketReceiver
extends ReceiverBase
implements SocketConnector.ExceptionHandler,
Runnable {
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private String remoteHost;
    private InetAddress address;
    private int port;
    private int reconnectionDelay;
    private int acceptConnectionTimeout = 5000;
    private String receiverId;
    private volatile Socket socket;
    private Future<Socket> connectorTask;

    @Override
    protected boolean shouldStart() {
        int n = 0;
        if (this.port == 0) {
            ++n;
            this.addError("No port was configured for receiver. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_port");
        }
        if (this.remoteHost == null) {
            ++n;
            this.addError("No host name or address was configured for receiver. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_host");
        }
        if (this.reconnectionDelay == 0) {
            this.reconnectionDelay = 30000;
        }
        if (n == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                SocketReceiver socketReceiver = this;
                socketReceiver.addError("unknown host: " + socketReceiver.remoteHost);
                ++n;
            }
        }
        if (n == 0) {
            this.receiverId = "receiver " + this.remoteHost + ":" + this.port + ": ";
        }
        return n == 0;
    }

    @Override
    protected void onStop() {
        if (this.socket != null) {
            CloseUtil.closeQuietly((Socket)this.socket);
        }
    }

    @Override
    protected Runnable getRunnableTask() {
        return this;
    }

    @Override
    public void run() {
        try {
            LoggerContext loggerContext = (LoggerContext)this.getContext();
            while (!Thread.currentThread().isInterrupted()) {
                SocketReceiver socketReceiver = this;
                SocketConnector socketConnector = socketReceiver.createConnector(socketReceiver.address, this.port, 0, this.reconnectionDelay);
                this.connectorTask = this.activateConnector(socketConnector);
                if (this.connectorTask != null) {
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket != null) {
                        this.dispatchEvents(loggerContext);
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {}
        this.addInfo("shutting down");
    }

    private SocketConnector createConnector(InetAddress inetAddress, int n, int n2, int n3) {
        inetAddress = this.newConnector(inetAddress, n, n2, n3);
        inetAddress.setExceptionHandler(this);
        inetAddress.setSocketFactory(this.getSocketFactory());
        return inetAddress;
    }

    private Future<Socket> activateConnector(SocketConnector socketConnector) {
        try {
            return this.getContext().getScheduledExecutorService().submit(socketConnector);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
    }

    private Socket waitForConnectorToReturnASocket() {
        try {
            Socket socket = this.connectorTask.get();
            this.connectorTask = null;
            return socket;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    private void dispatchEvents(LoggerContext loggerContext) {
        HardenedLoggingEventInputStream hardenedLoggingEventInputStream = null;
        try {
            this.socket.setSoTimeout(this.acceptConnectionTimeout);
            hardenedLoggingEventInputStream = new HardenedLoggingEventInputStream(this.socket.getInputStream());
            this.socket.setSoTimeout(0);
            SocketReceiver socketReceiver = this;
            socketReceiver.addInfo(socketReceiver.receiverId + "connection established");
            while (true) {
                ILoggingEvent iLoggingEvent;
                Logger logger;
                if (!(logger = loggerContext.getLogger((iLoggingEvent = (ILoggingEvent)((ObjectInputStream)((Object)hardenedLoggingEventInputStream)).readObject()).getLoggerName())).isEnabledFor(iLoggingEvent.getLevel())) {
                    continue;
                }
                logger.callAppenders(iLoggingEvent);
            }
        }
        catch (EOFException eOFException) {
            SocketReceiver socketReceiver = this;
            socketReceiver.addInfo(socketReceiver.receiverId + "end-of-stream detected");
            CloseUtil.closeQuietly(hardenedLoggingEventInputStream);
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            SocketReceiver socketReceiver2 = this;
            socketReceiver2.addInfo(socketReceiver2.receiverId + "connection closed");
            return;
        }
        catch (IOException iOException) {
            SocketReceiver socketReceiver = this;
            socketReceiver.addInfo(socketReceiver.receiverId + "connection failed: " + String.valueOf(iOException));
            CloseUtil.closeQuietly((Closeable)((Object)hardenedLoggingEventInputStream));
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            SocketReceiver socketReceiver3 = this;
            socketReceiver3.addInfo(socketReceiver3.receiverId + "connection closed");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            SocketReceiver socketReceiver = this;
            socketReceiver.addInfo(socketReceiver.receiverId + "unknown event class: " + String.valueOf(classNotFoundException));
            {
                catch (Throwable throwable) {
                    CloseUtil.closeQuietly(hardenedLoggingEventInputStream);
                    CloseUtil.closeQuietly((Socket)this.socket);
                    this.socket = null;
                    SocketReceiver socketReceiver4 = this;
                    socketReceiver4.addInfo(socketReceiver4.receiverId + "connection closed");
                    throw throwable;
                }
            }
            CloseUtil.closeQuietly((Closeable)((Object)hardenedLoggingEventInputStream));
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            SocketReceiver socketReceiver5 = this;
            socketReceiver5.addInfo(socketReceiver5.receiverId + "connection closed");
            return;
        }
    }

    public void connectionFailed(SocketConnector socketConnector, Exception exception) {
        if (exception instanceof InterruptedException) {
            this.addInfo("connector interrupted");
            return;
        }
        if (exception instanceof ConnectException) {
            SocketReceiver socketReceiver = this;
            socketReceiver.addInfo(socketReceiver.receiverId + "connection refused");
            return;
        }
        SocketReceiver socketReceiver = this;
        socketReceiver.addInfo(socketReceiver.receiverId + String.valueOf(exception));
    }

    protected SocketConnector newConnector(InetAddress inetAddress, int n, int n2, int n3) {
        return new DefaultSocketConnector(inetAddress, n, (long)n2, (long)n3);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setReconnectionDelay(int n) {
        this.reconnectionDelay = n;
    }

    public void setAcceptConnectionTimeout(int n) {
        this.acceptConnectionTimeout = n;
    }
}

