/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$Function;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$KFunction;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$KSuspendFunction;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$SuspendFunction;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap$PlatformMutabilityMapping;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

public final class JavaToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE;
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    private static final HashMap<ClassId, ClassId> mutableToReadOnlyClassId;
    private static final HashMap<ClassId, ClassId> readOnlyToMutableClassId;
    private static final List<JavaToKotlinClassMap$PlatformMutabilityMapping> mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    public final List<JavaToKotlinClassMap$PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    public final ClassId mapJavaToKotlin(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    public final ClassId mapKotlinToJava(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_SUSPEND_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_K_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_K_SUSPEND_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        return kotlinToJava.get(fqNameUnsafe);
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe object, String string) {
        String string2 = ((FqNameUnsafe)object).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        object = StringsKt.substringAfter((String)string2, (String)string, (String)"");
        if (((CharSequence)object).length() > 0 && !StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)'0', (boolean)false, (int)2, null)) {
            return (object = StringsKt.toIntOrNull((String)object)) != null && (Integer)object >= 23;
        }
        return false;
    }

    private final void addMapping(JavaToKotlinClassMap$PlatformMutabilityMapping object) {
        Object object2 = ((JavaToKotlinClassMap$PlatformMutabilityMapping)object).component1();
        Object object3 = ((JavaToKotlinClassMap$PlatformMutabilityMapping)object).component2();
        object = ((JavaToKotlinClassMap$PlatformMutabilityMapping)object).component3();
        this.add((ClassId)object2, (ClassId)object3);
        FqName fqName2 = ((ClassId)object).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        this.addKotlinToJava(fqName2, (ClassId)object2);
        ((Map)mutableToReadOnlyClassId).put(object, object3);
        ((Map)readOnlyToMutableClassId).put(object3, object);
        FqName fqName3 = ((ClassId)object3).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"");
        object2 = fqName3;
        FqName fqName4 = ((ClassId)object).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"");
        object3 = fqName4;
        Map map = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = ((ClassId)object).asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
        map.put(fqNameUnsafe, object2);
        map = readOnlyToMutable;
        FqNameUnsafe fqNameUnsafe2 = ((FqName)object2).toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe2, (String)"");
        map.put(fqNameUnsafe2, object3);
    }

    private final void add(ClassId classId, ClassId classId2) {
        this.addJavaToKotlin(classId, classId2);
        FqName fqName2 = classId2.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        this.addKotlinToJava(fqName2, classId);
    }

    private final void addTopLevel(Class<?> clazz, FqNameUnsafe fqNameUnsafe) {
        FqName fqName2 = fqNameUnsafe.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        this.addTopLevel(clazz, fqName2);
    }

    private final void addTopLevel(Class<?> clazz, FqName fqName2) {
        JavaToKotlinClassMap javaToKotlinClassMap = this;
        ClassId classId = javaToKotlinClassMap.classId(clazz);
        ClassId classId2 = ClassId.topLevel(fqName2);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"");
        javaToKotlinClassMap.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId classId, ClassId classId2) {
        Map map = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
        map.put(fqNameUnsafe, classId2);
    }

    private final void addKotlinToJava(FqName fqName2, ClassId classId) {
        Map map = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
        map.put(fqNameUnsafe, classId);
    }

    public final FqName mutableToReadOnly(FqNameUnsafe fqNameUnsafe) {
        return (FqName)((Map)mutableToReadOnly).get(fqNameUnsafe);
    }

    public final FqName readOnlyToMutable(FqNameUnsafe fqNameUnsafe) {
        return (FqName)((Map)readOnlyToMutable).get(fqNameUnsafe);
    }

    public final boolean isMutable(FqNameUnsafe fqNameUnsafe) {
        return ((Map)mutableToReadOnly).containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(FqNameUnsafe fqNameUnsafe) {
        return ((Map)readOnlyToMutable).containsKey(fqNameUnsafe);
    }

    private final ClassId classId(Class<?> object) {
        boolean bl;
        boolean bl2 = bl = !((Class)object).isPrimitive() && !((Class)object).isArray();
        if (_Assertions.ENABLED && !bl) {
            object = "Invalid class: " + object;
            throw new AssertionError(object);
        }
        Class<?> clazz = ((Class)object).getDeclaringClass();
        if (clazz == null) {
            ClassId classId = ClassId.topLevel(new FqName(((Class)object).getCanonicalName()));
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
            return classId;
        }
        ClassId classId = this.classId(clazz).createNestedClassId(Name.identifier(((Class)object).getSimpleName()));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int n;
        void var1_13;
        INSTANCE = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionTypeKind$Function.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind$Function.INSTANCE.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionTypeKind$KFunction.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind$KFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind$SuspendFunction.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind$SuspendFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind$KSuspendFunction.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind$KSuspendFunction.INSTANCE.getClassNamePrefix();
        ClassId classId = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
        FUNCTION_N_CLASS_ID = classId;
        FqName fqName2 = classId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        FUNCTION_N_FQ_NAME = fqName2;
        K_FUNCTION_CLASS_ID = StandardClassIds.INSTANCE.getKFunction();
        K_CLASS_CLASS_ID = StandardClassIds.INSTANCE.getKClass();
        CLASS_CLASS_ID = INSTANCE.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        mutableToReadOnlyClassId = new HashMap();
        readOnlyToMutableClassId = new HashMap();
        Object[] objectArray = new JavaToKotlinClassMap$PlatformMutabilityMapping[8];
        Object objectArray2 = objectArray;
        JavaToKotlinClassMap object3 = INSTANCE;
        ClassId classId2 = ClassId.topLevel(StandardNames$FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"");
        ClassId classId3 = classId2;
        FqName fqName3 = StandardNames$FqNames.mutableIterable;
        FqName fqName4 = classId3.getPackageFqName();
        FqName fqName5 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"");
        ClassId classId4 = new ClassId(fqName4, FqNamesUtilKt.tail(fqName3, fqName5), false);
        objectArray[0] = new JavaToKotlinClassMap$PlatformMutabilityMapping(object3.classId(Iterable.class), classId3, classId4);
        JavaToKotlinClassMap javaToKotlinClassMap = INSTANCE;
        ClassId classId5 = ClassId.topLevel(StandardNames$FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId5, (String)"");
        classId3 = classId5;
        FqName fqName6 = StandardNames$FqNames.mutableIterator;
        FqName fqName7 = classId3.getPackageFqName();
        FqName fqName8 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"");
        ClassId classId6 = new ClassId(fqName7, FqNamesUtilKt.tail(fqName6, fqName8), false);
        objectArray2[1] = new JavaToKotlinClassMap$PlatformMutabilityMapping(javaToKotlinClassMap.classId(Iterator.class), classId3, classId6);
        JavaToKotlinClassMap classId13 = INSTANCE;
        ClassId classId7 = ClassId.topLevel(StandardNames$FqNames.collection);
        Intrinsics.checkNotNullExpressionValue((Object)classId7, (String)"");
        classId3 = classId7;
        FqName fqName9 = StandardNames$FqNames.mutableCollection;
        FqName fqName10 = classId3.getPackageFqName();
        FqName fqName11 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName11, (String)"");
        ClassId classId8 = new ClassId(fqName10, FqNamesUtilKt.tail(fqName9, fqName11), false);
        objectArray2[2] = new JavaToKotlinClassMap$PlatformMutabilityMapping(classId13.classId(Collection.class), classId3, classId8);
        JavaToKotlinClassMap functionTypeKind$KSuspendFunction = INSTANCE;
        ClassId classId9 = ClassId.topLevel(StandardNames$FqNames.list);
        Intrinsics.checkNotNullExpressionValue((Object)classId9, (String)"");
        classId3 = classId9;
        FqName fqName12 = StandardNames$FqNames.mutableList;
        FqName fqName13 = classId3.getPackageFqName();
        FqName fqName14 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName14, (String)"");
        ClassId classId10 = new ClassId(fqName13, FqNamesUtilKt.tail(fqName12, fqName14), false);
        objectArray2[3] = new JavaToKotlinClassMap$PlatformMutabilityMapping(functionTypeKind$KSuspendFunction.classId(List.class), classId3, classId10);
        JavaToKotlinClassMap javaToKotlinClassMap2 = INSTANCE;
        ClassId classId11 = ClassId.topLevel(StandardNames$FqNames.set);
        Intrinsics.checkNotNullExpressionValue((Object)classId11, (String)"");
        classId3 = classId11;
        FqName fqName15 = StandardNames$FqNames.mutableSet;
        FqName fqName16 = classId3.getPackageFqName();
        FqName fqName17 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName17, (String)"");
        ClassId classId12 = new ClassId(fqName16, FqNamesUtilKt.tail(fqName15, fqName17), false);
        objectArray2[4] = new JavaToKotlinClassMap$PlatformMutabilityMapping(javaToKotlinClassMap2.classId(Set.class), classId3, classId12);
        JavaToKotlinClassMap javaToKotlinClassMap3 = INSTANCE;
        ClassId classId14 = ClassId.topLevel(StandardNames$FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId14, (String)"");
        classId3 = classId14;
        FqName fqName18 = StandardNames$FqNames.mutableListIterator;
        FqName fqName19 = classId3.getPackageFqName();
        FqName fqName20 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName20, (String)"");
        ClassId classId15 = new ClassId(fqName19, FqNamesUtilKt.tail(fqName18, fqName20), false);
        objectArray2[5] = new JavaToKotlinClassMap$PlatformMutabilityMapping(javaToKotlinClassMap3.classId(ListIterator.class), classId3, classId15);
        JavaToKotlinClassMap javaToKotlinClassMap4 = INSTANCE;
        ClassId classId16 = ClassId.topLevel(StandardNames$FqNames.map);
        Intrinsics.checkNotNullExpressionValue((Object)classId16, (String)"");
        classId3 = classId16;
        FqName fqName21 = StandardNames$FqNames.mutableMap;
        FqName fqName22 = classId3.getPackageFqName();
        FqName fqName23 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName23, (String)"");
        ClassId classId17 = new ClassId(fqName22, FqNamesUtilKt.tail(fqName21, fqName23), false);
        objectArray2[6] = new JavaToKotlinClassMap$PlatformMutabilityMapping(javaToKotlinClassMap4.classId(Map.class), classId3, classId17);
        JavaToKotlinClassMap javaToKotlinClassMap5 = INSTANCE;
        ClassId classId18 = ClassId.topLevel(StandardNames$FqNames.map).createNestedClassId(StandardNames$FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)classId18, (String)"");
        classId3 = classId18;
        FqName fqName24 = StandardNames$FqNames.mutableMapEntry;
        FqName fqName25 = classId3.getPackageFqName();
        FqName fqName26 = classId3.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName26, (String)"");
        ClassId classId19 = new ClassId(fqName25, FqNamesUtilKt.tail(fqName24, fqName26), false);
        objectArray2[7] = new JavaToKotlinClassMap$PlatformMutabilityMapping(javaToKotlinClassMap5.classId(Map.Entry.class), classId3, classId19);
        mutabilityMappings = CollectionsKt.listOf((Object[])objectArray2);
        INSTANCE.addTopLevel(Object.class, StandardNames$FqNames.any);
        INSTANCE.addTopLevel(String.class, StandardNames$FqNames.string);
        INSTANCE.addTopLevel(CharSequence.class, StandardNames$FqNames.charSequence);
        INSTANCE.addTopLevel(Throwable.class, StandardNames$FqNames.throwable);
        INSTANCE.addTopLevel(Cloneable.class, StandardNames$FqNames.cloneable);
        INSTANCE.addTopLevel(Number.class, StandardNames$FqNames.number);
        INSTANCE.addTopLevel(Comparable.class, StandardNames$FqNames.comparable);
        INSTANCE.addTopLevel(Enum.class, StandardNames$FqNames._enum);
        INSTANCE.addTopLevel(Annotation.class, StandardNames$FqNames.annotation);
        for (JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping : mutabilityMappings) {
            INSTANCE.addMapping(javaToKotlinClassMap$PlatformMutabilityMapping);
        }
        objectArray2 = JvmPrimitiveType.values();
        boolean bl = false;
        int n2 = ((Object)objectArray2).length;
        while (var1_13 < n2) {
            Object object = objectArray2[var1_13];
            ClassId classId20 = ClassId.topLevel(((JvmPrimitiveType)((Object)object)).getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId20, (String)"");
            PrimitiveType primitiveType = ((JvmPrimitiveType)((Object)object)).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"");
            ClassId classId21 = ClassId.topLevel(StandardNames.getPrimitiveFqName(primitiveType));
            Intrinsics.checkNotNullExpressionValue((Object)classId21, (String)"");
            INSTANCE.add(classId20, classId21);
            ++var1_13;
        }
        for (ClassId classId22 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId23 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId22.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue((Object)classId23, (String)"");
            ClassId classId24 = classId22.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue((Object)classId24, (String)"");
            INSTANCE.add(classId23, classId24);
        }
        for (n = 0; n < 23; ++n) {
            ClassId classId25 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + n));
            Intrinsics.checkNotNullExpressionValue((Object)classId25, (String)"");
            INSTANCE.add(classId25, StandardNames.getFunctionClassId(n));
            INSTANCE.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + n), K_FUNCTION_CLASS_ID);
        }
        for (n = 0; n < 22; ++n) {
            FunctionTypeKind$KSuspendFunction functionTypeKind$KSuspendFunction2 = FunctionTypeKind$KSuspendFunction.INSTANCE;
            String string = functionTypeKind$KSuspendFunction2.getPackageFqName().toString() + '.' + functionTypeKind$KSuspendFunction2.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName(string + n), K_FUNCTION_CLASS_ID);
        }
        FqName fqName27 = StandardNames$FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName27, (String)"");
        INSTANCE.addKotlinToJava(fqName27, INSTANCE.classId(Void.class));
    }
}

