/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.SpecialJvmAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoader$AnnotationsContainer;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoader$Companion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoader$PropertyRelatedElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoader$WhenMappings;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoader$loadClassAnnotations$1;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoaderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Class$Kind;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Constructor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$EnumEntry;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Function;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Property;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Type;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$TypeParameter;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$ValueParameter;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf$JvmMethodSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf$JvmPropertySignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature$Method;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$ExtendableMessage;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$GeneratedExtension;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer$Class;
import kotlin.text.StringsKt;

public abstract class AbstractBinaryClassAnnotationLoader<A, S extends AbstractBinaryClassAnnotationLoader$AnnotationsContainer<? extends A>>
implements AnnotationLoader<A> {
    public static final AbstractBinaryClassAnnotationLoader$Companion Companion = new AbstractBinaryClassAnnotationLoader$Companion(null);
    private final KotlinClassFinder kotlinClassFinder;

    public AbstractBinaryClassAnnotationLoader(KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
        this.kotlinClassFinder = kotlinClassFinder;
    }

    protected final KotlinClassFinder getKotlinClassFinder() {
        return this.kotlinClassFinder;
    }

    public abstract JvmMetadataVersion getJvmMetadataVersion();

    protected abstract S getAnnotationsContainer(KotlinJvmBinaryClass var1);

    protected abstract KotlinJvmBinaryClass$AnnotationArgumentVisitor loadAnnotation(ClassId var1, SourceElement var2, List<A> var3);

    public abstract A loadAnnotation(ProtoBuf$Annotation var1, NameResolver var2);

    protected final KotlinJvmBinaryClass$AnnotationArgumentVisitor loadAnnotationIfNotSpecial(ClassId classId, SourceElement sourceElement, List<A> list) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (SpecialJvmAnnotations.INSTANCE.getSPECIAL_ANNOTATIONS().contains(classId)) {
            return null;
        }
        return this.loadAnnotation(classId, sourceElement, list);
    }

    private final KotlinJvmBinaryClass toBinaryClass(ProtoContainer$Class object) {
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = (object = ((ProtoContainer)object).getSource()) instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)object : null;
        if (kotlinJvmBinarySourceElement != null) {
            return kotlinJvmBinarySourceElement.getBinaryClass();
        }
        return null;
    }

    protected byte[] getCachedFileContent(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        return null;
    }

    @Override
    public List<A> loadClassAnnotations(ProtoContainer$Class object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.toBinaryClass((ProtoContainer$Class)object);
        if (kotlinJvmBinaryClass == null) {
            throw new IllegalStateException(("Class for loading annotations is not found: " + ((ProtoContainer$Class)object).debugFqName()).toString());
        }
        object = kotlinJvmBinaryClass;
        ArrayList arrayList = new ArrayList(1);
        object.loadClassAnnotations(new AbstractBinaryClassAnnotationLoader$loadClassAnnotations$1(this, arrayList), this.getCachedFileContent((KotlinJvmBinaryClass)object));
        return arrayList;
    }

    @Override
    public List<A> loadCallableAnnotations(ProtoContainer protoContainer, MessageLite object, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        if (annotatedCallableKind == AnnotatedCallableKind.PROPERTY) {
            return this.loadPropertyAnnotations(protoContainer, (ProtoBuf$Property)object, AbstractBinaryClassAnnotationLoader$PropertyRelatedElement.PROPERTY);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, (MessageLite)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        object = memberSignature;
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, false, false, null, false, 60, null);
    }

    @Override
    public List<A> loadPropertyBackingFieldAnnotations(ProtoContainer protoContainer, ProtoBuf$Property protoBuf$Property) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)protoBuf$Property, (String)"");
        return this.loadPropertyAnnotations(protoContainer, protoBuf$Property, AbstractBinaryClassAnnotationLoader$PropertyRelatedElement.BACKING_FIELD);
    }

    @Override
    public List<A> loadPropertyDelegateFieldAnnotations(ProtoContainer protoContainer, ProtoBuf$Property protoBuf$Property) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)protoBuf$Property, (String)"");
        return this.loadPropertyAnnotations(protoContainer, protoBuf$Property, AbstractBinaryClassAnnotationLoader$PropertyRelatedElement.DELEGATE_FIELD);
    }

    private final List<A> loadPropertyAnnotations(ProtoContainer protoContainer, ProtoBuf$Property object, AbstractBinaryClassAnnotationLoader$PropertyRelatedElement abstractBinaryClassAnnotationLoader$PropertyRelatedElement) {
        Boolean bl = Flags.IS_CONST.get(((ProtoBuf$Property)object).getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        boolean bl2 = bl;
        boolean bl3 = JvmProtoBufUtil.isMovedFromInterfaceCompanion((ProtoBuf$Property)object);
        if (abstractBinaryClassAnnotationLoader$PropertyRelatedElement == AbstractBinaryClassAnnotationLoader$PropertyRelatedElement.PROPERTY) {
            MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default((ProtoBuf$Property)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), false, true, false, 40, null);
            if (memberSignature == null) {
                return CollectionsKt.emptyList();
            }
            object = memberSignature;
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, true, false, bl2, bl3, 8, null);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default((ProtoBuf$Property)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), true, false, false, 48, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        object = memberSignature;
        boolean bl4 = StringsKt.contains$default((CharSequence)memberSignature.getSignature(), (CharSequence)"$delegate", (boolean)false, (int)2, null);
        if (bl4 != (abstractBinaryClassAnnotationLoader$PropertyRelatedElement == AbstractBinaryClassAnnotationLoader$PropertyRelatedElement.DELEGATE_FIELD)) {
            return CollectionsKt.emptyList();
        }
        return this.findClassAndLoadMemberAnnotations(protoContainer, (MemberSignature)object, true, true, bl2, bl3);
    }

    @Override
    public List<A> loadEnumEntryAnnotations(ProtoContainer protoContainer, ProtoBuf$EnumEntry object) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        String string = protoContainer.getNameResolver().getString(((ProtoBuf$EnumEntry)object).getName());
        String string2 = ((ProtoContainer$Class)protoContainer).getClassId().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        object = MemberSignature.Companion.fromFieldNameAndDesc(string, ClassMapperLite.mapClass(string2));
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, false, false, null, false, 60, null);
    }

    private final List<A> findClassAndLoadMemberAnnotations(ProtoContainer object, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.findClassWithAnnotationsAndInitializers((ProtoContainer)object, Companion.getSpecialCaseContainerClass((ProtoContainer)object, bl, bl2, bl3, bl4, this.kotlinClassFinder, this.getJvmMetadataVersion()));
        if (kotlinJvmBinaryClass == null) {
            return CollectionsKt.emptyList();
        }
        object = kotlinJvmBinaryClass;
        List list = ((AbstractBinaryClassAnnotationLoader$AnnotationsContainer)this.getAnnotationsContainer((KotlinJvmBinaryClass)object)).getMemberAnnotations().get(memberSignature);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List findClassAndLoadMemberAnnotations$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, ProtoContainer protoContainer, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findClassAndLoadMemberAnnotations");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = null;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        return abstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations(protoContainer, memberSignature, bl, bl2, bl3, bl4);
    }

    @Override
    public List<A> loadValueParameterAnnotations(ProtoContainer protoContainer, MessageLite messageLite, AnnotatedCallableKind object, int n, ProtoBuf$ValueParameter protoBuf$ValueParameter) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)protoBuf$ValueParameter, (String)"");
        object = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, messageLite, protoContainer.getNameResolver(), protoContainer.getTypeTable(), object, false, 16, null);
        if (object != null) {
            int n2 = n + this.computeJvmParameterIndexShift(protoContainer, messageLite);
            MemberSignature memberSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex((MemberSignature)object, n2);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    private final int computeJvmParameterIndexShift(ProtoContainer protoContainer, MessageLite messageLite) {
        MessageLite messageLite2 = messageLite;
        if (messageLite2 instanceof ProtoBuf$Function) {
            if (ProtoTypeTableUtilKt.hasReceiver((ProtoBuf$Function)messageLite)) {
                return 1;
            }
            return 0;
        }
        if (messageLite2 instanceof ProtoBuf$Property) {
            if (ProtoTypeTableUtilKt.hasReceiver((ProtoBuf$Property)messageLite)) {
                return 1;
            }
            return 0;
        }
        if (messageLite2 instanceof ProtoBuf$Constructor) {
            Intrinsics.checkNotNull((Object)protoContainer);
            if (((ProtoContainer$Class)protoContainer).getKind() == ProtoBuf$Class$Kind.ENUM_CLASS) {
                return 2;
            }
            if (((ProtoContainer$Class)protoContainer).isInner()) {
                return 1;
            }
            return 0;
        }
        throw new UnsupportedOperationException("Unsupported message: " + messageLite.getClass());
    }

    @Override
    public List<A> loadExtensionReceiverParameterAnnotations(ProtoContainer protoContainer, MessageLite object, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        object = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, (MessageLite)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (object != null) {
            object = MemberSignature.Companion.fromMethodSignatureAndParameterIndex((MemberSignature)object, 0);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public List<A> loadTypeAnnotations(ProtoBuf$Type object, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        List<ProtoBuf$Annotation> list = ((GeneratedMessageLite$ExtendableMessage)object).getExtension(JvmProtoBuf.typeAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Object object2 = object = (Iterable)list;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (ProtoBuf$Annotation)object3;
            Object object4 = object;
            Intrinsics.checkNotNull(object3);
            object4.add(this.loadAnnotation((ProtoBuf$Annotation)object3, nameResolver));
        }
        return (List)object;
    }

    @Override
    public List<A> loadTypeParameterAnnotations(ProtoBuf$TypeParameter object, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        List<ProtoBuf$Annotation> list = ((GeneratedMessageLite$ExtendableMessage)object).getExtension(JvmProtoBuf.typeParameterAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Object object2 = object = (Iterable)list;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (ProtoBuf$Annotation)object3;
            Object object4 = object;
            Intrinsics.checkNotNull(object3);
            object4.add(this.loadAnnotation((ProtoBuf$Annotation)object3, nameResolver));
        }
        return (List)object;
    }

    protected final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(ProtoContainer protoContainer, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        if (kotlinJvmBinaryClass2 == null) {
            if (protoContainer instanceof ProtoContainer$Class) {
                return this.toBinaryClass((ProtoContainer$Class)protoContainer);
            }
            kotlinJvmBinaryClass2 = null;
        }
        return kotlinJvmBinaryClass2;
    }

    protected final MemberSignature getCallableSignature(MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        MessageLite messageLite2 = messageLite;
        if (messageLite2 instanceof ProtoBuf$Constructor) {
            JvmMemberSignature$Method jvmMemberSignature$Method = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf$Constructor)messageLite, nameResolver, typeTable);
            if (jvmMemberSignature$Method == null) {
                return null;
            }
            return MemberSignature.Companion.fromJvmMemberSignature(jvmMemberSignature$Method);
        }
        if (messageLite2 instanceof ProtoBuf$Function) {
            JvmMemberSignature$Method jvmMemberSignature$Method = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf$Function)messageLite, nameResolver, typeTable);
            if (jvmMemberSignature$Method == null) {
                return null;
            }
            return MemberSignature.Companion.fromJvmMemberSignature(jvmMemberSignature$Method);
        }
        if (messageLite2 instanceof ProtoBuf$Property) {
            GeneratedMessageLite$ExtendableMessage generatedMessageLite$ExtendableMessage = (GeneratedMessageLite$ExtendableMessage)messageLite;
            GeneratedMessageLite$GeneratedExtension<ProtoBuf$Property, JvmProtoBuf$JvmPropertySignature> generatedMessageLite$GeneratedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkNotNullExpressionValue(generatedMessageLite$GeneratedExtension, (String)"");
            JvmProtoBuf$JvmPropertySignature jvmProtoBuf$JvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(generatedMessageLite$ExtendableMessage, generatedMessageLite$GeneratedExtension);
            if (jvmProtoBuf$JvmPropertySignature == null) {
                return null;
            }
            messageLite2 = jvmProtoBuf$JvmPropertySignature;
            switch (AbstractBinaryClassAnnotationLoader$WhenMappings.$EnumSwitchMapping$0[annotatedCallableKind.ordinal()]) {
                case 1: {
                    if (((JvmProtoBuf$JvmPropertySignature)messageLite2).hasGetter()) {
                        JvmProtoBuf$JvmMethodSignature jvmProtoBuf$JvmMethodSignature = ((JvmProtoBuf$JvmPropertySignature)messageLite2).getGetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmProtoBuf$JvmMethodSignature, (String)"");
                        return MemberSignature.Companion.fromMethod(nameResolver, jvmProtoBuf$JvmMethodSignature);
                    }
                    return null;
                }
                case 2: {
                    if (((JvmProtoBuf$JvmPropertySignature)messageLite2).hasSetter()) {
                        JvmProtoBuf$JvmMethodSignature jvmProtoBuf$JvmMethodSignature = ((JvmProtoBuf$JvmPropertySignature)messageLite2).getSetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmProtoBuf$JvmMethodSignature, (String)"");
                        return MemberSignature.Companion.fromMethod(nameResolver, jvmProtoBuf$JvmMethodSignature);
                    }
                    return null;
                }
                case 3: {
                    return AbstractBinaryClassAnnotationLoaderKt.getPropertySignature((ProtoBuf$Property)messageLite, nameResolver, typeTable, true, true, bl);
                }
            }
            return null;
        }
        return null;
    }

    public static /* synthetic */ MemberSignature getCallableSignature$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCallableSignature");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return abstractBinaryClassAnnotationLoader.getCallableSignature(messageLite, nameResolver, typeTable, annotatedCallableKind, bl);
    }

    protected final boolean isImplicitRepeatableContainer(ClassId object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (((ClassId)object).getOuterClassId() == null || !Intrinsics.areEqual((Object)((ClassId)object).getShortClassName().asString(), (Object)"Container")) {
            return false;
        }
        return (object = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, (ClassId)object, this.getJvmMetadataVersion())) != null && SpecialJvmAnnotations.INSTANCE.isAnnotatedWithContainerMetaAnnotation((KotlinJvmBinaryClass)object);
    }
}

