/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqName relativeClassName;
    private final boolean local;

    public static ClassId topLevel(FqName fqName2) {
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(0);
        }
        return new ClassId(fqName2.parent(), fqName2.shortName());
    }

    public ClassId(FqName fqName2, FqName fqName3, boolean bl) {
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(1);
        }
        if (fqName3 == null) {
            ClassId.$$$reportNull$$$0(2);
        }
        this.packageFqName = fqName2;
        assert (!fqName3.isRoot()) : "Class name must not be root: " + fqName2 + (bl ? " (local)" : "");
        this.relativeClassName = fqName3;
        this.local = bl;
    }

    public ClassId(FqName fqName2, Name name) {
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(3);
        }
        if (name == null) {
            ClassId.$$$reportNull$$$0(4);
        }
        this(fqName2, FqName.topLevel(name), false);
    }

    public final FqName getPackageFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(5);
        }
        return fqName2;
    }

    public final FqName getRelativeClassName() {
        FqName fqName2 = this.relativeClassName;
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(6);
        }
        return fqName2;
    }

    public final Name getShortClassName() {
        Name name = this.relativeClassName.shortName();
        if (name == null) {
            ClassId.$$$reportNull$$$0(7);
        }
        return name;
    }

    public final boolean isLocal() {
        return this.local;
    }

    public final ClassId createNestedClassId(Name name) {
        if (name == null) {
            ClassId.$$$reportNull$$$0(8);
        }
        return new ClassId(this.getPackageFqName(), this.relativeClassName.child(name), this.local);
    }

    public final ClassId getOuterClassId() {
        FqName fqName2 = this.relativeClassName.parent();
        if (fqName2.isRoot()) {
            return null;
        }
        return new ClassId(this.getPackageFqName(), fqName2, this.local);
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    public final FqName asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            FqName fqName2 = this.relativeClassName;
            if (fqName2 == null) {
                ClassId.$$$reportNull$$$0(9);
            }
            return fqName2;
        }
        return new FqName(this.packageFqName.asString() + "." + this.relativeClassName.asString());
    }

    public static ClassId fromString(String string) {
        if (string == null) {
            ClassId.$$$reportNull$$$0(11);
        }
        return ClassId.fromString(string, false);
    }

    public static ClassId fromString(String string, boolean bl) {
        String string2;
        int n;
        if (string == null) {
            ClassId.$$$reportNull$$$0(12);
        }
        if ((n = string.lastIndexOf("/")) == -1) {
            string2 = "";
        } else {
            string2 = string.substring(0, n).replace('/', '.');
            string = string.substring(n + 1);
        }
        return new ClassId(new FqName(string2), new FqName(string), bl);
    }

    public final String asString() {
        if (this.packageFqName.isRoot()) {
            String string = this.relativeClassName.asString();
            if (string == null) {
                ClassId.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = this.packageFqName.asString().replace('.', '/') + "/" + this.relativeClassName.asString();
        if (string == null) {
            ClassId.$$$reportNull$$$0(14);
        }
        return string;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (ClassId)object;
        return this.packageFqName.equals(((ClassId)object).packageFqName) && this.relativeClassName.equals(((ClassId)object).relativeClassName) && this.local == ((ClassId)object).local;
    }

    public final int hashCode() {
        int n = this.packageFqName.hashCode();
        n = n * 31 + this.relativeClassName.hashCode();
        n = n * 31 + Boolean.valueOf(this.local).hashCode();
        return n;
    }

    public final String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.asString();
        }
        return this.asString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelFqName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeClassName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/name/ClassId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/name/ClassId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFqName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortClassName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asSingleFqName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "asFqNameString";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "topLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNestedClassId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

