/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Companion;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$LocalClass;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue$Value$NormalClass;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class KClassValue
extends ConstantValue<KClassValue$Value> {
    public static final KClassValue$Companion Companion = new KClassValue$Companion(null);

    public KClassValue(KClassValue$Value kClassValue$Value) {
        Intrinsics.checkNotNullParameter((Object)kClassValue$Value, (String)"");
        super(kClassValue$Value);
    }

    public KClassValue(ClassLiteralValue classLiteralValue) {
        Intrinsics.checkNotNullParameter((Object)classLiteralValue, (String)"");
        this(new KClassValue$Value$NormalClass(classLiteralValue));
    }

    public KClassValue(ClassId classId, int n) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        this(new ClassLiteralValue(classId, n));
    }

    @Override
    public final KotlinType getType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        ClassDescriptor classDescriptor = moduleDescriptor.getBuiltIns().getKClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
        return KotlinTypeFactory.simpleNotNullType(typeAttributes, classDescriptor, CollectionsKt.listOf((Object)new TypeProjectionImpl(this.getArgumentType(moduleDescriptor))));
    }

    public final KotlinType getArgumentType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Object object = (KClassValue$Value)this.getValue();
        if (object instanceof KClassValue$Value$LocalClass) {
            return ((KClassValue$Value$LocalClass)this.getValue()).getType();
        }
        if (object instanceof KClassValue$Value$NormalClass) {
            object = ((KClassValue$Value$NormalClass)this.getValue()).getValue();
            Object object2 = ((ClassLiteralValue)object).component1();
            int n = ((ClassLiteralValue)object).component2();
            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, (ClassId)object2);
            if (classDescriptor == null) {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String string = ((ClassId)object2).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                stringArray[0] = string;
                stringArray2[1] = String.valueOf(n);
                return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_KCLASS_CONSTANT_VALUE, stringArray2);
            }
            object2 = classDescriptor;
            SimpleType simpleType2 = classDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
            object2 = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor.getBuiltIns().getArrayType(Variance.INVARIANT, (KotlinType)object2), (String)"");
            }
            return (KotlinType)object2;
        }
        throw new NoWhenBranchMatchedException();
    }
}

