/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringCommand$Type1KeyWord;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.DataInputByteArray;

public class Type1CharStringParser {
    private static final Log LOG = LogFactory.getLog(Type1CharStringParser.class);
    private static final int CALLSUBR = 10;
    private static final int TWO_BYTE = 12;
    private static final int CALLOTHERSUBR = 16;
    private static final int POP = 17;
    private final String fontName;
    private String currentGlyph;

    public Type1CharStringParser(String string) {
        this.fontName = string;
    }

    public List<Object> parse(byte[] byArray, List<byte[]> list, String string) {
        this.currentGlyph = string;
        return this.parse(byArray, list, new ArrayList<Object>());
    }

    private List<Object> parse(byte[] object, List<byte[]> list, List<Object> list2) {
        object = new DataInputByteArray((byte[])object);
        while (object.hasRemaining()) {
            int n = object.readUnsignedByte();
            if (n == 10) {
                this.processCallSubr(list, list2);
                continue;
            }
            if (n == 12 && object.peekUnsignedByte(0) == 16) {
                this.processCallOtherSubr((DataInput)object, list2);
                continue;
            }
            if (n >= 0 && n <= 31) {
                list2.add(this.readCommand((DataInput)object, n));
                continue;
            }
            if (n >= 32 && n <= 255) {
                list2.add(this.readNumber((DataInput)object, n));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return list2;
    }

    private void processCallSubr(List<byte[]> object, List<Object> list) {
        List<Object> list2 = list;
        Object object2 = list2.remove(list2.size() - 1);
        if (!(object2 instanceof Integer)) {
            LOG.warn((Object)("Parameter " + object2 + " for CALLSUBR is ignored, integer expected in glyph '" + this.currentGlyph + "' of font " + this.fontName));
            return;
        }
        if ((Integer)(object2 = (Integer)object2) >= 0 && (Integer)object2 < object.size()) {
            object2 = object.get((Integer)object2);
            this.parse((byte[])object2, (List<byte[]>)object, list);
            List<Object> list3 = list;
            object = list3.get(list3.size() - 1);
            if (object instanceof CharStringCommand && CharStringCommand$Type1KeyWord.RET == ((CharStringCommand)object).getType1KeyWord()) {
                List<Object> list4 = list;
                list4.remove(list4.size() - 1);
            }
            return;
        }
        LOG.warn((Object)("CALLSUBR is ignored, operand: " + object2 + ", subrs.size(): " + object.size() + " in glyph '" + this.currentGlyph + "' of font " + this.fontName));
        while (true) {
            List<Object> list5 = list;
            if (!(list5.get(list5.size() - 1) instanceof Integer)) break;
            List<Object> list6 = list;
            list6.remove(list6.size() - 1);
        }
    }

    private void processCallOtherSubr(DataInput dataInput, List<Object> list) {
        dataInput.readByte();
        List<Object> list2 = list;
        Integer n = (Integer)list2.remove(list2.size() - 1);
        List<Object> list3 = list;
        Integer n2 = (Integer)list3.remove(list3.size() - 1);
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        switch (n) {
            case 0: {
                arrayDeque.push(Type1CharStringParser.removeInteger(list));
                arrayDeque.push(Type1CharStringParser.removeInteger(list));
                List<Object> list4 = list;
                list4.remove(list4.size() - 1);
                list.add(0);
                list.add(CharStringCommand.COMMAND_CALLOTHERSUBR);
                break;
            }
            case 1: {
                list.add(1);
                list.add(CharStringCommand.COMMAND_CALLOTHERSUBR);
                break;
            }
            case 3: {
                arrayDeque.push(Type1CharStringParser.removeInteger(list));
                break;
            }
            default: {
                for (int i = 0; i < n2; ++i) {
                    arrayDeque.push(Type1CharStringParser.removeInteger(list));
                }
            }
        }
        while (dataInput.peekUnsignedByte(0) == 12 && dataInput.peekUnsignedByte(1) == 17) {
            dataInput.readByte();
            dataInput.readByte();
            list.add(arrayDeque.pop());
        }
        if (!arrayDeque.isEmpty()) {
            LOG.warn((Object)("Value left on the PostScript stack in glyph " + this.currentGlyph + " of font " + this.fontName));
        }
    }

    private static Integer removeInteger(List<Object> list) {
        List<Object> list2 = list;
        Object object = list2.remove(list2.size() - 1);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (CharStringCommand$Type1KeyWord.DIV == ((CharStringCommand)(object = (CharStringCommand)object)).getType1KeyWord()) {
            List<Object> list3 = list;
            int n = (Integer)list3.remove(list3.size() - 1);
            List<Object> list4 = list;
            int n2 = (Integer)list4.remove(list4.size() - 1);
            return n2 / n;
        }
        throw new IOException("Unexpected char string command: " + (Object)((Object)((CharStringCommand)object).getType1KeyWord()));
    }

    private CharStringCommand readCommand(DataInput dataInput, int n) {
        if (n == 12) {
            int n2 = dataInput.readUnsignedByte();
            return CharStringCommand.getInstance(n, n2);
        }
        return CharStringCommand.getInstance(n);
    }

    private Integer readNumber(DataInput dataInput, int n) {
        if (n >= 32 && n <= 246) {
            return n - 139;
        }
        if (n >= 247 && n <= 250) {
            int n2 = dataInput.readUnsignedByte();
            return (n - 247 << 8) + n2 + 108;
        }
        if (n >= 251 && n <= 254) {
            int n3 = dataInput.readUnsignedByte();
            return (-(n - 251) << 8) - n3 - 108;
        }
        if (n == 255) {
            return dataInput.readInt();
        }
        throw new IllegalArgumentException();
    }
}

