/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.KerningSubtable$PairData;
import org.apache.fontbox.ttf.KerningSubtable$PairData0Format0;
import org.apache.fontbox.ttf.TTFDataStream;

public class KerningSubtable {
    private static final Log LOG = LogFactory.getLog(KerningSubtable.class);
    private static final int COVERAGE_HORIZONTAL = 1;
    private static final int COVERAGE_MINIMUMS = 2;
    private static final int COVERAGE_CROSS_STREAM = 4;
    private static final int COVERAGE_FORMAT = 65280;
    private static final int COVERAGE_HORIZONTAL_SHIFT = 0;
    private static final int COVERAGE_MINIMUMS_SHIFT = 1;
    private static final int COVERAGE_CROSS_STREAM_SHIFT = 2;
    private static final int COVERAGE_FORMAT_SHIFT = 8;
    private boolean horizontal;
    private boolean minimums;
    private boolean crossStream;
    private KerningSubtable$PairData pairs;

    KerningSubtable() {
    }

    void read(TTFDataStream tTFDataStream, int n) {
        if (n == 0) {
            this.readSubtable0(tTFDataStream);
            return;
        }
        if (n == 1) {
            this.readSubtable1(tTFDataStream);
            return;
        }
        throw new IllegalStateException();
    }

    public boolean isHorizontalKerning() {
        return this.isHorizontalKerning(false);
    }

    public boolean isHorizontalKerning(boolean bl) {
        if (!this.horizontal) {
            return false;
        }
        if (this.minimums) {
            return false;
        }
        if (bl) {
            return this.crossStream;
        }
        return !this.crossStream;
    }

    public int[] getKerning(int[] nArray) {
        int[] nArray2 = null;
        if (this.pairs != null) {
            int n = nArray.length;
            nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                int n3 = -1;
                for (int j = i + 1; j < n; ++j) {
                    int n4 = nArray[j];
                    if (n4 < 0) continue;
                    n3 = n4;
                    break;
                }
                nArray2[i] = this.getKerning(n2, n3);
            }
        } else {
            LOG.warn((Object)"No kerning subtable data available due to an unsupported kerning subtable version");
        }
        return nArray2;
    }

    public int getKerning(int n, int n2) {
        if (this.pairs == null) {
            LOG.warn((Object)"No kerning subtable data available due to an unsupported kerning subtable version");
            return 0;
        }
        return this.pairs.getKerning(n, n2);
    }

    private void readSubtable0(TTFDataStream tTFDataStream) {
        int n = tTFDataStream.readUnsignedShort();
        if (n != 0) {
            LOG.info((Object)("Unsupported kerning sub-table version: " + n));
            return;
        }
        n = tTFDataStream.readUnsignedShort();
        if (n < 6) {
            LOG.warn((Object)("Kerning sub-table too short, got " + n + " bytes, expect 6 or more."));
            return;
        }
        n = tTFDataStream.readUnsignedShort();
        if (KerningSubtable.isBitsSet(n, 1, 0)) {
            this.horizontal = true;
        }
        if (KerningSubtable.isBitsSet(n, 2, 1)) {
            this.minimums = true;
        }
        if (KerningSubtable.isBitsSet(n, 4, 2)) {
            this.crossStream = true;
        }
        if ((n = KerningSubtable.getBits(n, 65280, 8)) == 0) {
            this.readSubtable0Format0(tTFDataStream);
            return;
        }
        if (n == 2) {
            this.readSubtable0Format2(tTFDataStream);
            return;
        }
        LOG.debug((Object)("Skipped kerning subtable due to an unsupported kerning subtable version: " + n));
    }

    private void readSubtable0Format0(TTFDataStream tTFDataStream) {
        this.pairs = new KerningSubtable$PairData0Format0(null);
        this.pairs.read(tTFDataStream);
    }

    private void readSubtable0Format2(TTFDataStream tTFDataStream) {
        LOG.info((Object)"Kerning subtable format 2 not yet supported.");
    }

    private void readSubtable1(TTFDataStream tTFDataStream) {
        LOG.info((Object)"Kerning subtable format 1 not yet supported.");
    }

    private static boolean isBitsSet(int n, int n2, int n3) {
        return KerningSubtable.getBits(n, n2, n3) != 0;
    }

    private static int getBits(int n, int n2, int n3) {
        return (n & n2) >> n3;
    }
}

