/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class MapBackedScriptFeature
implements ScriptFeature {
    private final String name;
    private final Map<List<Integer>, Integer> featureMap;

    public MapBackedScriptFeature(String string, Map<List<Integer>, Integer> map) {
        this.name = string;
        this.featureMap = map;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<List<Integer>> getAllGlyphIdsForSubstitution() {
        return this.featureMap.keySet();
    }

    @Override
    public boolean canReplaceGlyphs(List<Integer> list) {
        return this.featureMap.containsKey(list);
    }

    @Override
    public Integer getReplacementForGlyphs(List<Integer> list) {
        if (!this.canReplaceGlyphs(list)) {
            throw new UnsupportedOperationException("The glyphs " + list + " cannot be replaced");
        }
        return this.featureMap.get(list);
    }

    public int hashCode() {
        int n = 31 + (this.featureMap == null ? 0 : this.featureMap.hashCode());
        n = n * 31 + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (MapBackedScriptFeature)object;
        if (this.featureMap == null ? ((MapBackedScriptFeature)object).featureMap != null : !this.featureMap.equals(((MapBackedScriptFeature)object).featureMap)) {
            return false;
        }
        return !(this.name == null ? ((MapBackedScriptFeature)object).name != null : !this.name.equals(((MapBackedScriptFeature)object).name));
    }
}

