/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.LogFactoryImpl$1;
import org.apache.commons.logging.impl.LogFactoryImpl$2;
import org.apache.commons.logging.impl.LogFactoryImpl$3;

public class LogFactoryImpl
extends LogFactory {
    private static final String LOGGING_IMPL_LOG4J_LOGGER = "org.apache.commons.logging.impl.Log4JLogger";
    private static final String LOGGING_IMPL_JDK14_LOGGER = "org.apache.commons.logging.impl.Jdk14Logger";
    private static final String LOGGING_IMPL_LUMBERJACK_LOGGER = "org.apache.commons.logging.impl.Jdk13LumberjackLogger";
    private static final String LOGGING_IMPL_SIMPLE_LOGGER = "org.apache.commons.logging.impl.SimpleLog";
    private static final String PKG_IMPL = "org.apache.commons.logging.impl.";
    private static final int PKG_LEN = 32;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    public static final String ALLOW_FLAWED_CONTEXT_PROPERTY = "org.apache.commons.logging.Log.allowFlawedContext";
    public static final String ALLOW_FLAWED_DISCOVERY_PROPERTY = "org.apache.commons.logging.Log.allowFlawedDiscovery";
    public static final String ALLOW_FLAWED_HIERARCHY_PROPERTY = "org.apache.commons.logging.Log.allowFlawedHierarchy";
    private static final String[] classesToDiscover = new String[]{"org.apache.commons.logging.impl.Log4JLogger", "org.apache.commons.logging.impl.Jdk14Logger", "org.apache.commons.logging.impl.Jdk13LumberjackLogger", "org.apache.commons.logging.impl.SimpleLog"};
    private boolean useTCCL = true;
    private String diagnosticPrefix;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactoryImpl.class$("org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory};
    private boolean allowFlawedContext;
    private boolean allowFlawedDiscovery;
    private boolean allowFlawedHierarchy;
    static Class class$java$lang$String;
    static Class class$org$apache$commons$logging$LogFactory;
    static Class class$org$apache$commons$logging$impl$LogFactoryImpl;
    static Class class$org$apache$commons$logging$Log;

    public LogFactoryImpl() {
        this.initDiagnostics();
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Instance created.");
        }
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Log getInstance(Class clazz) {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String string) {
        Log log = (Log)this.instances.get(string);
        if (log == null) {
            log = this.newInstance(string);
            this.instances.put(string, log);
        }
        return log;
    }

    public void release() {
        this.logDiagnostic("Releasing all known loggers");
        this.instances.clear();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (this.logConstructor != null) {
            this.logDiagnostic("setAttribute: call too late; configuration already performed.");
        }
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
        if (string.equals("use_tccl")) {
            this.useTCCL = object != null && Boolean.valueOf(object.toString()) != false;
        }
    }

    protected static ClassLoader getContextClassLoader() {
        return LogFactory.getContextClassLoader();
    }

    protected static boolean isDiagnosticsEnabled() {
        return LogFactory.isDiagnosticsEnabled();
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        return LogFactory.getClassLoader(clazz);
    }

    private void initDiagnostics() {
        Object object = this.getClass();
        object = LogFactoryImpl.getClassLoader(object);
        try {
            object = object == null ? "BOOTLOADER" : LogFactoryImpl.objectId(object);
        }
        catch (SecurityException securityException) {
            object = "UNKNOWN";
        }
        this.diagnosticPrefix = "[LogFactoryImpl@" + System.identityHashCode(this) + " from " + (String)object + "] ";
    }

    protected void logDiagnostic(String string) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            LogFactoryImpl.logRawDiagnostic(this.diagnosticPrefix + string);
        }
    }

    protected String getLogClassName() {
        if (this.logClassName == null) {
            LogFactoryImpl logFactoryImpl = this;
            logFactoryImpl.discoverLogImplementation(logFactoryImpl.getClass().getName());
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() {
        if (this.logConstructor == null) {
            LogFactoryImpl logFactoryImpl = this;
            logFactoryImpl.discoverLogImplementation(logFactoryImpl.getClass().getName());
        }
        return this.logConstructor;
    }

    protected boolean isJdk13LumberjackAvailable() {
        return this.isLogLibraryAvailable("Jdk13Lumberjack", LOGGING_IMPL_LUMBERJACK_LOGGER);
    }

    protected boolean isJdk14Available() {
        return this.isLogLibraryAvailable("Jdk14", LOGGING_IMPL_JDK14_LOGGER);
    }

    protected boolean isLog4JAvailable() {
        return this.isLogLibraryAvailable("Log4J", LOGGING_IMPL_LOG4J_LOGGER);
    }

    protected Log newInstance(String object) {
        try {
            Object[] objectArray;
            if (this.logConstructor == null) {
                object = this.discoverLogImplementation((String)object);
            } else {
                objectArray = new Object[]{object};
                object = (Log)this.logConstructor.newInstance(objectArray);
            }
            if (this.logMethod != null) {
                objectArray = new Object[]{this};
                this.logMethod.invoke(object, objectArray);
            }
            return object;
        }
        catch (LogConfigurationException logConfigurationException) {
            LogConfigurationException logConfigurationException2 = logConfigurationException;
            throw logConfigurationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            object = invocationTargetException.getTargetException();
            throw new LogConfigurationException((Throwable)(object == null ? invocationTargetException2 : object));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            LogFactoryImpl.handleThrowable(throwable);
            throw new LogConfigurationException(throwable2);
        }
    }

    private static ClassLoader getContextClassLoaderInternal() {
        return (ClassLoader)AccessController.doPrivileged(new LogFactoryImpl$1());
    }

    private static String getSystemProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new LogFactoryImpl$2(string, string2));
    }

    private ClassLoader getParentClassLoader(ClassLoader classLoader) {
        try {
            return (ClassLoader)AccessController.doPrivileged(new LogFactoryImpl$3(this, classLoader));
        }
        catch (SecurityException securityException) {
            this.logDiagnostic("[SECURITY] Unable to obtain parent classloader");
            return null;
        }
    }

    private boolean isLogLibraryAvailable(String string, String object) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Checking for '" + string + "'.");
        }
        try {
            object = this.createLogFromClass((String)object, this.getClass().getName(), false);
            if (object == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Did not find '" + string + "'.");
                }
                return false;
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Found '" + string + "'.");
            }
            return true;
        }
        catch (LogConfigurationException logConfigurationException) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Logging system '" + string + "' is available but not useable.");
            }
            return false;
        }
    }

    private String getConfigurationValue(String string) {
        block10: {
            Object object;
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] Trying to get configuration for item " + string);
            }
            if ((object = this.getAttribute(string)) != null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] Found LogFactory attribute [" + object + "] for " + string);
                }
                return object.toString();
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] No LogFactory attribute found for " + string);
            }
            try {
                object = LogFactoryImpl.getSystemProperty(string, null);
                if (object != null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("[ENV] Found system property [" + (String)object + "] for " + string);
                    }
                    return object;
                }
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] No system property found for property " + string);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactoryImpl.isDiagnosticsEnabled()) break block10;
                this.logDiagnostic("[ENV] Security prevented reading system property " + string);
            }
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("[ENV] No configuration defined for item " + string);
        }
        return null;
    }

    private boolean getBooleanConfiguration(String string, boolean bl) {
        if ((string = this.getConfigurationValue(string)) == null) {
            return bl;
        }
        return Boolean.valueOf(string);
    }

    private void initConfiguration() {
        this.allowFlawedContext = this.getBooleanConfiguration(ALLOW_FLAWED_CONTEXT_PROPERTY, true);
        this.allowFlawedDiscovery = this.getBooleanConfiguration(ALLOW_FLAWED_DISCOVERY_PROPERTY, true);
        this.allowFlawedHierarchy = this.getBooleanConfiguration(ALLOW_FLAWED_HIERARCHY_PROPERTY, true);
    }

    private Log discoverLogImplementation(String string) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Discovering a Log implementation...");
        }
        this.initConfiguration();
        Log log = null;
        String string2 = this.findUserSpecifiedLogClassName();
        if (string2 != null) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Attempting to load user-specified log class '" + string2 + "'...");
            }
            if ((log = this.createLogFromClass(string2, string, true)) == null) {
                StringBuffer stringBuffer = new StringBuffer("User-specified log class '");
                stringBuffer.append(string2);
                stringBuffer.append("' cannot be found or is not useable.");
                this.informUponSimilarName(stringBuffer, string2, LOGGING_IMPL_LOG4J_LOGGER);
                this.informUponSimilarName(stringBuffer, string2, LOGGING_IMPL_JDK14_LOGGER);
                this.informUponSimilarName(stringBuffer, string2, LOGGING_IMPL_LUMBERJACK_LOGGER);
                this.informUponSimilarName(stringBuffer, string2, LOGGING_IMPL_SIMPLE_LOGGER);
                throw new LogConfigurationException(stringBuffer.toString());
            }
            return log;
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("No user-specified Log implementation; performing discovery using the standard supported logging implementations...");
        }
        for (int i = 0; i < classesToDiscover.length && log == null; ++i) {
            log = this.createLogFromClass(classesToDiscover[i], string, true);
        }
        if (log == null) {
            throw new LogConfigurationException("No suitable Log implementation");
        }
        return log;
    }

    private void informUponSimilarName(StringBuffer stringBuffer, String string, String string2) {
        if (string.equals(string2)) {
            return;
        }
        if (string.regionMatches(true, 0, string2, 0, PKG_LEN + 5)) {
            stringBuffer.append(" Did you mean '");
            stringBuffer.append(string2);
            stringBuffer.append("'?");
        }
    }

    private String findUserSpecifiedLogClassName() {
        String string;
        block13: {
            block12: {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.Log'");
                }
                if ((string = (String)this.getAttribute(LOG_PROPERTY)) == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.log'");
                    }
                    string = (String)this.getAttribute(LOG_PROPERTY_OLD);
                }
                if (string == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.Log'");
                    }
                    try {
                        string = LogFactoryImpl.getSystemProperty(LOG_PROPERTY, null);
                    }
                    catch (SecurityException securityException) {
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) break block12;
                        this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.Log' - " + securityException.getMessage());
                    }
                }
            }
            if (string == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.log'");
                }
                try {
                    string = LogFactoryImpl.getSystemProperty(LOG_PROPERTY_OLD, null);
                }
                catch (SecurityException securityException) {
                    if (!LogFactoryImpl.isDiagnosticsEnabled()) break block13;
                    this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.log' - " + securityException.getMessage());
                }
            }
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private Log createLogFromClass(String string, String objectArray, boolean bl) {
        Object object;
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Attempting to instantiate '" + string + "'");
        }
        objectArray = new Object[]{objectArray};
        Log log = null;
        Constructor constructor = null;
        Class<?> clazz = null;
        ClassLoader classLoader = this.getBaseClassLoader();
        while (true) {
            Object object2;
            this.logDiagnostic("Trying to load '" + string + "' from classloader " + LogFactoryImpl.objectId(classLoader));
            try {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    object2 = string.replace('.', '/') + ".class";
                    object = classLoader != null ? classLoader.getResource((String)object2) : ClassLoader.getSystemResource((String)object2 + ".class");
                    if (object == null) {
                        this.logDiagnostic("Class '" + string + "' [" + (String)object2 + "] cannot be found.");
                    } else {
                        this.logDiagnostic("Class '" + string + "' was found at '" + object + "'");
                    }
                }
                try {
                    object = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object2 = classNotFoundException;
                    object = classNotFoundException.getMessage();
                    this.logDiagnostic("The log adapter '" + string + "' is not available via classloader " + LogFactoryImpl.objectId(classLoader) + ": " + ((String)object).trim());
                    try {
                        object = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        object = classNotFoundException2;
                        object = classNotFoundException2.getMessage();
                        this.logDiagnostic("The log adapter '" + string + "' is not available via the LogFactoryImpl class classloader: " + ((String)object).trim());
                        break;
                    }
                }
                constructor = ((Class)object).getConstructor(this.logConstructorSignature);
                object2 = constructor.newInstance(objectArray);
                if (object2 instanceof Log) {
                    clazz = object;
                    log = (Log)object2;
                    break;
                }
                this.handleFlawedHierarchy(classLoader, (Class)object);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                object = noClassDefFoundError;
                object2 = noClassDefFoundError.getMessage();
                this.logDiagnostic("The log adapter '" + string + "' is missing dependencies when loaded via classloader " + LogFactoryImpl.objectId(classLoader) + ": " + ((String)object2).trim());
                break;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                object = exceptionInInitializerError;
                object2 = exceptionInInitializerError.getMessage();
                this.logDiagnostic("The log adapter '" + string + "' is unable to initialize itself when loaded via classloader " + LogFactoryImpl.objectId(classLoader) + ": " + ((String)object2).trim());
                break;
            }
            catch (LogConfigurationException logConfigurationException) {
                object = logConfigurationException;
                throw logConfigurationException;
            }
            catch (Throwable throwable) {
                object = throwable;
                LogFactoryImpl.handleThrowable(throwable);
                this.handleFlawedDiscovery(string, classLoader, (Throwable)object);
            }
            if (classLoader == null) break;
            classLoader = this.getParentClassLoader(classLoader);
        }
        if (clazz != null && bl) {
            this.logClassName = string;
            this.logConstructor = constructor;
            try {
                this.logMethod = clazz.getMethod("setLogFactory", this.logMethodSignature);
                this.logDiagnostic("Found method setLogFactory(LogFactory) in '" + string + "'");
            }
            catch (Throwable throwable) {
                object = throwable;
                LogFactoryImpl.handleThrowable(throwable);
                this.logMethod = null;
                this.logDiagnostic("[INFO] '" + string + "' from classloader " + LogFactoryImpl.objectId(classLoader) + " does not declare optional method setLogFactory(LogFactory)");
            }
            this.logDiagnostic("Log adapter '" + string + "' from classloader " + LogFactoryImpl.objectId(clazz.getClassLoader()) + " has been selected for use.");
        }
        return log;
    }

    private ClassLoader getBaseClassLoader() {
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$impl$LogFactoryImpl == null ? (class$org$apache$commons$logging$impl$LogFactoryImpl = LogFactoryImpl.class$("org.apache.commons.logging.impl.LogFactoryImpl")) : class$org$apache$commons$logging$impl$LogFactoryImpl);
        if (!this.useTCCL) {
            return classLoader;
        }
        ClassLoader classLoader2 = LogFactoryImpl.getContextClassLoaderInternal();
        classLoader = this.getLowestClassLoader(classLoader2, classLoader);
        if (classLoader == null) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[WARNING] the context classloader is not part of a parent-child relationship with the classloader that loaded LogFactoryImpl.");
                }
                return classLoader2;
            }
            throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
        }
        if (classLoader != classLoader2) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Warning: the context classloader is an ancestor of the classloader that loaded LogFactoryImpl; it should be the same or a descendant. The application using commons-logging should ensure the context classloader is used correctly.");
                }
            } else {
                throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
            }
        }
        return classLoader;
    }

    private ClassLoader getLowestClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == null) {
            return classLoader2;
        }
        if (classLoader2 == null) {
            return classLoader;
        }
        ClassLoader classLoader3 = classLoader;
        while (classLoader3 != null) {
            if (classLoader3 == classLoader2) {
                return classLoader;
            }
            classLoader3 = this.getParentClassLoader(classLoader3);
        }
        classLoader3 = classLoader2;
        while (classLoader3 != null) {
            if (classLoader3 == classLoader) {
                return classLoader2;
            }
            classLoader3 = this.getParentClassLoader(classLoader3);
        }
        return null;
    }

    private void handleFlawedDiscovery(String object, ClassLoader object2, Throwable throwable) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Could not instantiate Log '" + (String)object + "' -- " + throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            if (throwable instanceof InvocationTargetException) {
                object = (InvocationTargetException)throwable;
                if ((object = ((InvocationTargetException)object).getTargetException()) != null) {
                    this.logDiagnostic("... InvocationTargetException: " + object.getClass().getName() + ": " + ((Throwable)object).getLocalizedMessage());
                    if (object instanceof ExceptionInInitializerError) {
                        object = (ExceptionInInitializerError)object;
                        if ((object = ((ExceptionInInitializerError)object).getException()) != null) {
                            object2 = new StringWriter();
                            ((Throwable)object).printStackTrace(new PrintWriter((Writer)object2, true));
                            this.logDiagnostic("... ExceptionInInitializerError: " + ((StringWriter)object2).toString());
                        }
                    }
                }
            }
        }
        if (!this.allowFlawedDiscovery) {
            throw new LogConfigurationException(throwable);
        }
    }

    private void handleFlawedHierarchy(ClassLoader classLoader, Class clazz) {
        boolean bl = false;
        String string = (class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!string.equals(classArray[i].getName())) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                try {
                    ClassLoader classLoader2 = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log);
                    this.logDiagnostic("Class '" + clazz.getName() + "' was found in classloader " + LogFactoryImpl.objectId(classLoader) + ". It is bound to a Log interface which is not the one loaded from classloader " + LogFactoryImpl.objectId(classLoader2));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    LogFactoryImpl.handleThrowable(throwable);
                    this.logDiagnostic("Error while trying to output diagnostics about bad class '" + clazz + "'");
                }
            }
            if (!this.allowFlawedHierarchy) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Terminating logging for this context ");
                stringBuffer.append("due to bad log hierarchy. ");
                stringBuffer.append("You have more than one version of '");
                stringBuffer.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName());
                stringBuffer.append("' visible.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(stringBuffer.toString());
                }
                throw new LogConfigurationException(stringBuffer.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Warning: bad log hierarchy. ");
                stringBuffer.append("You have more than one version of '");
                stringBuffer.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName());
                stringBuffer.append("' visible.");
                this.logDiagnostic(stringBuffer.toString());
                return;
            }
        } else {
            if (!this.allowFlawedDiscovery) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Terminating logging for this context. ");
                stringBuffer.append("Log class '");
                stringBuffer.append(clazz.getName());
                stringBuffer.append("' does not implement the Log interface.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(stringBuffer.toString());
                }
                throw new LogConfigurationException(stringBuffer.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[WARNING] Log class '");
                stringBuffer.append(clazz.getName());
                stringBuffer.append("' does not implement the Log interface.");
                this.logDiagnostic(stringBuffer.toString());
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ClassLoader access$000() {
        return LogFactoryImpl.directGetContextClassLoader();
    }
}

