/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Pointer;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$TransparentContentPane;
import com.sun.jna.platform.WindowUtils$W32WindowUtils;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$HBITMAP;
import com.sun.jna.platform.win32.WinDef$POINT;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFO;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinUser$BLENDFUNCTION;
import com.sun.jna.platform.win32.WinUser$SIZE;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import javax.swing.SwingUtilities;

class WindowUtils$W32WindowUtils$W32TransparentContentPane
extends WindowUtils$NativeWindowUtils$TransparentContentPane {
    private static final long serialVersionUID = 1L;
    private WinDef.HDC memDC;
    private WinDef$HBITMAP hBitmap;
    private Pointer pbits;
    private Dimension bitmapSize;
    final /* synthetic */ WindowUtils$W32WindowUtils this$0;

    public WindowUtils$W32WindowUtils$W32TransparentContentPane(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Container container) {
        this.this$0 = windowUtils$W32WindowUtils;
        super(windowUtils$W32WindowUtils, container);
    }

    private void disposeBackingStore() {
        GDI32 gDI32 = GDI32.INSTANCE;
        if (this.hBitmap != null) {
            gDI32.DeleteObject(this.hBitmap);
            this.hBitmap = null;
        }
        if (this.memDC != null) {
            gDI32.DeleteDC(this.memDC);
            this.memDC = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.disposeBackingStore();
    }

    @Override
    public void setTransparent(boolean bl) {
        super.setTransparent(bl);
        if (!bl) {
            this.disposeBackingStore();
        }
    }

    @Override
    protected void paintDirect(BufferedImage object, Rectangle rectangle) {
        Window window = SwingUtilities.getWindowAncestor(this);
        GDI32 gDI32 = GDI32.INSTANCE;
        User32 user32 = User32.INSTANCE;
        int n = rectangle.x;
        int n2 = rectangle.y;
        Point point = SwingUtilities.convertPoint(this, n, n2, window);
        n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = window.getWidth();
        int n5 = window.getHeight();
        WinDef.HDC hDC = user32.GetDC(null);
        WinNT$HANDLE winNT$HANDLE = null;
        try {
            Object object2;
            Object object3;
            if (this.memDC == null) {
                this.memDC = gDI32.CreateCompatibleDC(hDC);
            }
            if (this.hBitmap == null || !window.getSize().equals(this.bitmapSize)) {
                if (this.hBitmap != null) {
                    gDI32.DeleteObject(this.hBitmap);
                    this.hBitmap = null;
                }
                object3 = new WinGDI$BITMAPINFO();
                new WinGDI$BITMAPINFO().bmiHeader.biWidth = n4;
                ((WinGDI$BITMAPINFO)((Object)object3)).bmiHeader.biHeight = n5;
                ((WinGDI$BITMAPINFO)((Object)object3)).bmiHeader.biPlanes = 1;
                ((WinGDI$BITMAPINFO)((Object)object3)).bmiHeader.biBitCount = (short)32;
                ((WinGDI$BITMAPINFO)((Object)object3)).bmiHeader.biCompression = 0;
                ((WinGDI$BITMAPINFO)((Object)object3)).bmiHeader.biSizeImage = n4 * n5 << 2;
                object2 = new PointerByReference();
                this.hBitmap = gDI32.CreateDIBSection(this.memDC, (WinGDI$BITMAPINFO)((Object)object3), 0, (PointerByReference)object2, null, 0);
                this.pbits = object2.getValue();
                this.bitmapSize = new Dimension(n4, n5);
            }
            winNT$HANDLE = gDI32.SelectObject(this.memDC, this.hBitmap);
            object3 = ((BufferedImage)object).getData();
            object2 = new int[4];
            object = new int[n2];
            for (int i = 0; i < n3; ++i) {
                int n6;
                for (n6 = 0; n6 < n2; ++n6) {
                    ((Raster)object3).getPixel(n6, i, (int[])object2);
                    int n7 = (object2[3] & 0xFF) << 24;
                    int n8 = object2[2] & 0xFF;
                    int n9 = (object2[1] & 0xFF) << 8;
                    int n10 = (object2[0] & 0xFF) << 16;
                    object[n6] = n7 | n8 | n9 | n10;
                }
                n6 = n5 - (point.y + i) - 1;
                this.pbits.write((long)(n6 * n4 + point.x << 2), (int[])object, 0, n2);
            }
            WinUser$SIZE winUser$SIZE = new WinUser$SIZE();
            new WinUser$SIZE().cx = window.getWidth();
            winUser$SIZE.cy = window.getHeight();
            WinDef$POINT winDef$POINT = new WinDef$POINT();
            new WinDef$POINT().x = window.getX();
            winDef$POINT.y = window.getY();
            WinDef$POINT winDef$POINT2 = new WinDef$POINT();
            WinUser$BLENDFUNCTION winUser$BLENDFUNCTION = new WinUser$BLENDFUNCTION();
            WinDef.HWND hWND = WindowUtils$W32WindowUtils.access$400(this.this$0, window);
            ByteByReference byteByReference = new ByteByReference();
            object = new IntByReference();
            n3 = WindowUtils$W32WindowUtils.access$700(this.this$0, window);
            try {
                if (user32.GetLayeredWindowAttributes(hWND, null, byteByReference, (IntByReference)object) && (object.getValue() & 2) != 0) {
                    n3 = byteByReference.getValue();
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            winUser$BLENDFUNCTION.SourceConstantAlpha = (byte)n3;
            winUser$BLENDFUNCTION.AlphaFormat = 1;
            user32.UpdateLayeredWindow(hWND, hDC, winDef$POINT, winUser$SIZE, this.memDC, winDef$POINT2, 0, winUser$BLENDFUNCTION, 2);
            user32.ReleaseDC(null, hDC);
        }
        catch (Throwable throwable) {
            user32.ReleaseDC(null, hDC);
            if (this.memDC != null && winNT$HANDLE != null) {
                gDI32.SelectObject(this.memDC, winNT$HANDLE);
            }
            throw throwable;
        }
        if (this.memDC != null && winNT$HANDLE != null) {
            gDI32.SelectObject(this.memDC, winNT$HANDLE);
            return;
        }
    }
}

