/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD$SIZE_T;
import com.sun.jna.platform.win32.Guid$GUID;
import com.sun.jna.platform.win32.WinBase$FILETIME;
import com.sun.jna.platform.win32.WinBase$SYSTEMTIME;
import com.sun.jna.platform.win32.WinDef$BOOL;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$PSID;
import com.sun.jna.platform.win32.Winevt;
import com.sun.jna.platform.win32.Winevt$1;
import com.sun.jna.platform.win32.Winevt$EVT_VARIANT$field1_union;
import com.sun.jna.platform.win32.Winevt$EVT_VARIANT_TYPE;
import com.sun.jna.win32.W32APITypeMapper;

@Structure.FieldOrder(value={"field1", "Count", "Type"})
public class Winevt$EVT_VARIANT
extends Structure {
    public Winevt$EVT_VARIANT$field1_union field1;
    public int Count;
    public int Type;
    private Object holder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Winevt$EVT_VARIANT() {
        super(W32APITypeMapper.DEFAULT);
    }

    public Winevt$EVT_VARIANT(Pointer pointer) {
        super(pointer, 0, W32APITypeMapper.DEFAULT);
    }

    public void use(Pointer pointer) {
        this.useMemory(pointer, 0);
    }

    private int getBaseType() {
        return this.Type & 0x7F;
    }

    public boolean isArray() {
        return (this.Type & 0x80) == 128;
    }

    public Winevt$EVT_VARIANT_TYPE getVariantType() {
        return Winevt$EVT_VARIANT_TYPE.values()[this.getBaseType()];
    }

    public void setValue(Winevt$EVT_VARIANT_TYPE winevt$EVT_VARIANT_TYPE, Object object) {
        this.allocateMemory();
        if (winevt$EVT_VARIANT_TYPE == null) {
            throw new IllegalArgumentException("setValue must not be called with type set to NULL");
        }
        this.holder = null;
        if (object == null || winevt$EVT_VARIANT_TYPE == Winevt$EVT_VARIANT_TYPE.EvtVarTypeNull) {
            this.Type = Winevt$EVT_VARIANT_TYPE.EvtVarTypeNull.ordinal();
            this.Count = 0;
            this.field1.writeField("pointerValue", Pointer.NULL);
        } else {
            switch (winevt$EVT_VARIANT_TYPE) {
                case EvtVarTypeAnsiString: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new StringArray((String[])object, false);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = ((String[])object).length;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((String)object).length() + 1));
                        winevt$EVT_VARIANT_TYPE.setString(0L, (String)object);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from String/String[]");
                }
                case EvtVarTypeBoolean: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == WinDef$BOOL.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((WinDef$BOOL[])object).length << 2));
                        for (int i = 0; i < ((WinDef$BOOL[])object).length; ++i) {
                            winevt$EVT_VARIANT_TYPE.setInt(i << 2, ((WinDef$BOOL[])object)[i].intValue());
                        }
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == WinDef$BOOL.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("intValue", ((WinDef$BOOL)object).intValue());
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from BOOL/BOOL[]");
                }
                case EvtVarTypeString: 
                case EvtVarTypeEvtXml: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new StringArray((String[])object, true);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = ((String[])object).length;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((String)object).length() + 1 << 1));
                        winevt$EVT_VARIANT_TYPE.setWideString(0L, (String)object);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from String/String[]");
                }
                case EvtVarTypeSByte: 
                case EvtVarTypeByte: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)((byte[])object).length);
                        winevt$EVT_VARIANT_TYPE.write(0L, (byte[])object, 0, ((byte[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == Byte.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("byteValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from byte/byte[]");
                }
                case EvtVarTypeInt16: 
                case EvtVarTypeUInt16: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Short.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((short[])object).length << 1));
                        winevt$EVT_VARIANT_TYPE.write(0L, (short[])object, 0, ((short[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == Short.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("shortValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from short/short[]");
                }
                case EvtVarTypeHexInt32: 
                case EvtVarTypeInt32: 
                case EvtVarTypeUInt32: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Integer.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((int[])object).length << 2));
                        winevt$EVT_VARIANT_TYPE.write(0L, (int[])object, 0, ((int[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == Integer.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("intValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from int/int[]");
                }
                case EvtVarTypeHexInt64: 
                case EvtVarTypeInt64: 
                case EvtVarTypeUInt64: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Long.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((long[])object).length << 2));
                        winevt$EVT_VARIANT_TYPE.write(0L, (long[])object, 0, ((long[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == Long.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("longValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from long/long[]");
                }
                case EvtVarTypeSingle: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Float.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((float[])object).length << 2));
                        winevt$EVT_VARIANT_TYPE.write(0L, (float[])object, 0, ((float[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == Float.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("floatValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from float/float[]");
                }
                case EvtVarTypeDouble: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Double.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        winevt$EVT_VARIANT_TYPE = new Memory((long)(((double[])object).length << 2));
                        winevt$EVT_VARIANT_TYPE.write(0L, (double[])object, 0, ((double[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    if (object.getClass() == Double.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("doubleVal", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from double/double[]");
                }
                case EvtVarTypeBinary: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        winevt$EVT_VARIANT_TYPE = new Memory((long)((byte[])object).length);
                        winevt$EVT_VARIANT_TYPE.write(0L, (byte[])object, 0, ((byte[])object).length);
                        this.holder = winevt$EVT_VARIANT_TYPE;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", (Object)winevt$EVT_VARIANT_TYPE);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from byte[]");
                }
                default: {
                    throw new IllegalStateException(String.format("NOT IMPLEMENTED: getValue(%s) (Array: %b, Count: %d)", new Object[]{winevt$EVT_VARIANT_TYPE, this.isArray(), this.Count}));
                }
            }
        }
        this.write();
    }

    public Object getValue() {
        Pointer[] pointerArray = this.getVariantType();
        switch (Winevt$1.$SwitchMap$com$sun$jna$platform$win32$Winevt$EVT_VARIANT_TYPE[pointerArray.ordinal()]) {
            case 1: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getStringArray(0L, this.Count);
                }
                return this.field1.getPointer().getPointer(0L).getString(0L);
            }
            case 2: {
                if (this.isArray()) {
                    int[] nArray = this.field1.getPointer().getPointer(0L).getIntArray(0L, this.Count);
                    pointerArray = (Pointer[])nArray;
                    WinDef$BOOL[] winDef$BOOLArray = new WinDef$BOOL[nArray.length];
                    for (int i = 0; i < winDef$BOOLArray.length; ++i) {
                        winDef$BOOLArray[i] = new WinDef$BOOL((long)pointerArray[i]);
                    }
                    return winDef$BOOLArray;
                }
                return new WinDef$BOOL(this.field1.getPointer().getInt(0L));
            }
            case 3: 
            case 4: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getWideStringArray(0L, this.Count);
                }
                return this.field1.getPointer().getPointer(0L).getWideString(0L);
            }
            case 18: {
                if (this.isArray()) {
                    pointerArray = (WinBase$FILETIME)Structure.newInstance(WinBase$FILETIME.class, (Pointer)this.field1.getPointer().getPointer(0L));
                    pointerArray.read();
                    return pointerArray.toArray(this.Count);
                }
                pointerArray = new WinBase$FILETIME(this.field1.getPointer());
                pointerArray.read();
                return pointerArray;
            }
            case 20: {
                if (this.isArray()) {
                    pointerArray = (WinBase$SYSTEMTIME)Structure.newInstance(WinBase$SYSTEMTIME.class, (Pointer)this.field1.getPointer().getPointer(0L));
                    pointerArray.read();
                    return pointerArray.toArray(this.Count);
                }
                pointerArray = (WinBase$SYSTEMTIME)Structure.newInstance(WinBase$SYSTEMTIME.class, (Pointer)this.field1.getPointer().getPointer(0L));
                pointerArray.read();
                return pointerArray;
            }
            case 5: 
            case 6: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getByteArray(0L, this.Count);
                }
                return this.field1.getPointer().getByte(0L);
            }
            case 7: 
            case 8: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getShortArray(0L, this.Count);
                }
                return this.field1.getPointer().getShort(0L);
            }
            case 9: 
            case 10: 
            case 11: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getIntArray(0L, this.Count);
                }
                return this.field1.getPointer().getInt(0L);
            }
            case 12: 
            case 13: 
            case 14: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getLongArray(0L, this.Count);
                }
                return this.field1.getPointer().getLong(0L);
            }
            case 15: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getFloatArray(0L, this.Count);
                }
                return Float.valueOf(this.field1.getPointer().getFloat(0L));
            }
            case 16: {
                if (this.isArray()) {
                    return this.field1.getPointer().getPointer(0L).getDoubleArray(0L, this.Count);
                }
                return this.field1.getPointer().getDouble(0L);
            }
            case 17: {
                if (!$assertionsDisabled && this.isArray()) {
                    throw new AssertionError();
                }
                return this.field1.getPointer().getPointer(0L).getByteArray(0L, this.Count);
            }
            case 24: {
                return null;
            }
            case 21: {
                if (this.isArray()) {
                    pointerArray = (Guid$GUID)Structure.newInstance(Guid$GUID.class, (Pointer)this.field1.getPointer().getPointer(0L));
                    pointerArray.read();
                    return pointerArray.toArray(this.Count);
                }
                pointerArray = (Guid$GUID)Structure.newInstance(Guid$GUID.class, (Pointer)this.field1.getPointer().getPointer(0L));
                pointerArray.read();
                return pointerArray;
            }
            case 22: {
                if (this.isArray()) {
                    pointerArray = (WinNT$PSID)Structure.newInstance(WinNT$PSID.class, (Pointer)this.field1.getPointer().getPointer(0L));
                    pointerArray.read();
                    return pointerArray.toArray(this.Count);
                }
                pointerArray = (WinNT$PSID)Structure.newInstance(WinNT$PSID.class, (Pointer)this.field1.getPointer().getPointer(0L));
                pointerArray.read();
                return pointerArray;
            }
            case 23: {
                if (this.isArray()) {
                    long[] lArray = this.field1.getPointer().getPointer(0L).getLongArray(0L, this.Count);
                    pointerArray = (Pointer[])lArray;
                    BaseTSD$SIZE_T[] baseTSD$SIZE_TArray = new BaseTSD$SIZE_T[lArray.length];
                    for (int i = 0; i < baseTSD$SIZE_TArray.length; ++i) {
                        baseTSD$SIZE_TArray[i] = new BaseTSD$SIZE_T((long)pointerArray[i]);
                    }
                    return baseTSD$SIZE_TArray;
                }
                return new BaseTSD$SIZE_T(this.field1.getPointer().getLong(0L));
            }
            case 19: {
                if (this.isArray()) {
                    pointerArray = this.field1.getPointer().getPointer(0L).getPointerArray(0L, this.Count);
                    WinNT$HANDLE[] winNT$HANDLEArray = new WinNT$HANDLE[pointerArray.length];
                    for (int i = 0; i < winNT$HANDLEArray.length; ++i) {
                        winNT$HANDLEArray[i] = new WinNT$HANDLE(pointerArray[i]);
                    }
                    return winNT$HANDLEArray;
                }
                return new WinNT$HANDLE(this.field1.getPointer().getPointer(0L));
            }
        }
        throw new IllegalStateException(String.format("NOT IMPLEMENTED: getValue(%s) (Array: %b, Count: %d)", pointerArray, this.isArray(), this.Count));
    }

    static {
        $assertionsDisabled = !Winevt.class.desiredAssertionStatus();
    }
}

