# Handling conflicting offline edits

## Description:

If the same piece of data was edited by two users offline simultaneously, the edit that was performed most recently will take effect.

## Step-by-Step Procedure:

### 1. Admin: Course and Members Setup

1. Login as admin. 
2. Click on "Courses."
3. Click on the "+ Course" button. 
4. Click on the "Add a new course" button. 
5. Enter a course name. 
6. Click on the "Description" field. 
7. New text block appears. 
8. Enter the description. 
9. Click on the "Done" button. 
10. Click "Save" to save the course. 
11. Click on "Courses."
12. Click on the course name. 
13. Click on the "Members" tab. 
14. Click on the "Add a teacher" button. 
15. Click on "Add a new person" button. 
16. Enter the teacher's first name, last name, and gender. 
17. Click on the "Save" button to save the person details. 
18. Click on the "Save" button to save the enrollment details. 
19. Click on the teacher's name. 
20. Click on the "View profile" button. 
21. Click on the "Create account" button. 
22. Enter the username. 
23. Enter the password. 
24. Click on the "Save" button. 
25. Click on "Courses."
26. Click on the course name. 
27. Click on the "Members" tab. 
28. Click on the "Add a student" button. 
29. Click on "Add a new person" button. 
30. Enter the student's first name, last name, and gender. 
31. Click on the "Save" button to save the person details. 
32. Click on the "Save" button to save the enrollment details. 
33. Click on the student name. 
34. Click on the "View profile" button. 
35. Click on the "Create account" button. 
36. Enter the username. 
37. Enter the password. 
38. Click on the "Save" button. 

### 2. Teacher: Initial Data Sync

1. Clear the app storage. 
2. Login to the app using the teacher's username and password. 
3. Verify the teacher is able to see the course. 
4. Click on "Members."
5. Verify the teacher is able to see all members in the course. 
6. Close the app. 

### 3. Teacher: Offline Edit

1. Switch off the Wi-Fi/data on the device. 
2. Open the app. 
3. Open the course page. 
4. Click on the "Edit" button. 
5. Click on the "Description" field. 
6. Click on the "Text editor."
7. Add the text "Test 1" in the description. 
8. Save the course. 
9. Close the app. 

### 4. Admin: Offline Edit

1. Login to the app using the admin's username and password on a different device. 
2. Click on "Courses."
3. Click on the course name. 
4. Verify the admin can see the member list by clicking on the "Members" tab. 
5. Close the app. 
6. Switch off the Wi-Fi/data on the device. 
7. Open the app. 
8. Open the course page. 
9. Click on the "Edit" button. 
10. Click on the "Description" field. 
11. Click on the "Text editor."
12. Add the text "Test 2" in the description. 
13. Save the course. 
14. Close the app.

### 5. Data Sync and Conflict Resolution

1. On Device 1 (Teacher's device), switch on the Wi-Fi/data. 
2. On Device 2 (Admin's device), switch on the Wi-Fi/data. 
3. Verify that the course description on both devices is updated to "Test 2."

### 6. Final Verification

1. Confirm that the most recent edit (from the admin) takes effect and overrides the teacher's earlier edit.
2. Ensure that no error messages related to conflicting data are displayed.