/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePing;
import com.ustadmobile.libcache.distributed.model.DistributedCachePong;
import com.ustadmobile.libcache.distributed.model.DistributedHashEntries;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "", "()V", "httpPort", "", "getHttpPort", "()I", "toBytes", "", "Companion", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "lib-cache_release"})
public abstract class DistributedCachePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DCACHE_PACKET_OVERHEAD = 5;
    public static final byte WHAT_ENTRIES = 1;
    public static final byte WHAT_PING = 2;
    public static final byte WHAT_PONG = 3;

    private DistributedCachePacket() {
    }

    public abstract int getHttpPort();

    @NotNull
    public abstract byte[] toBytes();

    public /* synthetic */ DistributedCachePacket(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket$Companion;", "", "()V", "DCACHE_PACKET_OVERHEAD", "", "WHAT_ENTRIES", "", "WHAT_PING", "WHAT_PONG", "fromBytes", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "bytesArray", "", "offset", "len", "lib-cache_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedCachePacket fromBytes(@NotNull byte[] bytesArray, int offset, int len) {
            DistributedCachePacket distributedCachePacket;
            Intrinsics.checkNotNullParameter((Object)bytesArray, (String)"bytesArray");
            ByteBuffer buffer = ByteBuffer.wrap(bytesArray, offset, len);
            byte what = buffer.get();
            int httpPort = buffer.getInt();
            byte by = what;
            if (by == 1) {
                Intrinsics.checkNotNull((Object)buffer);
                distributedCachePacket = DistributedHashEntries.Companion.readDistributedHashEntries(buffer, httpPort);
            } else if (by == 2) {
                Intrinsics.checkNotNull((Object)buffer);
                distributedCachePacket = DistributedCachePing.Companion.readDistributedCachePing(buffer, httpPort);
            } else if (by == 3) {
                Intrinsics.checkNotNull((Object)buffer);
                distributedCachePacket = DistributedCachePong.Companion.readDistributedCachePong(buffer, httpPort);
            } else {
                throw new IllegalArgumentException("DistributedCachePacket.fromBytes: WHAT byte not recognized");
            }
            return distributedCachePacket;
        }

        public static /* synthetic */ DistributedCachePacket fromBytes$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.fromBytes(byArray, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

