/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H'J\u0014\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007H'J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H'J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H'J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H'J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000bH'J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH'J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H'J\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheDao;", "", "()V", "allNeighbors", "", "Lcom/ustadmobile/libcache/db/entities/NeighborCache;", "allNeighborsAsFlow", "Lkotlinx/coroutines/flow/Flow;", "deleteAsync", "", "neighborUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertOrIgnore", "neighborCache", "updateDeviceName", "deviceName", "", "updateHttpPort", "httpPort", "", "updatePingTime", "pingTime", "timeNow", "updateStatuses", "lostThreshold", "upsert", "upsertAsync", "(Lcom/ustadmobile/libcache/db/entities/NeighborCache;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-cache_release"})
@Dao
public abstract class NeighborCacheDao {
    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertAsync(@NotNull NeighborCache var1, @NotNull Continuation<? super Unit> var2);

    @Insert(entity=Object.class, onConflict=1)
    public abstract void upsert(@NotNull NeighborCache var1);

    @Insert(entity=Object.class, onConflict=5)
    public abstract void insertOrIgnore(@NotNull NeighborCache var1);

    @Query(value="\n        DELETE FROM NeighborCache\n         WHERE neighborUid = :neighborUid\n    ")
    @Nullable
    public abstract Object deleteAsync(long var1, @NotNull Continuation<? super Unit> var3);

    @Query(value="\n        SELECT NeighborCache.*\n          FROM NeighborCache\n         WHERE NeighborCache.neighborStatus = 1 \n    ")
    @NotNull
    public abstract Flow<List<NeighborCache>> allNeighborsAsFlow();

    @Query(value="\n        SELECT NeighborCache.*\n          FROM NeighborCache\n    ")
    @NotNull
    public abstract List<NeighborCache> allNeighbors();

    @Query(value="\n        UPDATE NeighborCache\n           SET neighborHttpPort = :httpPort\n         WHERE neighborUid = :neighborUid\n           AND neighborHttpPort != :httpPort\n    ")
    public abstract void updateHttpPort(long var1, int var3);

    @Query(value="\n        UPDATE NeighborCache\n           SET neighborPingTime = :pingTime,\n               neighborLastSeen = :timeNow\n         WHERE neighborUid = :neighborUid  \n    ")
    public abstract int updatePingTime(long var1, int var3, long var4);

    @Query(value="\n        UPDATE NeighborCache\n           SET neighborStatus = CAST(((:timeNow - NeighborCache.neighborLastSeen) < :lostThreshold) AS INTEGER)\n         WHERE neighborStatus != CAST(((:timeNow - NeighborCache.neighborLastSeen) < :lostThreshold) AS INTEGER)   \n    ")
    public abstract void updateStatuses(long var1, long var3);

    @Query(value="\n        UPDATE NeighborCache\n           SET neighborDeviceName = :deviceName\n        WHERE neighborUid = :neighborUid\n          AND neighborDeviceName != :deviceName   \n    ")
    public abstract void updateDeviceName(long var1, @NotNull String var3);
}

