/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.response;

import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.headers.MergedHeaders;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.libcache.CompressionType;
import com.ustadmobile.libcache.io.ByteArraySourceKt;
import com.ustadmobile.libcache.io.SourceExtKt;
import com.ustadmobile.libcache.partial.ContentRange;
import com.ustadmobile.libcache.partial.RangeRequestNotSatisfiableException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/ustadmobile/libcache/response/CacheResponse;", "Lcom/ustadmobile/ihttp/response/IHttpResponse;", "fileSystem", "Lkotlinx/io/files/FileSystem;", "request", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "headers", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "storageUri", "", "uncompressedSize", "", "httpResponseCode", "", "(Lkotlinx/io/files/FileSystem;Lcom/ustadmobile/ihttp/request/IHttpRequest;Lcom/ustadmobile/ihttp/headers/IHttpHeaders;Ljava/lang/String;JI)V", "bodyUncompressType", "Lcom/ustadmobile/libcache/CompressionType;", "errorBody", "", "getHeaders", "()Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "rangeResponse", "Lcom/ustadmobile/libcache/partial/ContentRange;", "getRequest", "()Lcom/ustadmobile/ihttp/request/IHttpRequest;", "responseCode", "getResponseCode", "()I", "bodyAsSource", "Lkotlinx/io/Source;", "lib-cache_release"})
public final class CacheResponse
implements IHttpResponse {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final IHttpRequest request;
    @NotNull
    private final String storageUri;
    private volatile int httpResponseCode;
    @Nullable
    private final ContentRange rangeResponse;
    @NotNull
    private final IHttpHeaders headers;
    @Nullable
    private final byte[] errorBody;
    @NotNull
    private final CompressionType bodyUncompressType;

    public CacheResponse(@NotNull FileSystem fileSystem, @NotNull IHttpRequest request, @NotNull IHttpHeaders headers2, @NotNull String storageUri, long uncompressedSize, int httpResponseCode) {
        Object errorBody;
        ContentRange rangeResponse;
        Map overrideHeadersMap;
        block8: {
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)storageUri, (String)"storageUri");
            this.fileSystem = fileSystem;
            this.request = request;
            this.storageUri = storageUri;
            this.httpResponseCode = httpResponseCode;
            String rangeRequestHeader = this.getRequest().getHeaders().get("range");
            String ifRangeRequestHeader = this.getRequest().getHeaders().get("if-range");
            overrideHeadersMap = new LinkedHashMap();
            rangeResponse = null;
            errorBody = null;
            List<CompressionType> acceptEncoding = CompressionType.Companion.parseAcceptEncodingHeader(this.getRequest().getHeaders().get("accept-encoding"));
            CompressionType storageContentEncoding = CompressionType.Companion.byHeaderVal(headers2.get("content-encoding"));
            if (!acceptEncoding.contains((Object)storageContentEncoding)) {
                overrideHeadersMap.put("content-encoding", CollectionsKt.listOf((Object)"identity"));
                overrideHeadersMap.put("content-length", CollectionsKt.listOf((Object)String.valueOf(uncompressedSize)));
                v0 = storageContentEncoding;
            } else {
                v0 = this.bodyUncompressType = CompressionType.NONE;
            }
            if (rangeRequestHeader == null || ifRangeRequestHeader != null && !Intrinsics.areEqual((Object)ifRangeRequestHeader, (Object)headers2.get("etag"))) break block8;
            Object object = (List)overrideHeadersMap.get("content-length");
            if ((object == null || (object = (String)CollectionsKt.firstOrNull((List)object)) == null) && (object = headers2.get("content-length")) == null) {
                throw new IllegalStateException("CacheResponse headers missing content-length");
            }
            Object effectiveContentLength = object;
            long totalSize = Long.parseLong((String)effectiveContentLength);
            try {
                ContentRange contentRange;
                ContentRange it = contentRange = ContentRange.Companion.parseRangeHeader(rangeRequestHeader, totalSize);
                boolean bl = false;
                rangeResponse = it;
                this.httpResponseCode = 206;
                overrideHeadersMap.put("content-length", CollectionsKt.listOf((Object)String.valueOf(it.getContentLength())));
                overrideHeadersMap.put("Content-Range", CollectionsKt.listOf((Object)it.getContentRangeResponseHeader()));
            }
            catch (RangeRequestNotSatisfiableException e) {
                Object object2;
                block10: {
                    block9: {
                        this.httpResponseCode = 416;
                        object2 = e.getMessage();
                        if (object2 == null) break block9;
                        String string = object2;
                        byte[] byArray = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        object2 = byArray;
                        if (byArray != null) break block10;
                    }
                    object2 = new byte[0];
                }
                errorBody = object2;
                overrideHeadersMap.put("content-length", CollectionsKt.listOf((Object)String.valueOf(((Object)errorBody).length)));
            }
        }
        this.rangeResponse = rangeResponse;
        IHttpHeaders[] iHttpHeadersArray = new IHttpHeaders[]{IHttpHeaders.Companion.fromMap(MapsKt.toMap((Map)overrideHeadersMap)), headers2};
        this.headers = (IHttpHeaders)new MergedHeaders(iHttpHeadersArray);
        this.errorBody = errorBody;
    }

    public /* synthetic */ CacheResponse(FileSystem fileSystem, IHttpRequest iHttpRequest, IHttpHeaders iHttpHeaders, String string, long l, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            n = 200;
        }
        this(fileSystem, iHttpRequest, iHttpHeaders, string, l, n);
    }

    @NotNull
    public IHttpRequest getRequest() {
        return this.request;
    }

    public int getResponseCode() {
        return this.httpResponseCode;
    }

    @NotNull
    public IHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Source bodyAsSource() {
        Object object;
        if (this.getRequest().getMethod() == IHttpRequest.Companion.Method.HEAD) {
            object = CoreKt.buffered((RawSource)ByteArraySourceKt.asKotlinxIoSource(new byte[0]));
        } else if (this.errorBody != null) {
            object = CoreKt.buffered((RawSource)ByteArraySourceKt.asKotlinxIoSource(this.errorBody));
        } else {
            void var1_1;
            Source source = SourceExtKt.uncompress(CoreKt.buffered((RawSource)this.fileSystem.source(PathsJvmKt.Path((String)this.storageUri))), this.bodyUncompressType);
            object = this.rangeResponse != null ? CoreKt.buffered((RawSource)SourceExtKt.range(source, this.rangeResponse.getFromByte(), this.rangeResponse.getToByte())) : var1_1;
        }
        return object;
    }
}

