/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db;

import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.ustadmobile.door.DoorDatabaseWrapper;
import com.ustadmobile.door.log.DoorLogger;
import com.ustadmobile.door.message.DoorMessageCallback;
import com.ustadmobile.door.nodeevent.NodeEventManagerAndroid;
import com.ustadmobile.door.nodeevent.NodeEventManagerCommon;
import com.ustadmobile.door.util.DummyInvalidationTrackerKt;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.db.dao.CacheEntryDao;
import com.ustadmobile.libcache.db.dao.NeighborCacheDao;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao;
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao;
import com.ustadmobile.libcache.db.dao.RequestedEntryDao;
import com.ustadmobile.libcache.db.dao.RetentionLockDao;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u00020\u0014H\u0014J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0014J%\u0010?\u001a\u0002H@\"\b\b\u0000\u0010@*\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H@0CH\u0016\u00a2\u0006\u0002\u0010DJ\u0014\u0010E\u001a\u0002082\n\u0010F\u001a\u00060Gj\u0002`HH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\u00060+j\u0002`,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006I"}, d2={"Lcom/ustadmobile/libcache/db/UstadCacheDb_DoorWrapper;", "Lcom/ustadmobile/libcache/db/UstadCacheDb;", "Lcom/ustadmobile/door/DoorDatabaseWrapper;", "_db", "nodeId", "", "messageCallback", "Lcom/ustadmobile/door/message/DoorMessageCallback;", "logger", "Lcom/ustadmobile/door/log/DoorLogger;", "dbName", "", "(Lcom/ustadmobile/libcache/db/UstadCacheDb;JLcom/ustadmobile/door/message/DoorMessageCallback;Lcom/ustadmobile/door/log/DoorLogger;Ljava/lang/String;)V", "cacheEntryDao", "Lcom/ustadmobile/libcache/db/dao/CacheEntryDao;", "getCacheEntryDao", "()Lcom/ustadmobile/libcache/db/dao/CacheEntryDao;", "getDbName", "()Ljava/lang/String;", "invalidationTracker", "Landroidx/room/InvalidationTracker;", "Lcom/ustadmobile/door/room/InvalidationTracker;", "getInvalidationTracker", "()Landroidx/room/InvalidationTracker;", "neighborCacheDao", "Lcom/ustadmobile/libcache/db/dao/NeighborCacheDao;", "getNeighborCacheDao", "()Lcom/ustadmobile/libcache/db/dao/NeighborCacheDao;", "neighborCacheEntryDao", "Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao;", "getNeighborCacheEntryDao", "()Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao;", "newCacheEntryDao", "Lcom/ustadmobile/libcache/db/dao/NewCacheEntryDao;", "getNewCacheEntryDao", "()Lcom/ustadmobile/libcache/db/dao/NewCacheEntryDao;", "nodeEventManager", "Lcom/ustadmobile/door/nodeevent/NodeEventManagerCommon;", "getNodeEventManager", "()Lcom/ustadmobile/door/nodeevent/NodeEventManagerCommon;", "getNodeId", "()J", "realDatabase", "Landroidx/room/RoomDatabase;", "Lcom/ustadmobile/door/room/RoomDatabase;", "getRealDatabase", "()Landroidx/room/RoomDatabase;", "requestedEntryDao", "Lcom/ustadmobile/libcache/db/dao/RequestedEntryDao;", "getRequestedEntryDao", "()Lcom/ustadmobile/libcache/db/dao/RequestedEntryDao;", "retentionLockDao", "Lcom/ustadmobile/libcache/db/dao/RetentionLockDao;", "getRetentionLockDao", "()Lcom/ustadmobile/libcache/db/dao/RetentionLockDao;", "clearAllTables", "", "close", "createInvalidationTracker", "createOpenHelper", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "config", "Landroidx/room/DatabaseConfiguration;", "getDaoByClass", "T", "", "daoClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "runInTransaction", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "lib-cache_release"})
public final class UstadCacheDb_DoorWrapper
extends UstadCacheDb
implements DoorDatabaseWrapper<UstadCacheDb> {
    @NotNull
    private final UstadCacheDb _db;
    private final long nodeId;
    @NotNull
    private final DoorMessageCallback<UstadCacheDb> messageCallback;
    @NotNull
    private final NodeEventManagerCommon<UstadCacheDb> nodeEventManager;

    public UstadCacheDb_DoorWrapper(@NotNull UstadCacheDb _db, long nodeId, @NotNull DoorMessageCallback<UstadCacheDb> messageCallback, @NotNull DoorLogger logger, @NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)((Object)_db), (String)"_db");
        Intrinsics.checkNotNullParameter(messageCallback, (String)"messageCallback");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        this._db = _db;
        this.nodeId = nodeId;
        this.messageCallback = messageCallback;
        this.nodeEventManager = (NodeEventManagerCommon)new NodeEventManagerAndroid((RoomDatabase)this._db, this.messageCallback, logger, dbName, null, 16, null);
    }

    public long getNodeId() {
        return this.nodeId;
    }

    @NotNull
    public String getDbName() {
        return "DoorWrapper for [" + this._db + "]";
    }

    @Override
    @NotNull
    public CacheEntryDao getCacheEntryDao() {
        return this._db.getCacheEntryDao();
    }

    @Override
    @NotNull
    public RequestedEntryDao getRequestedEntryDao() {
        return this._db.getRequestedEntryDao();
    }

    @Override
    @NotNull
    public RetentionLockDao getRetentionLockDao() {
        return this._db.getRetentionLockDao();
    }

    @Override
    @NotNull
    public NeighborCacheDao getNeighborCacheDao() {
        return this._db.getNeighborCacheDao();
    }

    @Override
    @NotNull
    public NeighborCacheEntryDao getNeighborCacheEntryDao() {
        return this._db.getNeighborCacheEntryDao();
    }

    @Override
    @NotNull
    public NewCacheEntryDao getNewCacheEntryDao() {
        return this._db.getNewCacheEntryDao();
    }

    @NotNull
    public RoomDatabase getRealDatabase() {
        return this._db;
    }

    @NotNull
    public NodeEventManagerCommon<UstadCacheDb> getNodeEventManager() {
        return this.nodeEventManager;
    }

    @NotNull
    public InvalidationTracker getInvalidationTracker() {
        return this._db.getInvalidationTracker();
    }

    public void clearAllTables() {
        this._db.clearAllTables();
    }

    public void runInTransaction(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this._db.runInTransaction(runnable);
    }

    @NotNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NotNull DatabaseConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw new IllegalAccessException("Cannot use open helper on repository");
    }

    @NotNull
    protected InvalidationTracker createInvalidationTracker() {
        return DummyInvalidationTrackerKt.makeDummyInvalidationHandler((RoomDatabase)this);
    }

    @NotNull
    public <T> T getDaoByClass(@NotNull KClass<T> daoClass) {
        Object object;
        Intrinsics.checkNotNullParameter(daoClass, (String)"daoClass");
        KClass<T> kClass = daoClass;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(CacheEntryDao.class))) {
            CacheEntryDao cacheEntryDao = this.getCacheEntryDao();
            Intrinsics.checkNotNull((Object)cacheEntryDao, (String)"null cannot be cast to non-null type T of com.ustadmobile.libcache.db.UstadCacheDb_DoorWrapper.getDaoByClass");
            object = cacheEntryDao;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(RequestedEntryDao.class))) {
            RequestedEntryDao requestedEntryDao = this.getRequestedEntryDao();
            Intrinsics.checkNotNull((Object)requestedEntryDao, (String)"null cannot be cast to non-null type T of com.ustadmobile.libcache.db.UstadCacheDb_DoorWrapper.getDaoByClass");
            object = requestedEntryDao;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(RetentionLockDao.class))) {
            RetentionLockDao retentionLockDao = this.getRetentionLockDao();
            Intrinsics.checkNotNull((Object)retentionLockDao, (String)"null cannot be cast to non-null type T of com.ustadmobile.libcache.db.UstadCacheDb_DoorWrapper.getDaoByClass");
            object = retentionLockDao;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(NeighborCacheDao.class))) {
            NeighborCacheDao neighborCacheDao = this.getNeighborCacheDao();
            Intrinsics.checkNotNull((Object)neighborCacheDao, (String)"null cannot be cast to non-null type T of com.ustadmobile.libcache.db.UstadCacheDb_DoorWrapper.getDaoByClass");
            object = neighborCacheDao;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(NeighborCacheEntryDao.class))) {
            NeighborCacheEntryDao neighborCacheEntryDao = this.getNeighborCacheEntryDao();
            Intrinsics.checkNotNull((Object)neighborCacheEntryDao, (String)"null cannot be cast to non-null type T of com.ustadmobile.libcache.db.UstadCacheDb_DoorWrapper.getDaoByClass");
            object = neighborCacheEntryDao;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(NewCacheEntryDao.class))) {
            NewCacheEntryDao newCacheEntryDao = this.getNewCacheEntryDao();
            Intrinsics.checkNotNull((Object)newCacheEntryDao, (String)"null cannot be cast to non-null type T of com.ustadmobile.libcache.db.UstadCacheDb_DoorWrapper.getDaoByClass");
            object = newCacheEntryDao;
        } else {
            throw new IllegalArgumentException("No such DAO on this DB");
        }
        return (T)object;
    }

    public void close() {
        this._db.close();
    }
}

