/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.db.dao.CacheEntryDao;
import com.ustadmobile.libcache.db.dao.CacheEntryDao_Impl;
import com.ustadmobile.libcache.db.dao.NeighborCacheDao;
import com.ustadmobile.libcache.db.dao.NeighborCacheDao_Impl;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao_Impl;
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao;
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao_Impl;
import com.ustadmobile.libcache.db.dao.RequestedEntryDao;
import com.ustadmobile.libcache.db.dao.RequestedEntryDao_Impl;
import com.ustadmobile.libcache.db.dao.RetentionLockDao;
import com.ustadmobile.libcache.db.dao.RetentionLockDao_Impl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class UstadCacheDb_Impl
extends UstadCacheDb {
    private volatile CacheEntryDao _cacheEntryDao;
    private volatile RequestedEntryDao _requestedEntryDao;
    private volatile RetentionLockDao _retentionLockDao;
    private volatile NeighborCacheDao _neighborCacheDao;
    private volatile NeighborCacheEntryDao _neighborCacheEntryDao;
    private volatile NewCacheEntryDao _newCacheEntryDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(15){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `CacheEntry` (`key` TEXT NOT NULL, `url` TEXT NOT NULL, `message` TEXT NOT NULL, `statusCode` INTEGER NOT NULL, `cacheFlags` INTEGER NOT NULL, `method` INTEGER NOT NULL, `lastAccessed` INTEGER NOT NULL, `lastValidated` INTEGER NOT NULL, `integrity` TEXT, `responseHeaders` TEXT NOT NULL, `storageUri` TEXT NOT NULL, `storageSize` INTEGER NOT NULL, `uncompressedSize` INTEGER NOT NULL DEFAULT 0, PRIMARY KEY(`key`))");
                db.execSQL("CREATE INDEX IF NOT EXISTS `idx_lastAccessed` ON `CacheEntry` (`lastAccessed`)");
                db.execSQL("CREATE INDEX IF NOT EXISTS `index_CacheEntry_integrity` ON `CacheEntry` (`integrity`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS `RequestedEntry` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `requestSha256` TEXT NOT NULL, `requestedKey` TEXT NOT NULL, `batchId` INTEGER NOT NULL)");
                db.execSQL("CREATE INDEX IF NOT EXISTS `index_RequestedEntry_batchId` ON `RequestedEntry` (`batchId`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS `RetentionLock` (`lockId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `lockKey` TEXT NOT NULL, `lockRemark` TEXT NOT NULL)");
                db.execSQL("CREATE INDEX IF NOT EXISTS `idx_lockKey` ON `RetentionLock` (`lockKey`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS `NeighborCache` (`neighborUid` INTEGER NOT NULL, `neighborDeviceName` TEXT NOT NULL, `neighborIp` TEXT NOT NULL, `neighborUdpPort` INTEGER NOT NULL, `neighborHttpPort` INTEGER NOT NULL, `neighborDiscovered` INTEGER NOT NULL, `neighborPingTime` INTEGER NOT NULL, `neighborLastSeen` INTEGER NOT NULL, `neighborStatus` INTEGER NOT NULL, PRIMARY KEY(`neighborUid`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `NeighborCacheEntry` (`nceNeighborUid` INTEGER NOT NULL, `nceUrlHash` INTEGER NOT NULL, PRIMARY KEY(`nceNeighborUid`, `nceUrlHash`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `NewCacheEntry` (`cacheEntryKey` TEXT NOT NULL, `nceUrl` TEXT NOT NULL, PRIMARY KEY(`cacheEntryKey`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '91e0b1ee86ebf503079a196ed9753894')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `CacheEntry`");
                db.execSQL("DROP TABLE IF EXISTS `RequestedEntry`");
                db.execSQL("DROP TABLE IF EXISTS `RetentionLock`");
                db.execSQL("DROP TABLE IF EXISTS `NeighborCache`");
                db.execSQL("DROP TABLE IF EXISTS `NeighborCacheEntry`");
                db.execSQL("DROP TABLE IF EXISTS `NewCacheEntry`");
                List _callbacks = UstadCacheDb_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = UstadCacheDb_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                UstadCacheDb_Impl.this.mDatabase = db;
                UstadCacheDb_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = UstadCacheDb_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsCacheEntry = new HashMap<String, TableInfo.Column>(13);
                _columnsCacheEntry.put("key", new TableInfo.Column("key", "TEXT", true, 1, null, 1));
                _columnsCacheEntry.put("url", new TableInfo.Column("url", "TEXT", true, 0, null, 1));
                _columnsCacheEntry.put("message", new TableInfo.Column("message", "TEXT", true, 0, null, 1));
                _columnsCacheEntry.put("statusCode", new TableInfo.Column("statusCode", "INTEGER", true, 0, null, 1));
                _columnsCacheEntry.put("cacheFlags", new TableInfo.Column("cacheFlags", "INTEGER", true, 0, null, 1));
                _columnsCacheEntry.put("method", new TableInfo.Column("method", "INTEGER", true, 0, null, 1));
                _columnsCacheEntry.put("lastAccessed", new TableInfo.Column("lastAccessed", "INTEGER", true, 0, null, 1));
                _columnsCacheEntry.put("lastValidated", new TableInfo.Column("lastValidated", "INTEGER", true, 0, null, 1));
                _columnsCacheEntry.put("integrity", new TableInfo.Column("integrity", "TEXT", false, 0, null, 1));
                _columnsCacheEntry.put("responseHeaders", new TableInfo.Column("responseHeaders", "TEXT", true, 0, null, 1));
                _columnsCacheEntry.put("storageUri", new TableInfo.Column("storageUri", "TEXT", true, 0, null, 1));
                _columnsCacheEntry.put("storageSize", new TableInfo.Column("storageSize", "INTEGER", true, 0, null, 1));
                _columnsCacheEntry.put("uncompressedSize", new TableInfo.Column("uncompressedSize", "INTEGER", true, 0, "0", 1));
                HashSet _foreignKeysCacheEntry = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCacheEntry = new HashSet<TableInfo.Index>(2);
                _indicesCacheEntry.add(new TableInfo.Index("idx_lastAccessed", false, Arrays.asList("lastAccessed"), Arrays.asList("ASC")));
                _indicesCacheEntry.add(new TableInfo.Index("index_CacheEntry_integrity", false, Arrays.asList("integrity"), Arrays.asList("ASC")));
                TableInfo _infoCacheEntry = new TableInfo("CacheEntry", _columnsCacheEntry, _foreignKeysCacheEntry, _indicesCacheEntry);
                TableInfo _existingCacheEntry = TableInfo.read((SupportSQLiteDatabase)db, (String)"CacheEntry");
                if (!_infoCacheEntry.equals((Object)_existingCacheEntry)) {
                    return new RoomOpenHelper.ValidationResult(false, "CacheEntry(com.ustadmobile.libcache.db.entities.CacheEntry).\n Expected:\n" + _infoCacheEntry + "\n Found:\n" + _existingCacheEntry);
                }
                HashMap<String, TableInfo.Column> _columnsRequestedEntry = new HashMap<String, TableInfo.Column>(4);
                _columnsRequestedEntry.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsRequestedEntry.put("requestSha256", new TableInfo.Column("requestSha256", "TEXT", true, 0, null, 1));
                _columnsRequestedEntry.put("requestedKey", new TableInfo.Column("requestedKey", "TEXT", true, 0, null, 1));
                _columnsRequestedEntry.put("batchId", new TableInfo.Column("batchId", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysRequestedEntry = new HashSet(0);
                HashSet<TableInfo.Index> _indicesRequestedEntry = new HashSet<TableInfo.Index>(1);
                _indicesRequestedEntry.add(new TableInfo.Index("index_RequestedEntry_batchId", false, Arrays.asList("batchId"), Arrays.asList("ASC")));
                TableInfo _infoRequestedEntry = new TableInfo("RequestedEntry", _columnsRequestedEntry, _foreignKeysRequestedEntry, _indicesRequestedEntry);
                TableInfo _existingRequestedEntry = TableInfo.read((SupportSQLiteDatabase)db, (String)"RequestedEntry");
                if (!_infoRequestedEntry.equals((Object)_existingRequestedEntry)) {
                    return new RoomOpenHelper.ValidationResult(false, "RequestedEntry(com.ustadmobile.libcache.db.entities.RequestedEntry).\n Expected:\n" + _infoRequestedEntry + "\n Found:\n" + _existingRequestedEntry);
                }
                HashMap<String, TableInfo.Column> _columnsRetentionLock = new HashMap<String, TableInfo.Column>(3);
                _columnsRetentionLock.put("lockId", new TableInfo.Column("lockId", "INTEGER", true, 1, null, 1));
                _columnsRetentionLock.put("lockKey", new TableInfo.Column("lockKey", "TEXT", true, 0, null, 1));
                _columnsRetentionLock.put("lockRemark", new TableInfo.Column("lockRemark", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysRetentionLock = new HashSet(0);
                HashSet<TableInfo.Index> _indicesRetentionLock = new HashSet<TableInfo.Index>(1);
                _indicesRetentionLock.add(new TableInfo.Index("idx_lockKey", false, Arrays.asList("lockKey"), Arrays.asList("ASC")));
                TableInfo _infoRetentionLock = new TableInfo("RetentionLock", _columnsRetentionLock, _foreignKeysRetentionLock, _indicesRetentionLock);
                TableInfo _existingRetentionLock = TableInfo.read((SupportSQLiteDatabase)db, (String)"RetentionLock");
                if (!_infoRetentionLock.equals((Object)_existingRetentionLock)) {
                    return new RoomOpenHelper.ValidationResult(false, "RetentionLock(com.ustadmobile.libcache.db.entities.RetentionLock).\n Expected:\n" + _infoRetentionLock + "\n Found:\n" + _existingRetentionLock);
                }
                HashMap<String, TableInfo.Column> _columnsNeighborCache = new HashMap<String, TableInfo.Column>(9);
                _columnsNeighborCache.put("neighborUid", new TableInfo.Column("neighborUid", "INTEGER", true, 1, null, 1));
                _columnsNeighborCache.put("neighborDeviceName", new TableInfo.Column("neighborDeviceName", "TEXT", true, 0, null, 1));
                _columnsNeighborCache.put("neighborIp", new TableInfo.Column("neighborIp", "TEXT", true, 0, null, 1));
                _columnsNeighborCache.put("neighborUdpPort", new TableInfo.Column("neighborUdpPort", "INTEGER", true, 0, null, 1));
                _columnsNeighborCache.put("neighborHttpPort", new TableInfo.Column("neighborHttpPort", "INTEGER", true, 0, null, 1));
                _columnsNeighborCache.put("neighborDiscovered", new TableInfo.Column("neighborDiscovered", "INTEGER", true, 0, null, 1));
                _columnsNeighborCache.put("neighborPingTime", new TableInfo.Column("neighborPingTime", "INTEGER", true, 0, null, 1));
                _columnsNeighborCache.put("neighborLastSeen", new TableInfo.Column("neighborLastSeen", "INTEGER", true, 0, null, 1));
                _columnsNeighborCache.put("neighborStatus", new TableInfo.Column("neighborStatus", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysNeighborCache = new HashSet(0);
                HashSet _indicesNeighborCache = new HashSet(0);
                TableInfo _infoNeighborCache = new TableInfo("NeighborCache", _columnsNeighborCache, _foreignKeysNeighborCache, _indicesNeighborCache);
                TableInfo _existingNeighborCache = TableInfo.read((SupportSQLiteDatabase)db, (String)"NeighborCache");
                if (!_infoNeighborCache.equals((Object)_existingNeighborCache)) {
                    return new RoomOpenHelper.ValidationResult(false, "NeighborCache(com.ustadmobile.libcache.db.entities.NeighborCache).\n Expected:\n" + _infoNeighborCache + "\n Found:\n" + _existingNeighborCache);
                }
                HashMap<String, TableInfo.Column> _columnsNeighborCacheEntry = new HashMap<String, TableInfo.Column>(2);
                _columnsNeighborCacheEntry.put("nceNeighborUid", new TableInfo.Column("nceNeighborUid", "INTEGER", true, 1, null, 1));
                _columnsNeighborCacheEntry.put("nceUrlHash", new TableInfo.Column("nceUrlHash", "INTEGER", true, 2, null, 1));
                HashSet _foreignKeysNeighborCacheEntry = new HashSet(0);
                HashSet _indicesNeighborCacheEntry = new HashSet(0);
                TableInfo _infoNeighborCacheEntry = new TableInfo("NeighborCacheEntry", _columnsNeighborCacheEntry, _foreignKeysNeighborCacheEntry, _indicesNeighborCacheEntry);
                TableInfo _existingNeighborCacheEntry = TableInfo.read((SupportSQLiteDatabase)db, (String)"NeighborCacheEntry");
                if (!_infoNeighborCacheEntry.equals((Object)_existingNeighborCacheEntry)) {
                    return new RoomOpenHelper.ValidationResult(false, "NeighborCacheEntry(com.ustadmobile.libcache.db.entities.NeighborCacheEntry).\n Expected:\n" + _infoNeighborCacheEntry + "\n Found:\n" + _existingNeighborCacheEntry);
                }
                HashMap<String, TableInfo.Column> _columnsNewCacheEntry = new HashMap<String, TableInfo.Column>(2);
                _columnsNewCacheEntry.put("cacheEntryKey", new TableInfo.Column("cacheEntryKey", "TEXT", true, 1, null, 1));
                _columnsNewCacheEntry.put("nceUrl", new TableInfo.Column("nceUrl", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysNewCacheEntry = new HashSet(0);
                HashSet _indicesNewCacheEntry = new HashSet(0);
                TableInfo _infoNewCacheEntry = new TableInfo("NewCacheEntry", _columnsNewCacheEntry, _foreignKeysNewCacheEntry, _indicesNewCacheEntry);
                TableInfo _existingNewCacheEntry = TableInfo.read((SupportSQLiteDatabase)db, (String)"NewCacheEntry");
                if (!_infoNewCacheEntry.equals((Object)_existingNewCacheEntry)) {
                    return new RoomOpenHelper.ValidationResult(false, "NewCacheEntry(com.ustadmobile.libcache.db.entities.NewCacheEntry).\n Expected:\n" + _infoNewCacheEntry + "\n Found:\n" + _existingNewCacheEntry);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "91e0b1ee86ebf503079a196ed9753894", "5210962fa2bf0a54e9f68c932b020124");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"CacheEntry", "RequestedEntry", "RetentionLock", "NeighborCache", "NeighborCacheEntry", "NewCacheEntry"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `CacheEntry`");
            _db.execSQL("DELETE FROM `RequestedEntry`");
            _db.execSQL("DELETE FROM `RetentionLock`");
            _db.execSQL("DELETE FROM `NeighborCache`");
            _db.execSQL("DELETE FROM `NeighborCacheEntry`");
            _db.execSQL("DELETE FROM `NewCacheEntry`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(CacheEntryDao.class, CacheEntryDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(RequestedEntryDao.class, RequestedEntryDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(RetentionLockDao.class, RetentionLockDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(NeighborCacheDao.class, NeighborCacheDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(NeighborCacheEntryDao.class, NeighborCacheEntryDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(NewCacheEntryDao.class, NewCacheEntryDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntryDao getCacheEntryDao() {
        if (this._cacheEntryDao != null) {
            return this._cacheEntryDao;
        }
        UstadCacheDb_Impl ustadCacheDb_Impl = this;
        synchronized (ustadCacheDb_Impl) {
            if (this._cacheEntryDao == null) {
                this._cacheEntryDao = new CacheEntryDao_Impl(this);
            }
            return this._cacheEntryDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestedEntryDao getRequestedEntryDao() {
        if (this._requestedEntryDao != null) {
            return this._requestedEntryDao;
        }
        UstadCacheDb_Impl ustadCacheDb_Impl = this;
        synchronized (ustadCacheDb_Impl) {
            if (this._requestedEntryDao == null) {
                this._requestedEntryDao = new RequestedEntryDao_Impl(this);
            }
            return this._requestedEntryDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetentionLockDao getRetentionLockDao() {
        if (this._retentionLockDao != null) {
            return this._retentionLockDao;
        }
        UstadCacheDb_Impl ustadCacheDb_Impl = this;
        synchronized (ustadCacheDb_Impl) {
            if (this._retentionLockDao == null) {
                this._retentionLockDao = new RetentionLockDao_Impl(this);
            }
            return this._retentionLockDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NeighborCacheDao getNeighborCacheDao() {
        if (this._neighborCacheDao != null) {
            return this._neighborCacheDao;
        }
        UstadCacheDb_Impl ustadCacheDb_Impl = this;
        synchronized (ustadCacheDb_Impl) {
            if (this._neighborCacheDao == null) {
                this._neighborCacheDao = new NeighborCacheDao_Impl(this);
            }
            return this._neighborCacheDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NeighborCacheEntryDao getNeighborCacheEntryDao() {
        if (this._neighborCacheEntryDao != null) {
            return this._neighborCacheEntryDao;
        }
        UstadCacheDb_Impl ustadCacheDb_Impl = this;
        synchronized (ustadCacheDb_Impl) {
            if (this._neighborCacheEntryDao == null) {
                this._neighborCacheEntryDao = new NeighborCacheEntryDao_Impl(this);
            }
            return this._neighborCacheEntryDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NewCacheEntryDao getNewCacheEntryDao() {
        if (this._newCacheEntryDao != null) {
            return this._newCacheEntryDao;
        }
        UstadCacheDb_Impl ustadCacheDb_Impl = this;
        synchronized (ustadCacheDb_Impl) {
            if (this._newCacheEntryDao == null) {
                this._newCacheEntryDao = new NewCacheEntryDao_Impl(this);
            }
            return this._newCacheEntryDao;
        }
    }
}

