/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlinx.coroutines.flow.Flow;

public final class NeighborCacheEntryDao_Impl
extends NeighborCacheEntryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<NeighborCacheEntry> __insertionAdapterOfNeighborCacheEntry;

    public NeighborCacheEntryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNeighborCacheEntry = new EntityInsertionAdapter<NeighborCacheEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `NeighborCacheEntry` (`nceNeighborUid`,`nceUrlHash`) VALUES (?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull NeighborCacheEntry entity) {
                statement.bindLong(1, entity.getNceNeighborUid());
                statement.bindLong(2, entity.getNceUrlHash());
            }
        };
    }

    @Override
    public void upsertList(List<NeighborCacheEntry> neighborCacheEntryList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNeighborCacheEntry.insert(neighborCacheEntryList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Flow<List<NeighborCacheEntry>> allEntriesAsFlow() {
        String _sql = "\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"NeighborCacheEntry"}, (Callable)new Callable<List<NeighborCacheEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<NeighborCacheEntry> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)NeighborCacheEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfNceNeighborUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nceNeighborUid");
                    int _cursorIndexOfNceUrlHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nceUrlHash");
                    ArrayList<NeighborCacheEntry> _result = new ArrayList<NeighborCacheEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpNceNeighborUid = _cursor.getLong(_cursorIndexOfNceNeighborUid);
                        long _tmpNceUrlHash = _cursor.getLong(_cursorIndexOfNceUrlHash);
                        NeighborCacheEntry _item = new NeighborCacheEntry(_tmpNceNeighborUid, _tmpNceUrlHash);
                        _result.add(_item);
                    }
                    ArrayList<NeighborCacheEntry> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> findAvailableEntries(List<Long> urlHashes) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT NeighborCacheEntry.nceUrlHash");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM NeighborCacheEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE NeighborCacheEntry.nceUrlHash IN (");
        int _inputSize = urlHashes.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : urlHashes) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<Long> _result = new ArrayList<Long>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Long _item_1 = _cursor.getLong(0);
                _result.add(_item_1);
            }
            ArrayList<Long> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NeighborCacheEntryAndNeighborCache> findAvailableNeighborsByUrlHash(long urlHash) {
        String _sql = "\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = ?\n           AND NeighborCache.neighborStatus = 1\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = ?\n           AND NeighborCache.neighborStatus = 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, urlHash);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfNceNeighborUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nceNeighborUid");
            int _cursorIndexOfNceUrlHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nceUrlHash");
            int _cursorIndexOfNeighborUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborUid");
            int _cursorIndexOfNeighborDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborDeviceName");
            int _cursorIndexOfNeighborIp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborIp");
            int _cursorIndexOfNeighborUdpPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborUdpPort");
            int _cursorIndexOfNeighborHttpPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborHttpPort");
            int _cursorIndexOfNeighborDiscovered = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborDiscovered");
            int _cursorIndexOfNeighborPingTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborPingTime");
            int _cursorIndexOfNeighborLastSeen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborLastSeen");
            int _cursorIndexOfNeighborStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborStatus");
            ArrayList<NeighborCacheEntryAndNeighborCache> _result = new ArrayList<NeighborCacheEntryAndNeighborCache>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpNceNeighborUid = _cursor.getLong(_cursorIndexOfNceNeighborUid);
                long _tmpNceUrlHash = _cursor.getLong(_cursorIndexOfNceUrlHash);
                NeighborCacheEntry _tmpNeighborCacheEntry = new NeighborCacheEntry(_tmpNceNeighborUid, _tmpNceUrlHash);
                long _tmpNeighborUid = _cursor.getLong(_cursorIndexOfNeighborUid);
                String _tmpNeighborDeviceName = _cursor.getString(_cursorIndexOfNeighborDeviceName);
                String _tmpNeighborIp = _cursor.getString(_cursorIndexOfNeighborIp);
                int _tmpNeighborUdpPort = _cursor.getInt(_cursorIndexOfNeighborUdpPort);
                int _tmpNeighborHttpPort = _cursor.getInt(_cursorIndexOfNeighborHttpPort);
                long _tmpNeighborDiscovered = _cursor.getLong(_cursorIndexOfNeighborDiscovered);
                int _tmpNeighborPingTime = _cursor.getInt(_cursorIndexOfNeighborPingTime);
                long _tmpNeighborLastSeen = _cursor.getLong(_cursorIndexOfNeighborLastSeen);
                int _tmpNeighborStatus = _cursor.getInt(_cursorIndexOfNeighborStatus);
                NeighborCache _tmpNeighborCache = new NeighborCache(_tmpNeighborUid, _tmpNeighborDeviceName, _tmpNeighborIp, _tmpNeighborUdpPort, _tmpNeighborHttpPort, _tmpNeighborDiscovered, _tmpNeighborPingTime, _tmpNeighborLastSeen, _tmpNeighborStatus);
                NeighborCacheEntryAndNeighborCache _item = new NeighborCacheEntryAndNeighborCache(_tmpNeighborCache, _tmpNeighborCacheEntry);
                _result.add(_item);
            }
            ArrayList<NeighborCacheEntryAndNeighborCache> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

