/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedHashCacheEntry;", "", "urlHash", "", "md5Hi", "md5Lo", "(JJJ)V", "getMd5Hi", "()J", "getMd5Lo", "getUrlHash", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "writeBytes", "", "buffer", "Ljava/nio/ByteBuffer;", "Companion", "lib-cache_release"})
public final class DistributedHashCacheEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long urlHash;
    private final long md5Hi;
    private final long md5Lo;
    public static final int SIZE = 24;

    public DistributedHashCacheEntry(long urlHash, long md5Hi, long md5Lo) {
        this.urlHash = urlHash;
        this.md5Hi = md5Hi;
        this.md5Lo = md5Lo;
    }

    public final long getUrlHash() {
        return this.urlHash;
    }

    public final long getMd5Hi() {
        return this.md5Hi;
    }

    public final long getMd5Lo() {
        return this.md5Lo;
    }

    public final void writeBytes(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.putLong(this.urlHash);
        buffer.putLong(this.md5Hi);
        buffer.putLong(this.md5Lo);
    }

    public final long component1() {
        return this.urlHash;
    }

    public final long component2() {
        return this.md5Hi;
    }

    public final long component3() {
        return this.md5Lo;
    }

    @NotNull
    public final DistributedHashCacheEntry copy(long urlHash, long md5Hi, long md5Lo) {
        return new DistributedHashCacheEntry(urlHash, md5Hi, md5Lo);
    }

    public static /* synthetic */ DistributedHashCacheEntry copy$default(DistributedHashCacheEntry distributedHashCacheEntry, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            l = distributedHashCacheEntry.urlHash;
        }
        if ((n & 2) != 0) {
            l2 = distributedHashCacheEntry.md5Hi;
        }
        if ((n & 4) != 0) {
            l3 = distributedHashCacheEntry.md5Lo;
        }
        return distributedHashCacheEntry.copy(l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "DistributedHashCacheEntry(urlHash=" + this.urlHash + ", md5Hi=" + this.md5Hi + ", md5Lo=" + this.md5Lo + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.urlHash);
        result = result * 31 + Long.hashCode(this.md5Hi);
        result = result * 31 + Long.hashCode(this.md5Lo);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DistributedHashCacheEntry)) {
            return false;
        }
        DistributedHashCacheEntry distributedHashCacheEntry = (DistributedHashCacheEntry)other;
        if (this.urlHash != distributedHashCacheEntry.urlHash) {
            return false;
        }
        if (this.md5Hi != distributedHashCacheEntry.md5Hi) {
            return false;
        }
        return this.md5Lo == distributedHashCacheEntry.md5Lo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedHashCacheEntry$Companion;", "", "()V", "SIZE", "", "readBytes", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashCacheEntry;", "buffer", "Ljava/nio/ByteBuffer;", "lib-cache_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedHashCacheEntry readBytes(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long urlHash = buffer.getLong();
            long md5Hi = buffer.getLong();
            long md5Lo = buffer.getLong();
            return new DistributedHashCacheEntry(urlHash, md5Hi, md5Lo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

