/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.dao.NeighborCacheDao;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class NeighborCacheDao_Impl
extends NeighborCacheDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<NeighborCache> __insertionAdapterOfNeighborCache;
    private final EntityInsertionAdapter<NeighborCache> __insertionAdapterOfNeighborCache_1;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAsync;
    private final SharedSQLiteStatement __preparedStmtOfUpdateHttpPort;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePingTime;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatuses;
    private final SharedSQLiteStatement __preparedStmtOfUpdateDeviceName;

    public NeighborCacheDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNeighborCache = new EntityInsertionAdapter<NeighborCache>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `NeighborCache` (`neighborUid`,`neighborDeviceName`,`neighborIp`,`neighborUdpPort`,`neighborHttpPort`,`neighborDiscovered`,`neighborPingTime`,`neighborLastSeen`,`neighborStatus`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull NeighborCache entity) {
                statement.bindLong(1, entity.getNeighborUid());
                statement.bindString(2, entity.getNeighborDeviceName());
                statement.bindString(3, entity.getNeighborIp());
                statement.bindLong(4, (long)entity.getNeighborUdpPort());
                statement.bindLong(5, (long)entity.getNeighborHttpPort());
                statement.bindLong(6, entity.getNeighborDiscovered());
                statement.bindLong(7, (long)entity.getNeighborPingTime());
                statement.bindLong(8, entity.getNeighborLastSeen());
                statement.bindLong(9, (long)entity.getNeighborStatus());
            }
        };
        this.__insertionAdapterOfNeighborCache_1 = new EntityInsertionAdapter<NeighborCache>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `NeighborCache` (`neighborUid`,`neighborDeviceName`,`neighborIp`,`neighborUdpPort`,`neighborHttpPort`,`neighborDiscovered`,`neighborPingTime`,`neighborLastSeen`,`neighborStatus`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull NeighborCache entity) {
                statement.bindLong(1, entity.getNeighborUid());
                statement.bindString(2, entity.getNeighborDeviceName());
                statement.bindString(3, entity.getNeighborIp());
                statement.bindLong(4, (long)entity.getNeighborUdpPort());
                statement.bindLong(5, (long)entity.getNeighborHttpPort());
                statement.bindLong(6, entity.getNeighborDiscovered());
                statement.bindLong(7, (long)entity.getNeighborPingTime());
                statement.bindLong(8, entity.getNeighborLastSeen());
                statement.bindLong(9, (long)entity.getNeighborStatus());
            }
        };
        this.__preparedStmtOfDeleteAsync = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        DELETE FROM NeighborCache\n         WHERE neighborUid = ?\n    ";
                return "\n        DELETE FROM NeighborCache\n         WHERE neighborUid = ?\n    ";
            }
        };
        this.__preparedStmtOfUpdateHttpPort = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE NeighborCache\n           SET neighborHttpPort = ?\n         WHERE neighborUid = ?\n           AND neighborHttpPort != ?\n    ";
                return "\n        UPDATE NeighborCache\n           SET neighborHttpPort = ?\n         WHERE neighborUid = ?\n           AND neighborHttpPort != ?\n    ";
            }
        };
        this.__preparedStmtOfUpdatePingTime = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE NeighborCache\n           SET neighborPingTime = ?,\n               neighborLastSeen = ?\n         WHERE neighborUid = ?  \n    ";
                return "\n        UPDATE NeighborCache\n           SET neighborPingTime = ?,\n               neighborLastSeen = ?\n         WHERE neighborUid = ?  \n    ";
            }
        };
        this.__preparedStmtOfUpdateStatuses = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE NeighborCache\n           SET neighborStatus = CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)\n         WHERE neighborStatus != CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)   \n    ";
                return "\n        UPDATE NeighborCache\n           SET neighborStatus = CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)\n         WHERE neighborStatus != CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)   \n    ";
            }
        };
        this.__preparedStmtOfUpdateDeviceName = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE NeighborCache\n           SET neighborDeviceName = ?\n        WHERE neighborUid = ?\n          AND neighborDeviceName != ?   \n    ";
                return "\n        UPDATE NeighborCache\n           SET neighborDeviceName = ?\n        WHERE neighborUid = ?\n          AND neighborDeviceName != ?   \n    ";
            }
        };
    }

    @Override
    public Object upsertAsync(final NeighborCache neighborCache, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                NeighborCacheDao_Impl.this.__db.beginTransaction();
                try {
                    NeighborCacheDao_Impl.this.__insertionAdapterOfNeighborCache.insert((Object)neighborCache);
                    NeighborCacheDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    NeighborCacheDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void upsert(NeighborCache neighborCache) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNeighborCache.insert((Object)neighborCache);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertOrIgnore(NeighborCache neighborCache) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNeighborCache_1.insert((Object)neighborCache);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object deleteAsync(final long neighborUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = NeighborCacheDao_Impl.this.__preparedStmtOfDeleteAsync.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, neighborUid);
                try {
                    Unit unit;
                    NeighborCacheDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        NeighborCacheDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        NeighborCacheDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    NeighborCacheDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    NeighborCacheDao_Impl.this.__preparedStmtOfDeleteAsync.release(_stmt);
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHttpPort(long neighborUid, int httpPort) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateHttpPort.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)httpPort);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, neighborUid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)httpPort);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateHttpPort.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updatePingTime(long neighborUid, int pingTime, long timeNow) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePingTime.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)pingTime);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, timeNow);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, neighborUid);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfUpdatePingTime.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatuses(long timeNow, long lostThreshold) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateStatuses.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, timeNow);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, lostThreshold);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, timeNow);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, lostThreshold);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateStatuses.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceName(long neighborUid, String deviceName) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateDeviceName.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, deviceName);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, neighborUid);
        _argIndex = 3;
        _stmt.bindString(_argIndex, deviceName);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateDeviceName.release(_stmt);
        }
    }

    @Override
    public Flow<List<NeighborCache>> allNeighborsAsFlow() {
        String _sql = "\n        SELECT NeighborCache.*\n          FROM NeighborCache\n         WHERE NeighborCache.neighborStatus = 1 \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT NeighborCache.*\n          FROM NeighborCache\n         WHERE NeighborCache.neighborStatus = 1 \n    ", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"NeighborCache"}, (Callable)new Callable<List<NeighborCache>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<NeighborCache> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)NeighborCacheDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfNeighborUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborUid");
                    int _cursorIndexOfNeighborDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborDeviceName");
                    int _cursorIndexOfNeighborIp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborIp");
                    int _cursorIndexOfNeighborUdpPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborUdpPort");
                    int _cursorIndexOfNeighborHttpPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborHttpPort");
                    int _cursorIndexOfNeighborDiscovered = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborDiscovered");
                    int _cursorIndexOfNeighborPingTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborPingTime");
                    int _cursorIndexOfNeighborLastSeen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborLastSeen");
                    int _cursorIndexOfNeighborStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborStatus");
                    ArrayList<NeighborCache> _result = new ArrayList<NeighborCache>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpNeighborUid = _cursor.getLong(_cursorIndexOfNeighborUid);
                        String _tmpNeighborDeviceName = _cursor.getString(_cursorIndexOfNeighborDeviceName);
                        String _tmpNeighborIp = _cursor.getString(_cursorIndexOfNeighborIp);
                        int _tmpNeighborUdpPort = _cursor.getInt(_cursorIndexOfNeighborUdpPort);
                        int _tmpNeighborHttpPort = _cursor.getInt(_cursorIndexOfNeighborHttpPort);
                        long _tmpNeighborDiscovered = _cursor.getLong(_cursorIndexOfNeighborDiscovered);
                        int _tmpNeighborPingTime = _cursor.getInt(_cursorIndexOfNeighborPingTime);
                        long _tmpNeighborLastSeen = _cursor.getLong(_cursorIndexOfNeighborLastSeen);
                        int _tmpNeighborStatus = _cursor.getInt(_cursorIndexOfNeighborStatus);
                        NeighborCache _item = new NeighborCache(_tmpNeighborUid, _tmpNeighborDeviceName, _tmpNeighborIp, _tmpNeighborUdpPort, _tmpNeighborHttpPort, _tmpNeighborDiscovered, _tmpNeighborPingTime, _tmpNeighborLastSeen, _tmpNeighborStatus);
                        _result.add(_item);
                    }
                    ArrayList<NeighborCache> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NeighborCache> allNeighbors() {
        String _sql = "\n        SELECT NeighborCache.*\n          FROM NeighborCache\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT NeighborCache.*\n          FROM NeighborCache\n    ", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfNeighborUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborUid");
            int _cursorIndexOfNeighborDeviceName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborDeviceName");
            int _cursorIndexOfNeighborIp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborIp");
            int _cursorIndexOfNeighborUdpPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborUdpPort");
            int _cursorIndexOfNeighborHttpPort = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborHttpPort");
            int _cursorIndexOfNeighborDiscovered = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborDiscovered");
            int _cursorIndexOfNeighborPingTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborPingTime");
            int _cursorIndexOfNeighborLastSeen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborLastSeen");
            int _cursorIndexOfNeighborStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"neighborStatus");
            ArrayList<NeighborCache> _result = new ArrayList<NeighborCache>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpNeighborUid = _cursor.getLong(_cursorIndexOfNeighborUid);
                String _tmpNeighborDeviceName = _cursor.getString(_cursorIndexOfNeighborDeviceName);
                String _tmpNeighborIp = _cursor.getString(_cursorIndexOfNeighborIp);
                int _tmpNeighborUdpPort = _cursor.getInt(_cursorIndexOfNeighborUdpPort);
                int _tmpNeighborHttpPort = _cursor.getInt(_cursorIndexOfNeighborHttpPort);
                long _tmpNeighborDiscovered = _cursor.getLong(_cursorIndexOfNeighborDiscovered);
                int _tmpNeighborPingTime = _cursor.getInt(_cursorIndexOfNeighborPingTime);
                long _tmpNeighborLastSeen = _cursor.getLong(_cursorIndexOfNeighborLastSeen);
                int _tmpNeighborStatus = _cursor.getInt(_cursorIndexOfNeighborStatus);
                NeighborCache _item = new NeighborCache(_tmpNeighborUid, _tmpNeighborDeviceName, _tmpNeighborIp, _tmpNeighborUdpPort, _tmpNeighborHttpPort, _tmpNeighborDiscovered, _tmpNeighborPingTime, _tmpNeighborLastSeen, _tmpNeighborStatus);
                _result.add(_item);
            }
            ArrayList<NeighborCache> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

