# Cypress End-to-end tests

These are end-to-end tests for the web version of the app built using [Cypress](https://cypress.io).

Requirements:

* Install Node and NPM as per [NPM official docs](https://docs.npmjs.com/downloading-and-installing-node-js-and-npm). 
  This is tested using NPM10 and Node 18.
* Install Cypress dependencies as [Cypress docs](https://docs.cypress.io/guides/continuous-integration/introduction#Dependencies)
* Build the app-ktor-server and testserver-controller (inc) e.g.
  
  Build the entire project with ```./gradlew build  -Pktorbundleproductionjs=true``` OR 
  ```./gradlew app-ktor-server:build testserver-controller:build  -Pktorbundleproductionjs=true```
  to build only the server and testserver-controller. 

 Important: Building MUST use ```-Pktorbundleproductionjs=true``` to include the production webapp
 in the server. See the building for production note in app-ktor-server/README.md.

This is currently running/tested on Ubuntu Linux. It should work on Windows, but this is not yet 
tested.

Running:
```
./run-cypress-test.sh
```

Optional args:

* --spec specname (as found in e2e directory, without the .cy.js suffix e.g. ```--spec WEB_001_001_add_content```)


How it works (in progress):

* package.json uses start-server-and-test command as [recommended by Cypress docs](https://docs.cypress.io/app/continuous-integration/overview#Solutions) to
  start the testserver-controller.
* testserver-controller is called by http request from the test spec and starts a blank new instance 
  of the actual server on request on a new port for each test (see testserver-controller docs).
