/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.compress.video;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import androidx.annotation.OptIn;
import androidx.core.net.UriKt;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.Presentation;
import androidx.media3.transformer.Codec;
import androidx.media3.transformer.Composition;
import androidx.media3.transformer.DefaultEncoderFactory;
import androidx.media3.transformer.EditedMediaItem;
import androidx.media3.transformer.Effects;
import androidx.media3.transformer.ExportException;
import androidx.media3.transformer.ExportResult;
import androidx.media3.transformer.ProgressHolder;
import androidx.media3.transformer.Transformer;
import androidx.media3.transformer.VideoEncoderSettings;
import com.ustadmobile.core.domain.compress.CompressParams;
import com.ustadmobile.core.domain.compress.CompressProgressUpdate;
import com.ustadmobile.core.domain.compress.CompressResult;
import com.ustadmobile.core.domain.compress.CompressUseCase;
import com.ustadmobile.core.domain.compress.CompressionLevel;
import com.ustadmobile.core.domain.compress.video.CompressVideoUseCase;
import com.ustadmobile.core.domain.compress.video.CompressVideoUseCaseAndroid;
import com.ustadmobile.core.ext.FileExtKt;
import com.ustadmobile.core.uri.UriHelper;
import com.ustadmobile.core.util.UMFileUtil;
import com.ustadmobile.door.DoorUri;
import com.ustadmobile.door.ext.FileExpectExtKt;
import io.github.aakira.napier.Napier;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J4\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0097B\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\u00020\f*\u00020\nH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/core/domain/compress/video/CompressVideoUseCaseAndroid;", "Lcom/ustadmobile/core/domain/compress/video/CompressVideoUseCase;", "appContext", "Landroid/content/Context;", "uriHelper", "Lcom/ustadmobile/core/uri/UriHelper;", "(Landroid/content/Context;Lcom/ustadmobile/core/uri/UriHelper;)V", "createPresentationHeightByCompressionLevel", "Landroidx/media3/effect/Presentation;", "compressionLevel", "Lcom/ustadmobile/core/domain/compress/CompressionLevel;", "widthIn", "", "heightIn", "invoke", "Lcom/ustadmobile/core/domain/compress/CompressResult;", "fromUri", "", "toUri", "params", "Lcom/ustadmobile/core/domain/compress/CompressParams;", "onProgress", "Lcom/ustadmobile/core/domain/compress/CompressUseCase$OnCompressProgress;", "(Ljava/lang/String;Ljava/lang/String;Lcom/ustadmobile/core/domain/compress/CompressParams;Lcom/ustadmobile/core/domain/compress/CompressUseCase$OnCompressProgress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "expectedTotalBitrate", "setBitrateForCompressionLevel", "Landroidx/media3/transformer/VideoEncoderSettings$Builder;", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nCompressVideoUseCaseAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressVideoUseCaseAndroid.kt\ncom/ustadmobile/core/domain/compress/video/CompressVideoUseCaseAndroid\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,268:1\n12474#2,2:269\n*S KotlinDebug\n*F\n+ 1 CompressVideoUseCaseAndroid.kt\ncom/ustadmobile/core/domain/compress/video/CompressVideoUseCaseAndroid\n*L\n182#1:269,2\n*E\n"})
public final class CompressVideoUseCaseAndroid
implements CompressVideoUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    @NotNull
    private final UriHelper uriHelper;
    public static final float COMPRESS_THRESHOLD = 0.95f;

    public CompressVideoUseCaseAndroid(@NotNull Context appContext, @NotNull UriHelper uriHelper) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)uriHelper, (String)"uriHelper");
        this.appContext = appContext;
        this.uriHelper = uriHelper;
    }

    @OptIn(markerClass={UnstableApi.class})
    @NotNull
    public final Presentation createPresentationHeightByCompressionLevel(@NotNull CompressionLevel compressionLevel, int widthIn, int heightIn) {
        Intrinsics.checkNotNullParameter((Object)((Object)compressionLevel), (String)"compressionLevel");
        boolean isHd = compressionLevel.getValue() >= CompressionLevel.MEDIUM.getValue();
        int height = isHd && widthIn > heightIn ? 720 : (isHd ? 1280 : (widthIn > heightIn ? 480 : 720));
        Presentation presentation = Presentation.createForHeight((int)height);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"createForHeight(...)");
        return presentation;
    }

    @OptIn(markerClass={UnstableApi.class})
    @NotNull
    public final VideoEncoderSettings.Builder setBitrateForCompressionLevel(@NotNull VideoEncoderSettings.Builder $this$setBitrateForCompressionLevel, @NotNull CompressionLevel compressionLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$setBitrateForCompressionLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)compressionLevel), (String)"compressionLevel");
        switch (WhenMappings.$EnumSwitchMapping$0[compressionLevel.ordinal()]) {
            case 1: {
                $this$setBitrateForCompressionLevel.setBitrate(170000);
                break;
            }
            case 2: {
                $this$setBitrateForCompressionLevel.setBitrate(250000);
                break;
            }
            case 3: {
                $this$setBitrateForCompressionLevel.setBitrate(500000);
                break;
            }
            case 4: {
                $this$setBitrateForCompressionLevel.setBitrate(2000000);
                break;
            }
            case 5: {
                $this$setBitrateForCompressionLevel.setBitrate(5000000);
            }
        }
        return $this$setBitrateForCompressionLevel;
    }

    private final int expectedTotalBitrate(CompressionLevel $this$expectedTotalBitrate) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$expectedTotalBitrate.ordinal()]) {
            case 1 -> 266000;
            case 2 -> 346000;
            case 3 -> 628000;
            case 4 -> 2196000;
            case 5 -> 5196000;
            default -> -1;
        };
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @OptIn(markerClass={UnstableApi.class})
    @Nullable
    public Object invoke(@NotNull String var1_1, @Nullable String var2_2, @NotNull CompressParams var3_3, @Nullable CompressUseCase.OnCompressProgress var4_4, @NotNull Continuation<? super CompressResult> var5_5) {
        if (!(var5_5 instanceof invoke.1)) ** GOTO lbl-1000
        var31_6 = var5_5;
        if ((var31_6.label & -2147483648) != 0) {
            var31_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ CompressVideoUseCaseAndroid this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.invoke(null, null, null, null, (Continuation<? super CompressResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var32_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (toUri != null) {
                    var7_9 = Uri.parse((String)toUri);
                    Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"parse(...)");
                    v0 = FileExtKt.requireExtension(UriKt.toFile((Uri)var7_9), "mp4");
                } else {
                    v0 = new File(this.appContext.getCacheDir(), UUID.randomUUID().toString() + ".mp4");
                }
                destFile = v0;
                $continuation.L$0 = this;
                $continuation.L$1 = fromUri;
                $continuation.L$2 = params;
                $continuation.L$3 = onProgress;
                $continuation.L$4 = destFile;
                $continuation.label = 1;
                v1 = this.uriHelper.getSize(DoorUri.Companion.parse(fromUri), (Continuation<? super Long>)$continuation);
                if (v1 == var32_8) {
                    return var32_8;
                }
                ** GOTO lbl37
            }
            case 1: {
                destFile = (File)$continuation.L$4;
                onProgress = (CompressUseCase.OnCompressProgress)$continuation.L$3;
                params = (CompressParams)$continuation.L$2;
                fromUri = (String)$continuation.L$1;
                this = (CompressVideoUseCaseAndroid)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                sizeIn = ((Number)v1).longValue();
                metaRetriever = new MediaMetadataRetriever();
                metaRetriever.setDataSource(this.appContext, Uri.parse((String)fromUri));
                v2 = metaRetriever.extractMetadata(18);
                originalWidth = v2 != null ? Integer.parseInt(v2) : 0;
                v3 = metaRetriever.extractMetadata(19);
                originalHeight = v3 != null ? Integer.parseInt(v3) : 0;
                v4 = metaRetriever.extractMetadata(9);
                duration = v4 != null ? Long.parseLong(v4) : 0L;
                metaRetriever.release();
                expectedSize = (long)(this.expectedTotalBitrate(params.getCompressionLevel()) / 8) * (duration / (long)1000);
                if ((float)expectedSize * 0.95f >= (float)sizeIn) {
                    Napier.d$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(expectedSize, sizeIn){
                        final /* synthetic */ long $expectedSize;
                        final /* synthetic */ long $sizeIn;
                        {
                            this.$expectedSize = $expectedSize;
                            this.$sizeIn = $sizeIn;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "CompressVideoUseCaseAndroid: expected size of " + UMFileUtil.INSTANCE.formatFileSize(this.$expectedSize) + " is not within threshold to compress. Original size = " + UMFileUtil.INSTANCE.formatFileSize(this.$sizeIn) + ".";
                        }
                    }), (int)3, null);
                    return null;
                }
                v5 = MediaItem.fromUri((Uri)Uri.parse((String)fromUri));
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"fromUri(...)");
                inputMediaItem = v5;
                presentation = originalWidth != 0 && originalHeight != 0 ? this.createPresentationHeightByCompressionLevel(params.getCompressionLevel(), originalWidth, originalHeight) : null;
                editedMediaItem = presentation != null ? new EditedMediaItem.Builder(inputMediaItem).setEffects(new Effects(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)presentation))).build() : null;
                v6 = this.setBitrateForCompressionLevel(new VideoEncoderSettings.Builder(), params.getCompressionLevel()).build();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"build(...)");
                videoEncoderSettings = v6;
                v7 = new DefaultEncoderFactory.Builder(this.appContext).setRequestedVideoEncoderSettings(videoEncoderSettings).build();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"build(...)");
                encoderFactory = v7;
                codecList = new MediaCodecList(1);
                var23_23 = codecList.getCodecInfos();
                Intrinsics.checkNotNullExpressionValue((Object)var23_23, (String)"getCodecInfos(...)");
                $this$any$iv = var23_23;
                $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    it = (MediaCodecInfo)element$iv;
                    $i$a$-any-CompressVideoUseCaseAndroid$invoke$hasAV1Support$1 = false;
                    if (!it.isEncoder()) ** GOTO lbl-1000
                    v8 = it.getSupportedTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getSupportedTypes(...)");
                    if (ArraysKt.contains((Object[])v8, (Object)"video/AV1")) {
                        v9 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = false;
                    }
                    if (!v9) continue;
                    v10 = true;
                    ** GOTO lbl81
                }
                v10 = false;
lbl81:
                // 2 sources

                hasAV1Support = v10;
                videoMimeType = hasAV1Support != false ? "video/av01" : "video/avc";
                Napier.d$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(videoMimeType){
                    final /* synthetic */ String $videoMimeType;
                    {
                        this.$videoMimeType = $videoMimeType;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "CompressVideoUseCaseAndroid: will encode using " + this.$videoMimeType;
                    }
                }), (int)3, null);
                v11 = new Transformer.Builder(this.appContext).setVideoMimeType(videoMimeType).setEncoderFactory((Codec.EncoderFactory)encoderFactory).build();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"build(...)");
                transformer = v11;
                completeable = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                $continuation.L$0 = destFile;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.J$0 = sizeIn;
                $continuation.label = 2;
                v12 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExportResult>, Object>(transformer, editedMediaItem, destFile, inputMediaItem, (CompletableDeferred<ExportResult>)completeable, onProgress, fromUri, sizeIn, null){
                    Object L$1;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Transformer $transformer;
                    final /* synthetic */ EditedMediaItem $editedMediaItem;
                    final /* synthetic */ File $destFile;
                    final /* synthetic */ MediaItem $inputMediaItem;
                    final /* synthetic */ CompletableDeferred<ExportResult> $completeable;
                    final /* synthetic */ CompressUseCase.OnCompressProgress $onProgress;
                    final /* synthetic */ String $fromUri;
                    final /* synthetic */ long $sizeIn;
                    {
                        this.$transformer = $transformer;
                        this.$editedMediaItem = $editedMediaItem;
                        this.$destFile = $destFile;
                        this.$inputMediaItem = $inputMediaItem;
                        this.$completeable = $completeable;
                        this.$onProgress = $onProgress;
                        this.$fromUri = $fromUri;
                        this.$sizeIn = $sizeIn;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$withContext = (CoroutineScope)this.L$0;
                                this.$transformer.addListener(new Transformer.Listener(this.$completeable){
                                    final /* synthetic */ CompletableDeferred<ExportResult> $completeable;
                                    {
                                        this.$completeable = $completeable;
                                    }

                                    public void onCompleted(@NotNull Composition composition, @NotNull ExportResult exportResult) {
                                        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
                                        Intrinsics.checkNotNullParameter((Object)exportResult, (String)"exportResult");
                                        this.$completeable.complete((Object)exportResult);
                                    }

                                    public void onError(@NotNull Composition composition, @NotNull ExportResult exportResult, @NotNull ExportException exportException) {
                                        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
                                        Intrinsics.checkNotNullParameter((Object)exportResult, (String)"exportResult");
                                        Intrinsics.checkNotNullParameter((Object)exportException, (String)"exportException");
                                        Napier.e$default((Napier)Napier.INSTANCE, (String)("CompressVideoUseCaseAndroid: onError: " + exportResult), (Throwable)((Throwable)exportException), null, (int)4, null);
                                        this.$completeable.completeExceptionally((Throwable)exportException);
                                    }
                                });
                                if (this.$editedMediaItem != null) {
                                    this.$transformer.start(this.$editedMediaItem, this.$destFile.getAbsolutePath());
                                } else {
                                    this.$transformer.start(this.$inputMediaItem, this.$destFile.getAbsolutePath());
                                }
                                progressUpdateJob = BuildersKt.launch$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$transformer, this.$onProgress, this.$fromUri, this.$sizeIn, null){
                                    Object L$1;
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ Transformer $transformer;
                                    final /* synthetic */ CompressUseCase.OnCompressProgress $onProgress;
                                    final /* synthetic */ String $fromUri;
                                    final /* synthetic */ long $sizeIn;
                                    {
                                        this.$transformer = $transformer;
                                        this.$onProgress = $onProgress;
                                        this.$fromUri = $fromUri;
                                        this.$sizeIn = $sizeIn;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                $this$launch = (CoroutineScope)this.L$0;
                                                progressHolder = new ProgressHolder();
lbl7:
                                                // 3 sources

                                                while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                                    this.L$0 = $this$launch;
                                                    this.L$1 = progressHolder;
                                                    this.label = 1;
                                                    v0 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                                                    if (v0 == var4_2) {
                                                        return var4_2;
                                                    }
                                                    ** GOTO lbl21
                                                }
                                                break;
                                            }
                                            case 1: {
                                                progressHolder = (ProgressHolder)this.L$1;
                                                $this$launch = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl21:
                                                // 2 sources

                                                this.$transformer.getProgress(progressHolder);
                                                progressHolder.progress;
                                                v1 = this.$onProgress;
                                                if (v1 == null) ** GOTO lbl7
                                                v1.invoke(new CompressProgressUpdate(this.$fromUri, (long)((float)progressHolder.progress / 100.0f * (float)this.$sizeIn), this.$sizeIn));
                                                ** GOTO lbl7
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                this.L$0 = progressUpdateJob;
                                this.label = 1;
                                v0 = this.$completeable.await((Continuation)this);
                                ** if (v0 != var6_2) goto lbl19
lbl18:
                                // 1 sources

                                return var6_2;
lbl19:
                                // 1 sources

                                ** GOTO lbl26
                            }
                            case 1: {
                                progressUpdateJob = (Job)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl26:
                                    // 2 sources

                                    var4_5 = (ExportResult)v0;
                                }
                                catch (Exception e) {
                                    if (!(e instanceof CancellationException)) ** GOTO lbl46
                                    this.L$0 = progressUpdateJob;
                                    this.L$1 = e;
                                    this.label = 2;
                                    v1 = BuildersKt.withContext((CoroutineContext)NonCancellable.INSTANCE.plus((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$transformer, null){
                                        int label;
                                        final /* synthetic */ Transformer $transformer;
                                        {
                                            this.$transformer = $transformer;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.$transformer.cancel();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    ** if (v1 != var6_2) goto lbl38
lbl37:
                                    // 1 sources

                                    return var6_2;
lbl38:
                                    // 1 sources

                                    ** GOTO lbl46
                                }
                                Job.DefaultImpls.cancel$default((Job)progressUpdateJob, null, (int)1, null);
                                break;
                            }
                            case 2: {
                                e = (Exception)this.L$1;
                                progressUpdateJob = (Job)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl46:
                                // 3 sources

                                throw e;
                                {
                                    catch (Throwable var5_8) {
                                        Job.DefaultImpls.cancel$default((Job)progressUpdateJob, null, (int)1, null);
                                        throw var5_8;
                                    }
                                }
                            }
                        }
                        return var4_5;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ExportResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v12 == var32_8) {
                    return var32_8;
                }
                ** GOTO lbl104
            }
            case 2: {
                sizeIn = $continuation.J$0;
                destFile = (File)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl104:
                // 2 sources

                if ((resultSize = destFile.length()) < sizeIn) {
                    var28_31 = FileExpectExtKt.toDoorUri((File)destFile).toString();
                    v13 = new CompressResult(var28_31, "video/mp4", sizeIn, resultSize);
                } else {
                    destFile.delete();
                    v13 = null;
                }
                return v13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/core/domain/compress/video/CompressVideoUseCaseAndroid$Companion;", "", "()V", "COMPRESS_THRESHOLD", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompressionLevel.values().length];
            try {
                nArray[CompressionLevel.HIGHEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionLevel.HIGH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionLevel.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionLevel.LOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionLevel.LOWEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

