package com.ustadmobile.libcache.db;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.ustadmobile.libcache.db.dao.CacheEntryDao;
import com.ustadmobile.libcache.db.dao.CacheEntryDao_Impl;
import com.ustadmobile.libcache.db.dao.RequestedEntryDao;
import com.ustadmobile.libcache.db.dao.RequestedEntryDao_Impl;
import com.ustadmobile.libcache.db.dao.RetentionLockDao;
import com.ustadmobile.libcache.db.dao.RetentionLockDao_Impl;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UstadCacheDb_Impl extends UstadCacheDb {
  private volatile CacheEntryDao _cacheEntryDao;

  private volatile RequestedEntryDao _requestedEntryDao;

  private volatile RetentionLockDao _retentionLockDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(9) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `CacheEntry` (`key` TEXT NOT NULL, `url` TEXT NOT NULL, `message` TEXT NOT NULL, `statusCode` INTEGER NOT NULL, `cacheFlags` INTEGER NOT NULL, `method` INTEGER NOT NULL, `lastAccessed` INTEGER NOT NULL, `lastValidated` INTEGER NOT NULL, `integrity` TEXT, `responseHeaders` TEXT NOT NULL, `storageUri` TEXT NOT NULL, `storageSize` INTEGER NOT NULL, `uncompressedSize` INTEGER NOT NULL DEFAULT 0, PRIMARY KEY(`key`))");
        db.execSQL("CREATE INDEX IF NOT EXISTS `idx_lastAccessed` ON `CacheEntry` (`lastAccessed`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_CacheEntry_integrity` ON `CacheEntry` (`integrity`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `RequestedEntry` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `requestSha256` TEXT NOT NULL, `requestedKey` TEXT NOT NULL, `batchId` INTEGER NOT NULL)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_RequestedEntry_batchId` ON `RequestedEntry` (`batchId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `RetentionLock` (`lockId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `lockKey` TEXT NOT NULL, `lockRemark` TEXT NOT NULL)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `idx_lockKey` ON `RetentionLock` (`lockKey`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '9e2777cdd51ec20188d84427eea050a4')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `CacheEntry`");
        db.execSQL("DROP TABLE IF EXISTS `RequestedEntry`");
        db.execSQL("DROP TABLE IF EXISTS `RetentionLock`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsCacheEntry = new HashMap<String, TableInfo.Column>(13);
        _columnsCacheEntry.put("key", new TableInfo.Column("key", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("url", new TableInfo.Column("url", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("message", new TableInfo.Column("message", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("statusCode", new TableInfo.Column("statusCode", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("cacheFlags", new TableInfo.Column("cacheFlags", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("method", new TableInfo.Column("method", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("lastAccessed", new TableInfo.Column("lastAccessed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("lastValidated", new TableInfo.Column("lastValidated", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("integrity", new TableInfo.Column("integrity", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("responseHeaders", new TableInfo.Column("responseHeaders", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("storageUri", new TableInfo.Column("storageUri", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("storageSize", new TableInfo.Column("storageSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCacheEntry.put("uncompressedSize", new TableInfo.Column("uncompressedSize", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCacheEntry = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCacheEntry = new HashSet<TableInfo.Index>(2);
        _indicesCacheEntry.add(new TableInfo.Index("idx_lastAccessed", false, Arrays.asList("lastAccessed"), Arrays.asList("ASC")));
        _indicesCacheEntry.add(new TableInfo.Index("index_CacheEntry_integrity", false, Arrays.asList("integrity"), Arrays.asList("ASC")));
        final TableInfo _infoCacheEntry = new TableInfo("CacheEntry", _columnsCacheEntry, _foreignKeysCacheEntry, _indicesCacheEntry);
        final TableInfo _existingCacheEntry = TableInfo.read(db, "CacheEntry");
        if (!_infoCacheEntry.equals(_existingCacheEntry)) {
          return new RoomOpenHelper.ValidationResult(false, "CacheEntry(com.ustadmobile.libcache.db.entities.CacheEntry).\n"
                  + " Expected:\n" + _infoCacheEntry + "\n"
                  + " Found:\n" + _existingCacheEntry);
        }
        final HashMap<String, TableInfo.Column> _columnsRequestedEntry = new HashMap<String, TableInfo.Column>(4);
        _columnsRequestedEntry.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequestedEntry.put("requestSha256", new TableInfo.Column("requestSha256", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequestedEntry.put("requestedKey", new TableInfo.Column("requestedKey", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequestedEntry.put("batchId", new TableInfo.Column("batchId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysRequestedEntry = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesRequestedEntry = new HashSet<TableInfo.Index>(1);
        _indicesRequestedEntry.add(new TableInfo.Index("index_RequestedEntry_batchId", false, Arrays.asList("batchId"), Arrays.asList("ASC")));
        final TableInfo _infoRequestedEntry = new TableInfo("RequestedEntry", _columnsRequestedEntry, _foreignKeysRequestedEntry, _indicesRequestedEntry);
        final TableInfo _existingRequestedEntry = TableInfo.read(db, "RequestedEntry");
        if (!_infoRequestedEntry.equals(_existingRequestedEntry)) {
          return new RoomOpenHelper.ValidationResult(false, "RequestedEntry(com.ustadmobile.libcache.db.entities.RequestedEntry).\n"
                  + " Expected:\n" + _infoRequestedEntry + "\n"
                  + " Found:\n" + _existingRequestedEntry);
        }
        final HashMap<String, TableInfo.Column> _columnsRetentionLock = new HashMap<String, TableInfo.Column>(3);
        _columnsRetentionLock.put("lockId", new TableInfo.Column("lockId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRetentionLock.put("lockKey", new TableInfo.Column("lockKey", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRetentionLock.put("lockRemark", new TableInfo.Column("lockRemark", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysRetentionLock = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesRetentionLock = new HashSet<TableInfo.Index>(1);
        _indicesRetentionLock.add(new TableInfo.Index("idx_lockKey", false, Arrays.asList("lockKey"), Arrays.asList("ASC")));
        final TableInfo _infoRetentionLock = new TableInfo("RetentionLock", _columnsRetentionLock, _foreignKeysRetentionLock, _indicesRetentionLock);
        final TableInfo _existingRetentionLock = TableInfo.read(db, "RetentionLock");
        if (!_infoRetentionLock.equals(_existingRetentionLock)) {
          return new RoomOpenHelper.ValidationResult(false, "RetentionLock(com.ustadmobile.libcache.db.entities.RetentionLock).\n"
                  + " Expected:\n" + _infoRetentionLock + "\n"
                  + " Found:\n" + _existingRetentionLock);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "9e2777cdd51ec20188d84427eea050a4", "388cfee6067b506a5f2d38c4aa1a8722");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "CacheEntry","RequestedEntry","RetentionLock");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `CacheEntry`");
      _db.execSQL("DELETE FROM `RequestedEntry`");
      _db.execSQL("DELETE FROM `RetentionLock`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(CacheEntryDao.class, CacheEntryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(RequestedEntryDao.class, RequestedEntryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(RetentionLockDao.class, RetentionLockDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public CacheEntryDao getCacheEntryDao() {
    if (_cacheEntryDao != null) {
      return _cacheEntryDao;
    } else {
      synchronized(this) {
        if(_cacheEntryDao == null) {
          _cacheEntryDao = new CacheEntryDao_Impl(this);
        }
        return _cacheEntryDao;
      }
    }
  }

  @Override
  public RequestedEntryDao getRequestedEntryDao() {
    if (_requestedEntryDao != null) {
      return _requestedEntryDao;
    } else {
      synchronized(this) {
        if(_requestedEntryDao == null) {
          _requestedEntryDao = new RequestedEntryDao_Impl(this);
        }
        return _requestedEntryDao;
      }
    }
  }

  @Override
  public RetentionLockDao getRetentionLockDao() {
    if (_retentionLockDao != null) {
      return _retentionLockDao;
    } else {
      synchronized(this) {
        if(_retentionLockDao == null) {
          _retentionLockDao = new RetentionLockDao_Impl(this);
        }
        return _retentionLockDao;
      }
    }
  }
}
