/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.dao.RetentionLockDao;
import com.ustadmobile.libcache.db.entities.RetentionLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RetentionLockDao_Impl
extends RetentionLockDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<RetentionLock> __insertionAdapterOfRetentionLock;
    private final EntityInsertionAdapter<RetentionLock> __insertionAdapterOfRetentionLock_1;
    private final EntityDeletionOrUpdateAdapter<RetentionLock> __deletionAdapterOfRetentionLock;

    public RetentionLockDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRetentionLock = new EntityInsertionAdapter<RetentionLock>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `RetentionLock` (`lockId`,`lockKey`,`lockRemark`) VALUES (nullif(?, 0),?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull RetentionLock entity) {
                statement.bindLong(1, entity.getLockId());
                statement.bindString(2, entity.getLockKey());
                statement.bindString(3, entity.getLockRemark());
            }
        };
        this.__insertionAdapterOfRetentionLock_1 = new EntityInsertionAdapter<RetentionLock>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `RetentionLock` (`lockId`,`lockKey`,`lockRemark`) VALUES (nullif(?, 0),?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull RetentionLock entity) {
                statement.bindLong(1, entity.getLockId());
                statement.bindString(2, entity.getLockKey());
                statement.bindString(3, entity.getLockRemark());
            }
        };
        this.__deletionAdapterOfRetentionLock = new EntityDeletionOrUpdateAdapter<RetentionLock>(__db){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `RetentionLock` WHERE `lockId` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull RetentionLock entity) {
                statement.bindLong(1, entity.getLockId());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(RetentionLock retentionLock) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfRetentionLock.insertAndReturnId((Object)retentionLock);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void upsertList(List<RetentionLock> retentionLocks) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRetentionLock_1.insert(retentionLocks);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<RetentionLock> retentionLocks) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRetentionLock.handleMultiple(retentionLocks);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RetentionLock> findByBatchId(int batchId) {
        String _sql = "\n        SELECT RetentionLock.*\n          FROM RetentionLock\n         WHERE RetentionLock.lockKey IN \n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = ?)\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT RetentionLock.*\n          FROM RetentionLock\n         WHERE RetentionLock.lockKey IN \n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = ?)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)batchId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfLockId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lockId");
            int _cursorIndexOfLockKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lockKey");
            int _cursorIndexOfLockRemark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lockRemark");
            ArrayList<RetentionLock> _result = new ArrayList<RetentionLock>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpLockId = _cursor.getLong(_cursorIndexOfLockId);
                String _tmpLockKey = _cursor.getString(_cursorIndexOfLockKey);
                String _tmpLockRemark = _cursor.getString(_cursorIndexOfLockRemark);
                RetentionLock _item = new RetentionLock(_tmpLockId, _tmpLockKey, _tmpLockRemark);
                _result.add(_item);
            }
            ArrayList<RetentionLock> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RetentionLock> findByKey(String urlKey) {
        String _sql = "\n        SELECT RetentionLock.*\n          FROM RetentionLock\n         WHERE RetentionLock.lockKey = ? \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT RetentionLock.*\n          FROM RetentionLock\n         WHERE RetentionLock.lockKey = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, urlKey);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfLockId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lockId");
            int _cursorIndexOfLockKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lockKey");
            int _cursorIndexOfLockRemark = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lockRemark");
            ArrayList<RetentionLock> _result = new ArrayList<RetentionLock>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpLockId = _cursor.getLong(_cursorIndexOfLockId);
                String _tmpLockKey = _cursor.getString(_cursorIndexOfLockKey);
                String _tmpLockRemark = _cursor.getString(_cursorIndexOfLockRemark);
                RetentionLock _item = new RetentionLock(_tmpLockId, _tmpLockKey, _tmpLockRemark);
                _result.add(_item);
            }
            ArrayList<RetentionLock> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

