/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.dao.RequestedEntryDao;
import com.ustadmobile.libcache.db.entities.RequestedEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class RequestedEntryDao_Impl
extends RequestedEntryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<RequestedEntry> __insertionAdapterOfRequestedEntry;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBatch;

    public RequestedEntryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRequestedEntry = new EntityInsertionAdapter<RequestedEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `RequestedEntry` (`id`,`requestSha256`,`requestedKey`,`batchId`) VALUES (nullif(?, 0),?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull RequestedEntry entity) {
                statement.bindLong(1, (long)entity.getId());
                statement.bindString(2, entity.getRequestSha256());
                statement.bindString(3, entity.getRequestedKey());
                statement.bindLong(4, (long)entity.getBatchId());
            }
        };
        this.__preparedStmtOfDeleteBatch = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        DELETE FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ?    \n    ";
                return "\n        DELETE FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ?    \n    ";
            }
        };
    }

    @Override
    public void insertList(List<RequestedEntry> requestedSha256s) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRequestedEntry.insert(requestedSha256s);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<RequestedEntry> requestedSha256s, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                RequestedEntryDao_Impl.this.__db.beginTransaction();
                try {
                    RequestedEntryDao_Impl.this.__insertionAdapterOfRequestedEntry.insert((Iterable)requestedSha256s);
                    RequestedEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    RequestedEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBatch(int batchId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteBatch.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)batchId);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfDeleteBatch.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findKeysNotPresent(int batchId) {
        String _sql = "\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ? \n           AND NOT EXISTS(\n               SELECT CacheEntry.key\n                 FROM CacheEntry\n                WHERE CacheEntry.key = RequestedEntry.requestedKey\n           )\n        ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ? \n           AND NOT EXISTS(\n               SELECT CacheEntry.key\n                 FROM CacheEntry\n                WHERE CacheEntry.key = RequestedEntry.requestedKey\n           )\n        ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)batchId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

