package com.ustadmobile.libcache.db.dao

import com.ustadmobile.libcache.db.entities.CacheEntry
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List

public actual abstract class CacheEntryDao {
  public actual abstract suspend fun findByUrlAsync(url: String): CacheEntry?

  public actual abstract fun findEntryAndBodyByKey(key: String): CacheEntry?

  public actual abstract suspend fun insertAsync(entry: CacheEntry): Long

  public actual abstract fun insertList(entry: List<CacheEntry>)

  public actual abstract fun updateList(entry: List<CacheEntry>)

  public actual abstract fun upsertList(entry: List<CacheEntry>)

  public actual abstract fun findByRequestBatchId(batchId: Int): List<CacheEntry>

  public actual abstract fun findEntriesWithLock(batchId: Int): List<String>

  public actual abstract fun updateLastAccessedTime(key: String, lastAccessTime: Long)

  public actual abstract fun findEvictableEntries(batchSize: Int): List<CacheEntry>

  public actual abstract fun totalEvictableSize(): Long

  public actual abstract fun delete(entries: List<CacheEntry>)

  public actual abstract fun updateValidation(
    key: String,
    headers: String,
    lastValidated: Long,
    lastAccessed: Long,
  )
}
