package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.entities.RetentionLock;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class RetentionLockDao_Impl extends RetentionLockDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<RetentionLock> __insertionAdapterOfRetentionLock;

  private final EntityInsertionAdapter<RetentionLock> __insertionAdapterOfRetentionLock_1;

  private final EntityDeletionOrUpdateAdapter<RetentionLock> __deletionAdapterOfRetentionLock;

  public RetentionLockDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfRetentionLock = new EntityInsertionAdapter<RetentionLock>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `RetentionLock` (`lockId`,`lockKey`,`lockRemark`) VALUES (nullif(?, 0),?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RetentionLock entity) {
        statement.bindLong(1, entity.getLockId());
        statement.bindString(2, entity.getLockKey());
        statement.bindString(3, entity.getLockRemark());
      }
    };
    this.__insertionAdapterOfRetentionLock_1 = new EntityInsertionAdapter<RetentionLock>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `RetentionLock` (`lockId`,`lockKey`,`lockRemark`) VALUES (nullif(?, 0),?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RetentionLock entity) {
        statement.bindLong(1, entity.getLockId());
        statement.bindString(2, entity.getLockKey());
        statement.bindString(3, entity.getLockRemark());
      }
    };
    this.__deletionAdapterOfRetentionLock = new EntityDeletionOrUpdateAdapter<RetentionLock>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `RetentionLock` WHERE `lockId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RetentionLock entity) {
        statement.bindLong(1, entity.getLockId());
      }
    };
  }

  @Override
  public long insert(final RetentionLock retentionLock) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfRetentionLock.insertAndReturnId(retentionLock);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void upsertList(final List<RetentionLock> retentionLocks) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfRetentionLock_1.insert(retentionLocks);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final List<RetentionLock> retentionLocks) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfRetentionLock.handleMultiple(retentionLocks);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<RetentionLock> findByBatchId(final int batchId) {
    final String _sql = "\n"
            + "        SELECT RetentionLock.*\n"
            + "          FROM RetentionLock\n"
            + "         WHERE RetentionLock.lockKey IN \n"
            + "               (SELECT RequestedEntry.requestedKey\n"
            + "                  FROM RequestedEntry\n"
            + "                 WHERE RequestedEntry.batchId = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, batchId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLockId = CursorUtil.getColumnIndexOrThrow(_cursor, "lockId");
      final int _cursorIndexOfLockKey = CursorUtil.getColumnIndexOrThrow(_cursor, "lockKey");
      final int _cursorIndexOfLockRemark = CursorUtil.getColumnIndexOrThrow(_cursor, "lockRemark");
      final List<RetentionLock> _result = new ArrayList<RetentionLock>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final RetentionLock _item;
        final long _tmpLockId;
        _tmpLockId = _cursor.getLong(_cursorIndexOfLockId);
        final String _tmpLockKey;
        _tmpLockKey = _cursor.getString(_cursorIndexOfLockKey);
        final String _tmpLockRemark;
        _tmpLockRemark = _cursor.getString(_cursorIndexOfLockRemark);
        _item = new RetentionLock(_tmpLockId,_tmpLockKey,_tmpLockRemark);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<RetentionLock> findByKey(final String urlKey) {
    final String _sql = "\n"
            + "        SELECT RetentionLock.*\n"
            + "          FROM RetentionLock\n"
            + "         WHERE RetentionLock.lockKey = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, urlKey);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLockId = CursorUtil.getColumnIndexOrThrow(_cursor, "lockId");
      final int _cursorIndexOfLockKey = CursorUtil.getColumnIndexOrThrow(_cursor, "lockKey");
      final int _cursorIndexOfLockRemark = CursorUtil.getColumnIndexOrThrow(_cursor, "lockRemark");
      final List<RetentionLock> _result = new ArrayList<RetentionLock>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final RetentionLock _item;
        final long _tmpLockId;
        _tmpLockId = _cursor.getLong(_cursorIndexOfLockId);
        final String _tmpLockKey;
        _tmpLockKey = _cursor.getString(_cursorIndexOfLockKey);
        final String _tmpLockRemark;
        _tmpLockRemark = _cursor.getString(_cursorIndexOfLockRemark);
        _item = new RetentionLock(_tmpLockId,_tmpLockKey,_tmpLockRemark);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
